/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.data;

import com.justinmind.evc.model.actions.EVCImage;
import com.justinmind.evc.model.actions.SVGImage;
import com.justinmind.evc.model.businessObjects.ImageAttributeInstance;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.application.review.ReviewPaths;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.data.ModelDataMaster;
import com.justinmind.generator.context.data.ModelRecord;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.attributerenderer.StringRenderer;
import com.justinmind.generator.engine.output.JavaScriptStrategy;
import com.justinmind.generator.engine.output.OutputStrategy;
import com.justinmind.prototyper.api.ui.data.ICategory;
import com.justinmind.prototyper.api.ui.data.IDataMaster;
import com.justinmind.prototyper.api.ui.data.IRecord;
import com.justinmind.prototyper.api.ui.data.IRecordField;
import com.justinmind.prototyper.api.ui.data.IVariable;
import com.justinmind.prototyper.api.ui.event.ITarget;
import java.util.ArrayList;
import java.util.HashMap;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;

public final class DataController
extends ContextController {
    private static final String GROUP_URL = "com/justinmind/generator/context/data/DataView.stg";
    private static final String TEMPLATE = "Data";
    private static final String VARIABLES = "variables";
    private static final String MASTERS = "masters";
    private final transient String IMG_CROSSIMAGE;
    private transient Boolean append;

    public DataController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.IMG_CROSSIMAGE = String.valueOf(this.paths.resourcesReference) + "images/" + "common/crossimage.png";
        this.group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    protected OutputStrategy getOutputStrategy() {
        Object prettifyProperty = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.PRETTIFY);
        Boolean prettify = prettifyProperty instanceof Boolean ? (Boolean)prettifyProperty : true;
        Object appendProperty = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.APPENDJS);
        this.append = appendProperty instanceof Boolean ? (Boolean)appendProperty : false;
        return new JavaScriptStrategy(prettify, this.append);
    }

    @Override
    public void generate() throws GeneratorException {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (IVariable var : this.prototype.getApiVariables()) {
            variables.put(ControllerUtils.getName((ITarget)var), var.getApiDefaultValue());
        }
        ArrayList<ModelDataMaster> masters = new ArrayList<ModelDataMaster>();
        for (IDataMaster datamaster : this.prototype.getApiDataMasters()) {
            ModelDataMaster master = new ModelDataMaster(ControllerUtils.getName((ITarget)datamaster));
            Integer instanceCounter = 1;
            for (IRecord record : datamaster.getApiRecords()) {
                Integer n = instanceCounter;
                instanceCounter = n + 1;
                ModelRecord instance = new ModelRecord(n);
                for (IRecordField recordField : record.getApiFields()) {
                    String value;
                    if (recordField instanceof ImageAttributeInstance) {
                        EVCImage img = ((ImageAttributeInstance)recordField).getImage();
                        if (img == null) {
                            value = this.IMG_CROSSIMAGE;
                        } else {
                            String path = img instanceof SVGImage ? ((SVGImage)img).getSVGSystemFileName() : img.getSystemFileName();
                            value = Paths.getImagePath(this.paths.base, path);
                        }
                    } else {
                        value = recordField.getApiValue();
                    }
                    instance.add(ControllerUtils.getName((ITarget)recordField.getApiField()), value);
                }
                master.getRecords().add(instance);
            }
            for (ICategory category : datamaster.getApiCategories()) {
                ArrayList<String> values = new ArrayList<String>();
                for (String value : category.getApiValues()) {
                    values.add(value);
                }
                master.getCategories().put(ControllerUtils.getName((ITarget)category), values);
            }
            masters.add(master);
        }
        if (!variables.isEmpty() || !masters.isEmpty()) {
            ST context = this.group.getInstanceOf(TEMPLATE);
            context.add(VARIABLES, variables);
            context.add(MASTERS, masters);
            String fileName = this.append != false ? ReviewPaths.getPrototypeOutput(this.paths.output, this.applicationContext.getTime()) : Paths.getDataOutput(this.paths.output, this.applicationContext.getTime());
            this.outputEngine.write(fileName, context, this.strategy);
        }
    }
}

