/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.event;

import com.justinmind.evc.model.actions.SVGImage;
import com.justinmind.evc.model.businessLogic.FBOData;
import com.justinmind.evc.model.businessLogic.FPaginationData;
import com.justinmind.evc.model.businessLogic.values.ExpressionConstantImage;
import com.justinmind.evc.model.businessObjects.BusinessObject;
import com.justinmind.evc.model.events.Event;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.application.review.ReviewPaths;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.css.CssController;
import com.justinmind.generator.context.css.CssControllerIE;
import com.justinmind.generator.context.css.CssControllerIE8;
import com.justinmind.generator.context.css.CssRule;
import com.justinmind.generator.context.event.EventControllerUtils;
import com.justinmind.generator.context.event.ModelBlock;
import com.justinmind.generator.context.event.ModelCase;
import com.justinmind.generator.context.event.ModelCondition;
import com.justinmind.generator.context.event.ModelDelegate;
import com.justinmind.generator.context.event.ModelExpression;
import com.justinmind.generator.context.event.ModelExpressionArray;
import com.justinmind.generator.context.event.ModelExpressionObject;
import com.justinmind.generator.context.event.ModelExpressionStyle;
import com.justinmind.generator.context.event.ModelExpressionValue;
import com.justinmind.generator.context.event.ModelFirer;
import com.justinmind.generator.context.event.ModelLink;
import com.justinmind.generator.context.event.ModelLinkList;
import com.justinmind.generator.engine.Generator;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.attributerenderer.StringRenderer;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.generator.engine.output.JavaScriptStrategy;
import com.justinmind.generator.engine.output.OutputStrategy;
import com.justinmind.prototyper.api.ui.IStyle;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataGrid;
import com.justinmind.prototyper.api.ui.component.IDataGridCell;
import com.justinmind.prototyper.api.ui.component.IDataList;
import com.justinmind.prototyper.api.ui.component.IDataRow;
import com.justinmind.prototyper.api.ui.component.IDataView;
import com.justinmind.prototyper.api.ui.component.IImage;
import com.justinmind.prototyper.api.ui.component.IInput;
import com.justinmind.prototyper.api.ui.component.ILine;
import com.justinmind.prototyper.api.ui.component.IMenuNode;
import com.justinmind.prototyper.api.ui.data.IDataMaster;
import com.justinmind.prototyper.api.ui.data.IField;
import com.justinmind.prototyper.api.ui.data.IVariable;
import com.justinmind.prototyper.api.ui.event.EventType;
import com.justinmind.prototyper.api.ui.event.IBlock;
import com.justinmind.prototyper.api.ui.event.ICase;
import com.justinmind.prototyper.api.ui.event.ICondition;
import com.justinmind.prototyper.api.ui.event.IConstant;
import com.justinmind.prototyper.api.ui.event.IEvent;
import com.justinmind.prototyper.api.ui.event.IExpression;
import com.justinmind.prototyper.api.ui.event.IFunction;
import com.justinmind.prototyper.api.ui.event.IMutablePropertyOperand;
import com.justinmind.prototyper.api.ui.event.IOperand;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.prototyper.api.ui.event.MutablePropertyType;
import com.justinmind.prototyper.api.ui.event.action.IAction;
import com.justinmind.prototyper.api.ui.event.action.IBackwardNavigation;
import com.justinmind.prototyper.api.ui.event.action.IChangeStyle;
import com.justinmind.prototyper.api.ui.event.action.IEffectAction;
import com.justinmind.prototyper.api.ui.event.action.IExternalNavigation;
import com.justinmind.prototyper.api.ui.event.action.IInsertInto;
import com.justinmind.prototyper.api.ui.event.action.IInternalNavigation;
import com.justinmind.prototyper.api.ui.event.action.IMove;
import com.justinmind.prototyper.api.ui.event.action.INavigate;
import com.justinmind.prototyper.api.ui.event.action.IPagination;
import com.justinmind.prototyper.api.ui.event.action.IPause;
import com.justinmind.prototyper.api.ui.event.action.IRecordAction;
import com.justinmind.prototyper.api.ui.event.action.IResize;
import com.justinmind.prototyper.api.ui.event.action.IRotate;
import com.justinmind.prototyper.api.ui.event.action.IScrollTo;
import com.justinmind.prototyper.api.ui.event.action.ISetActivePanel;
import com.justinmind.prototyper.api.ui.event.action.ISetSelection;
import com.justinmind.prototyper.api.ui.event.action.ISetValue;
import com.justinmind.prototyper.api.ui.event.action.ITargetedAction;
import com.justinmind.prototyper.api.ui.event.effect.IEffect;
import com.justinmind.util.datamanage.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;

public final class EventController
extends ContextController {
    private static final String GROUP_URL = "com/justinmind/generator/context/event/EventView.stg";
    private static final String DELEGATES = "delegates";
    private static final String LINKS = "links";
    private static final String TEMPLATE_EVENT = "Event";
    private static final String TEMPLATE_EVENT_LINKS = "EventLinks";
    private static final String TEMPLATE_BLOCK = "Block";
    private static final String TEMPLATE_CASE = "Case";
    private static final String TEMPLATE_CONDITION = "Condition";
    private static final String TEMPLATE_DELEGATE = "Delegate";
    private static final String TEMPLATE_DELEGATE_RESTOREDRAG = "DelegateRestoreDrag";
    private static final String TEMPLATE_DELEGATE_DESTROYDRAG = "DelegateDestroyDrag";
    private static final String TEMPLATE_FIRER = "Firer";
    private static final String TEMPLATE_FIRER_TOGGLE = "FirerToggle";
    private static final String TEMPLATE_FIRER_MOUSELEAVE = "FirerMouseLeave";
    private static final String TEMPLATE_FIRER_MOUSEOVERENTER = "FirerMouseOverEnter";
    private static final String TEMPLATE_FIRER_MOUSEOVERLEAVE = "FirerMouseOverLeave";
    private static final String TEMPLATE_FIRER_KEY = "FirerKey";
    private static final String EVENT_DRAGENTER = "dragenter";
    private static final String EVENT_DRAGLEAVE = "dragleave";
    private static final String IS_MOUSEOVER_LEAVE = "is_mouseover_leave";
    private static final String INVALID_PARAMETER_COUNT = "invalid parameter count";
    private static final String EXTERNAL_PROTOCOL = "(((mailto|tel)\\:|(news|(ht|f)tp(s?)|gopher|telnet|file|notes|ms-help)\\://){1}\\S+)";
    private final transient EventControllerUtils utils = new EventControllerUtils();
    private transient Boolean append;

    public EventController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    protected OutputStrategy getOutputStrategy() {
        Object prettifyProperty = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.PRETTIFY);
        Boolean prettify = prettifyProperty instanceof Boolean ? (Boolean)prettifyProperty : true;
        Object appendProperty = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.APPENDJS);
        this.append = appendProperty instanceof Boolean ? (Boolean)appendProperty : false;
        return new JavaScriptStrategy(prettify, this.append);
    }

    @Override
    public void generate() throws GeneratorException {
        ArrayList<ModelLinkList> links = new ArrayList<ModelLinkList>();
        for (ICanvas canvas : this.prototype.getApiCanvases()) {
            List events = canvas.getApiAllEvents();
            if (events.isEmpty()) continue;
            String fileName = this.append != false ? ReviewPaths.getPrototypeOutput(this.paths.output, this.applicationContext.getTime()) : Paths.getCanvasOutput(this.paths.output, canvas, this.applicationContext.getTime()).append(".js").toString();
            ST context = this.group.getInstanceOf(TEMPLATE_EVENT);
            context.add(DELEGATES, this.processDelegates(canvas, events));
            this.outputEngine.write(fileName, context, this.strategy);
            List<ModelLink> canvasLinks = this.processLinks(canvas);
            links.add(new ModelLinkList(canvas.getApiId(), canvasLinks));
        }
        String fileName = String.valueOf(this.paths.output) + "resources/" + "scenarios/" + "function-jim-links" + this.applicationContext.getTime() + ".js";
        ST context = this.group.getInstanceOf(TEMPLATE_EVENT_LINKS);
        context.add(LINKS, links);
        this.outputEngine.write(fileName, context, this.strategy);
    }

    private List<ModelLink> processLinks(ICanvas canvas) {
        ArrayList<ModelLink> links = new ArrayList<ModelLink>();
        for (IComponent component : canvas.getApiRoot().getApiChildren()) {
            this.processItemLinks(component, links);
        }
        return links;
    }

    private void processItemLinks(IComponent c, List<ModelLink> links) {
        String itemId = c.getApiId();
        ArrayList<String> screens = new ArrayList<String>();
        for (IEvent event : c.getApiEvents()) {
            for (ICase eventCase : event.getApiCases()) {
                for (IBlock block : eventCase.getApiBlocks()) {
                    for (IAction action : block.getApiActions()) {
                        if (!(action instanceof IInternalNavigation)) continue;
                        screens.add(((IInternalNavigation)action).getApiScreen().getApiId());
                    }
                }
            }
        }
        if (!screens.isEmpty()) {
            links.add(new ModelLink(itemId, screens));
        }
        for (IComponent component : c.getApiChildren()) {
            this.processItemLinks(component, links);
        }
    }

    private List<ModelDelegate> processDelegates(ICanvas canvas, List<IEvent> events) {
        ArrayList<ModelDelegate> contexts = new ArrayList<ModelDelegate>();
        String canvasName = "." + ControllerUtils.getID((IComponent)canvas.getApiRoot());
        ArrayList<IEvent> onClick = new ArrayList<IEvent>();
        ArrayList<IEvent> onMouseUp = new ArrayList<IEvent>();
        ArrayList<IEvent> onMouseDown = new ArrayList<IEvent>();
        ArrayList<IEvent> onDblClick = new ArrayList<IEvent>();
        ArrayList<IEvent> onRightClick = new ArrayList<IEvent>();
        ArrayList<IEvent> onToggle = new ArrayList<IEvent>();
        ArrayList<IEvent> onDragStart = new ArrayList<IEvent>();
        ArrayList<IEvent> onDrag = new ArrayList<IEvent>();
        ArrayList<IEvent> onDragEnd = new ArrayList<IEvent>();
        ArrayList<IEvent> onKeyUp = new ArrayList<IEvent>();
        ArrayList<IEvent> onKeyDown = new ArrayList<IEvent>();
        ArrayList<IEvent> onLoad = new ArrayList<IEvent>();
        ArrayList<IEvent> onUnload = new ArrayList<IEvent>();
        ArrayList<IEvent> onChange = new ArrayList<IEvent>();
        ArrayList<IEvent> onFocusIn = new ArrayList<IEvent>();
        ArrayList<IEvent> onFocusOut = new ArrayList<IEvent>();
        ArrayList<IEvent> onMouseEnter = new ArrayList<IEvent>();
        ArrayList<IEvent> onMouseOverEnter = new ArrayList<IEvent>();
        ArrayList<IEvent> onMouseLeave = new ArrayList<IEvent>();
        ArrayList<IEvent> onMouseOverLeave = new ArrayList<IEvent>();
        ArrayList<IEvent> onSwipeUp = new ArrayList<IEvent>();
        ArrayList<IEvent> onSwipeDown = new ArrayList<IEvent>();
        ArrayList<IEvent> onSwipeLeftUp = new ArrayList<IEvent>();
        ArrayList<IEvent> onSwipeLeft = new ArrayList<IEvent>();
        ArrayList<IEvent> onSwipeLeftDown = new ArrayList<IEvent>();
        ArrayList<IEvent> onSwipeRightUp = new ArrayList<IEvent>();
        ArrayList<IEvent> onSwipeRight = new ArrayList<IEvent>();
        ArrayList<IEvent> onSwipeRightDown = new ArrayList<IEvent>();
        ArrayList<IEvent> onPinchOpen = new ArrayList<IEvent>();
        ArrayList<IEvent> onPinchClose = new ArrayList<IEvent>();
        ArrayList<IEvent> onRotateLeft = new ArrayList<IEvent>();
        ArrayList<IEvent> onRotateRight = new ArrayList<IEvent>();
        ArrayList<IEvent> onTapHold = new ArrayList<IEvent>();
        ArrayList<IEvent> onOrientationPortrait = new ArrayList<IEvent>();
        ArrayList<IEvent> onOrientationLandscape = new ArrayList<IEvent>();
        ArrayList<IEvent> onWindowResize = new ArrayList<IEvent>();
        ArrayList<IEvent> onWindowScroll = new ArrayList<IEvent>();
        ArrayList<IEvent> onVariableChange = new ArrayList<IEvent>();
        ArrayList<IEvent> onDataChange = new ArrayList<IEvent>();
        ArrayList<IEvent> onPanelChange = new ArrayList<IEvent>();
        Boolean clickInDataRow = false;
        block41: for (IEvent event : events) {
            IComponent firer = event.getApiFirer();
            if (this.applicationContext.isMobile().booleanValue() && firer instanceof IMenuNode && ((IMenuNode)firer).getApiParent() != null) continue;
            switch (event.getApiEventType()) {
                case ON_CLICK: {
                    onClick.add(event);
                    if (clickInDataRow.booleanValue()) break;
                    clickInDataRow = firer instanceof IDataRow || Utils.hasParent((IComponent)firer, IDataRow.class) != false;
                    break;
                }
                case ON_MOUSE_UP: {
                    if (this.applicationContext.isMobile().booleanValue()) break;
                    onMouseUp.add(event);
                    break;
                }
                case ON_MOUSE_DOWN: {
                    if (this.applicationContext.isMobile().booleanValue()) break;
                    onMouseDown.add(event);
                    break;
                }
                case ON_DOUBLE_CLICK: {
                    if (this.applicationContext.isMobile().booleanValue()) break;
                    onDblClick.add(event);
                    break;
                }
                case ON_RIGHT_CLICK: {
                    if (this.applicationContext.isMobile().booleanValue()) break;
                    onRightClick.add(event);
                    break;
                }
                case ON_TOGGLE: {
                    onToggle.add(event);
                    break;
                }
                case ON_DRAG_START: {
                    onDragStart.add(event);
                    break;
                }
                case ON_DRAG: {
                    onDrag.add(event);
                    break;
                }
                case ON_DRAG_END: {
                    onDragEnd.add(event);
                    break;
                }
                case ON_KEY_UP: {
                    if (this.applicationContext.isMobile().booleanValue() && (!(firer instanceof IInput) || ((IInput)firer).getApiInputType().equals((Object)IInput.ApiInputType.CHECKBOX) || ((IInput)firer).getApiInputType().equals((Object)IInput.ApiInputType.RADIOBUTTON))) continue block41;
                    onKeyUp.add(event);
                    break;
                }
                case ON_KEY_DOWN: {
                    if (this.applicationContext.isMobile().booleanValue()) break;
                    onKeyDown.add(event);
                    break;
                }
                case ON_PAGE_LOAD: {
                    onLoad.add(event);
                    break;
                }
                case ON_PAGE_UNLOAD: {
                    onUnload.add(event);
                    break;
                }
                case ON_CHANGE: {
                    onChange.add(event);
                    break;
                }
                case ON_FOCUS_IN: {
                    onFocusIn.add(event);
                    break;
                }
                case ON_FOCUS_OUT: {
                    onFocusOut.add(event);
                    break;
                }
                case ON_MOUSE_ENTER: {
                    if (this.applicationContext.isMobile().booleanValue()) break;
                    onMouseEnter.add(event);
                    break;
                }
                case ON_MOUSE_LEAVE: {
                    if (this.applicationContext.isMobile().booleanValue()) break;
                    onMouseLeave.add(event);
                    break;
                }
                case ON_MOUSE_OVER: {
                    if (this.applicationContext.isMobile().booleanValue()) break;
                    onMouseOverEnter.add(event);
                    Event leaveEvent = new Event(EventType.ON_MOUSE_OVER, ((Event)event).getModel());
                    leaveEvent.setData(IS_MOUSEOVER_LEAVE, (Object)true);
                    onMouseOverLeave.add((IEvent)leaveEvent);
                    break;
                }
                case ON_SWIPE_UP: {
                    onSwipeUp.add(event);
                    break;
                }
                case ON_SWIPE_DOWN: {
                    onSwipeDown.add(event);
                    break;
                }
                case ON_SWIPE_LEFTUP: {
                    onSwipeLeftUp.add(event);
                    break;
                }
                case ON_SWIPE_LEFT: {
                    onSwipeLeft.add(event);
                    break;
                }
                case ON_SWIPE_LEFTDOWN: {
                    onSwipeLeftDown.add(event);
                    break;
                }
                case ON_SWIPE_RIGHTUP: {
                    onSwipeRightUp.add(event);
                    break;
                }
                case ON_SWIPE_RIGHT: {
                    onSwipeRight.add(event);
                    break;
                }
                case ON_SWIPE_RIGHTDOWN: {
                    onSwipeRightDown.add(event);
                    break;
                }
                case ON_PINCH_OPEN: {
                    onPinchOpen.add(event);
                    break;
                }
                case ON_PINCH_CLOSE: {
                    onPinchClose.add(event);
                    break;
                }
                case ON_ROTATE_LEFT: {
                    onRotateLeft.add(event);
                    break;
                }
                case ON_ROTATE_RIGHT: {
                    onRotateRight.add(event);
                    break;
                }
                case ON_TAPHOLD: {
                    onTapHold.add(event);
                    break;
                }
                case ON_ORIENTATION_PORTRAIT: {
                    onOrientationPortrait.add(event);
                    break;
                }
                case ON_ORIENTATION_LANDSCAPE: {
                    onOrientationLandscape.add(event);
                    break;
                }
                case ON_WINDOW_RESIZE: {
                    onWindowResize.add(event);
                    break;
                }
                case ON_WINDOW_SCROLL: {
                    onWindowScroll.add(event);
                    break;
                }
                case ON_VARIABLE_CHANGE: {
                    onVariableChange.add(event);
                    break;
                }
                case ON_DATA_CHANGE: {
                    onDataChange.add(event);
                    break;
                }
                case ON_PANEL_ACTIVE: {
                    onPanelChange.add(event);
                    break;
                }
            }
        }
        if (!onClick.isEmpty()) {
            ModelDelegate onClickCon = new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_CLICK), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_CLICK), this.processFirer(onClick));
            onClickCon.isClickInDataRow = clickInDataRow;
            contexts.add(onClickCon);
        }
        if (!onMouseUp.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_MOUSE_UP), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_MOUSE_UP), this.processFirer(onMouseUp)));
        }
        if (!onMouseDown.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_MOUSE_DOWN), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_MOUSE_DOWN), this.processFirer(onMouseDown)));
        }
        if (!onDblClick.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, "dblclick", false, this.utils.buildDelegateSelector(canvasName, EventType.ON_DOUBLE_CLICK), this.processFirer(onDblClick)));
        }
        if (!onRightClick.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_RIGHT_CLICK), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_RIGHT_CLICK), this.processFirer(onRightClick)));
        }
        if (!onToggle.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_CLICK), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_TOGGLE), this.processFirer(onToggle)));
        }
        if (!onDragStart.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_DRAG_START), true, this.utils.buildDelegateSelector(canvasName, EventType.ON_DRAG_START), this.processFirer(onDragStart)));
        }
        if (!onDrag.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_DRAG), true, this.utils.buildDelegateSelector(canvasName, EventType.ON_DRAG), this.processFirer(onDrag)));
        }
        if (!onDrag.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE_RESTOREDRAG, ControllerUtils.typeToString(EventType.ON_DRAG_END), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_DRAG), null));
        }
        if (!onDragEnd.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_DRAG_END), true, this.utils.buildDelegateSelector(canvasName, EventType.ON_DRAG_END), this.processFirer(onDragEnd)));
        }
        if (!onDrag.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE_DESTROYDRAG, ControllerUtils.typeToString(EventType.ON_DRAG_END), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_DRAG), null));
        }
        if (!onKeyUp.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, "keyup.jim", false, this.utils.buildDelegateSelector(canvasName, EventType.ON_KEY_UP), this.processFirer(onKeyUp)));
        }
        if (!onKeyDown.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, "keydown.jim", false, this.utils.buildDelegateSelector(canvasName, EventType.ON_KEY_DOWN), this.processFirer(onKeyDown)));
        }
        if (!onLoad.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_PAGE_LOAD), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_PAGE_LOAD), this.processFirer(onLoad)));
        }
        if (!onUnload.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_PAGE_UNLOAD), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_PAGE_UNLOAD), this.processFirer(onUnload)));
        }
        if (!onChange.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_CHANGE), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_CHANGE), this.processFirer(onChange)));
        }
        if (!onFocusIn.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_FOCUS_IN), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_FOCUS_IN), this.processFirer(onFocusIn)));
        }
        if (!onFocusOut.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_FOCUS_OUT), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_FOCUS_OUT), this.processFirer(onFocusOut)));
        }
        if (!onMouseEnter.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, String.valueOf(ControllerUtils.typeToString(EventType.ON_MOUSE_ENTER)) + " " + EVENT_DRAGENTER, true, this.utils.buildDelegateSelector(canvasName, EventType.ON_MOUSE_ENTER), this.processFirer(onMouseEnter)));
        }
        if (!onMouseLeave.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, String.valueOf(ControllerUtils.typeToString(EventType.ON_MOUSE_LEAVE)) + " " + EVENT_DRAGLEAVE, true, this.utils.buildDelegateSelector(canvasName, EventType.ON_MOUSE_LEAVE), this.processFirer(onMouseLeave)));
        }
        if (!onMouseOverEnter.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, String.valueOf(ControllerUtils.typeToString(EventType.ON_MOUSE_ENTER)) + " " + EVENT_DRAGENTER, true, this.utils.buildDelegateSelector(canvasName, EventType.ON_MOUSE_ENTER), this.processFirer(onMouseOverEnter)));
        }
        if (!onMouseOverLeave.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, String.valueOf(ControllerUtils.typeToString(EventType.ON_MOUSE_LEAVE)) + " " + EVENT_DRAGLEAVE, true, this.utils.buildDelegateSelector(canvasName, EventType.ON_MOUSE_LEAVE), this.processFirer(onMouseOverLeave)));
        }
        if (!onSwipeUp.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_SWIPE_UP), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_SWIPE_UP), this.processFirer(onSwipeUp)));
        }
        if (!onSwipeDown.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_SWIPE_DOWN), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_SWIPE_DOWN), this.processFirer(onSwipeDown)));
        }
        if (!onSwipeLeftUp.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_SWIPE_LEFTUP), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_SWIPE_LEFTUP), this.processFirer(onSwipeLeftUp)));
        }
        if (!onSwipeLeft.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_SWIPE_LEFT), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_SWIPE_LEFT), this.processFirer(onSwipeLeft)));
        }
        if (!onSwipeLeftDown.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_SWIPE_LEFTDOWN), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_SWIPE_LEFTDOWN), this.processFirer(onSwipeLeftDown)));
        }
        if (!onSwipeRightUp.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHTUP), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_SWIPE_RIGHTUP), this.processFirer(onSwipeRightUp)));
        }
        if (!onSwipeRight.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHT), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_SWIPE_RIGHT), this.processFirer(onSwipeRight)));
        }
        if (!onSwipeRightDown.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHTDOWN), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_SWIPE_RIGHTDOWN), this.processFirer(onSwipeRightDown)));
        }
        if (!onPinchOpen.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_PINCH_OPEN), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_PINCH_OPEN), this.processFirer(onPinchOpen)));
        }
        if (!onPinchClose.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_PINCH_CLOSE), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_PINCH_CLOSE), this.processFirer(onPinchClose)));
        }
        if (!onRotateLeft.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_ROTATE_LEFT), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_ROTATE_LEFT), this.processFirer(onRotateLeft)));
        }
        if (!onRotateRight.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_ROTATE_RIGHT), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_ROTATE_RIGHT), this.processFirer(onRotateRight)));
        }
        if (!onTapHold.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_TAPHOLD), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_TAPHOLD), this.processFirer(onTapHold)));
        }
        if (!onOrientationPortrait.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_ORIENTATION_PORTRAIT), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_ORIENTATION_PORTRAIT), this.processFirer(onOrientationPortrait)));
        }
        if (!onOrientationLandscape.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_ORIENTATION_LANDSCAPE), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_ORIENTATION_LANDSCAPE), this.processFirer(onOrientationLandscape)));
        }
        if (!onWindowResize.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_WINDOW_RESIZE), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_WINDOW_RESIZE), this.processFirer(onWindowResize)));
        }
        if (!onWindowScroll.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_WINDOW_SCROLL), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_WINDOW_SCROLL), this.processFirer(onWindowScroll)));
        }
        if (!onVariableChange.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, String.valueOf(ControllerUtils.typeToString(EventType.ON_VARIABLE_CHANGE)) + ".jim", false, this.utils.buildDelegateSelector(canvasName, EventType.ON_VARIABLE_CHANGE), this.processFirer(onVariableChange)));
        }
        if (!onDataChange.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_DATA_CHANGE), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_DATA_CHANGE), this.processFirer(onDataChange)));
        }
        if (!onPanelChange.isEmpty()) {
            contexts.add(new ModelDelegate(TEMPLATE_DELEGATE, ControllerUtils.typeToString(EventType.ON_PANEL_ACTIVE), false, this.utils.buildDelegateSelector(canvasName, EventType.ON_PANEL_ACTIVE), this.processFirer(onPanelChange)));
        }
        return contexts;
    }

    private List<ModelFirer> processFirer(List<IEvent> events) {
        ArrayList<ModelFirer> contexts = new ArrayList<ModelFirer>();
        for (IEvent event : events) {
            IComponent firer = event.getApiFirer();
            String selector = this.utils.getEventElementName((ITarget)firer);
            List<ModelCase> cases = this.processCases(event);
            switch (event.getApiEventType()) {
                case ON_TOGGLE: {
                    contexts.add(new ModelFirer(TEMPLATE_FIRER_TOGGLE, selector, cases));
                    break;
                }
                case ON_MOUSE_OVER: {
                    Object isMouseOverLeave = ((Event)event).getData(IS_MOUSEOVER_LEAVE);
                    if (isMouseOverLeave != null && ((Boolean)isMouseOverLeave).booleanValue()) {
                        contexts.add(new ModelFirer(TEMPLATE_FIRER_MOUSEOVERLEAVE, selector, null));
                        break;
                    }
                    contexts.add(new ModelFirer(TEMPLATE_FIRER_MOUSEOVERENTER, selector, cases));
                    break;
                }
                case ON_MOUSE_LEAVE: {
                    contexts.add(new ModelFirer(TEMPLATE_FIRER_MOUSELEAVE, selector, cases));
                    break;
                }
                case ON_KEY_DOWN: {
                    contexts.add(new ModelFirer(TEMPLATE_FIRER_KEY, selector, cases));
                    break;
                }
                case ON_KEY_UP: {
                    contexts.add(new ModelFirer(TEMPLATE_FIRER_KEY, selector, cases));
                    break;
                }
                default: {
                    contexts.add(new ModelFirer(TEMPLATE_FIRER, selector, cases));
                }
            }
        }
        return contexts;
    }

    private List<ModelCase> processCases(IEvent event) {
        ArrayList<ModelCase> contexts = new ArrayList<ModelCase>();
        for (ICase eventCase : event.getApiCases()) {
            ModelCase modelCase = new ModelCase(TEMPLATE_CASE, this.processBlocks(eventCase));
            modelCase.exectype = eventCase.getApiCaseExecutionType().getName();
            modelCase.delay = eventCase.getApiExecutionDelay();
            contexts.add(modelCase);
        }
        return contexts;
    }

    private List<ModelBlock> processBlocks(ICase eventCase) {
        ArrayList<ModelBlock> contexts = new ArrayList<ModelBlock>();
        for (IBlock block : eventCase.getApiBlocks()) {
            contexts.add(new ModelBlock(TEMPLATE_BLOCK, this.processCondition(block), this.processActions(block)));
        }
        return contexts;
    }

    private ModelCondition processCondition(IBlock block) {
        ModelCondition context = new ModelCondition(TEMPLATE_CONDITION);
        ICondition condition = block.getApiCondition();
        IComponent dropTarget = condition.getApiDropTarget();
        Integer keyCode = condition.getApiKeyCode();
        IExpression expression = condition.getApiExpression();
        IVariable variable = condition.getApiVariableTarget();
        if (dropTarget != null) {
            context.dropTarget = this.utils.getEventElementName((ITarget)dropTarget);
        } else if (keyCode != null && !keyCode.equals(ICondition.API_ANYKEY)) {
            context.whichKey = keyCode;
            context.hasCtrl = condition.hasApiControlKey();
            context.hasShift = condition.hasApiShiftKey();
            context.hasAlt = condition.hasApiAltKey();
        }
        if (expression != null) {
            context.expression = this.processExpression(expression);
        }
        if (variable != null) {
            context.variableTarget = this.utils.getEventElementName((ITarget)variable);
        }
        return context;
    }

    private List<ModelExpression> processActions(IBlock block) {
        ArrayList<ModelExpression> contexts = new ArrayList<ModelExpression>();
        for (IAction action : block.getApiActions()) {
            contexts.add(this.processAction(action));
        }
        return contexts;
    }

    private ModelExpression processAction(IAction action) {
        ModelExpressionObject context = new ModelExpressionObject();
        context.add(ModelExpressionObject.Attribute.ACTION, (Object)this.utils.getFunctionName(action));
        context.add(ModelExpressionObject.Attribute.PARAMETER, (Object)this.processActionParameter(action));
        context.add(ModelExpressionObject.Attribute.EXECTYPE, (Object)action.getApiActionExecutionType().getName());
        context.add(ModelExpressionObject.Attribute.DELAY, (Object)action.getApiExecutionDelay());
        return context;
    }

    private ModelExpression processActionParameter(IAction action) {
        ModelExpression context = null;
        TypeAdaptor.ActionType type = TypeAdaptor.getActionType(action);
        switch (type) {
            case RECORDACTION: {
                context = this.processFunctionParameter(((IRecordAction)action).getApiFunction());
                break;
            }
            case PAGINATION: {
                context = this.processFunctionParameter(((IPagination)action).getApiFunction());
                break;
            }
            case CHANGESTYLE: {
                ITarget styleTarget = ((ITargetedAction)action).getApiTarget();
                IStyle style = ((IChangeStyle)action).getApiStyle();
                ModelExpressionArray rules = new ModelExpressionArray();
                CssController styleController = new CssController(this.applicationContext);
                for (CssRule rule : styleController.processCssRules((IComponent)styleTarget, style, false)) {
                    if (rule.isEmpty()) continue;
                    ModelExpressionStyle eventRule = new ModelExpressionStyle(rule.getSelector());
                    eventRule.add(ModelExpressionStyle.StyleRule.ATTRIBUTES, rule.getAttributes());
                    eventRule.add(ModelExpressionStyle.StyleRule.EXPRESSIONS, rule.getExpressions());
                    rules.add(eventRule);
                }
                CssControllerIE styleControllerIE = new CssControllerIE(this.applicationContext);
                for (CssRule rule : ((CssController)styleControllerIE).processCssRules((IComponent)styleTarget, style, false)) {
                    if (rule.isEmpty()) continue;
                    ModelExpressionStyle eventRule = new ModelExpressionStyle(rule.getSelector());
                    eventRule.add(ModelExpressionStyle.StyleRule.ATTRIBUTES_IE, rule.getAttributes());
                    eventRule.add(ModelExpressionStyle.StyleRule.EXPRESSIONS_IE, rule.getExpressions());
                    rules.add(eventRule);
                }
                CssControllerIE8 styleControllerIELTE8 = new CssControllerIE8(this.applicationContext);
                for (CssRule rule : ((CssController)styleControllerIELTE8).processCssRules((IComponent)styleTarget, style, false)) {
                    if (rule.isEmpty()) continue;
                    ModelExpressionStyle eventRule = new ModelExpressionStyle(rule.getSelector());
                    eventRule.add(ModelExpressionStyle.StyleRule.ATTRIBUTES_IE_LTE8, rule.getAttributes());
                    eventRule.add(ModelExpressionStyle.StyleRule.EXPRESSIONS_IE_LTE8, rule.getExpressions());
                    rules.add(eventRule);
                }
                context = rules;
                break;
            }
            default: {
                ModelExpressionObject parameter = new ModelExpressionObject();
                block6 : switch (type) {
                    case INTERNALNAVIGATION: {
                        try {
                            IInternalNavigation navigation = (IInternalNavigation)action;
                            parameter.add(ModelExpressionObject.Attribute.TARGET, (Object)Paths.getCanvasURL((ICanvas)navigation.getApiScreen()));
                            this.utils.addTransition(parameter, navigation.getApiTransition());
                            if (navigation.isApiPopup().booleanValue()) {
                                parameter.add(ModelExpressionObject.Attribute.POPUP, (Object)this.processActionSubParameter(action));
                                break;
                            }
                            if (!navigation.isApiNewTab().booleanValue()) break;
                            parameter.add(ModelExpressionObject.Attribute.TAB, (Object)navigation.isApiNewTab());
                        }
                        catch (Exception e) {
                            Generator.LOG.error((Object)"no target found", (Throwable)e);
                        }
                        break;
                    }
                    case EXTERNALNAVIGATION: {
                        IExternalNavigation eNavigation = (IExternalNavigation)action;
                        parameter.add(ModelExpressionObject.Attribute.ISEXTERNAL, (Object)true);
                        StringBuilder url = new StringBuilder(eNavigation.getApiURL().replaceAll("\"", "'"));
                        if (!Pattern.compile(EXTERNAL_PROTOCOL).matcher(url).find()) {
                            url.insert(0, "http://");
                        }
                        parameter.add(ModelExpressionObject.Attribute.TARGET, (Object)url.toString());
                        if (eNavigation.isApiPopup().booleanValue()) {
                            parameter.add(ModelExpressionObject.Attribute.POPUP, (Object)this.processActionSubParameter(action));
                            break;
                        }
                        if (!eNavigation.isApiNewTab().booleanValue()) break;
                        parameter.add(ModelExpressionObject.Attribute.TAB, (Object)eNavigation.isApiNewTab());
                        break;
                    }
                    case BACKWARDNAVIGATION: {
                        IBackwardNavigation bNavigation = (IBackwardNavigation)action;
                        parameter.add(ModelExpressionObject.Attribute.ISBACKWARD, (Object)true);
                        this.utils.addTransition(parameter, bNavigation.getApiTransition());
                        if (bNavigation.isApiPopup().booleanValue()) {
                            parameter.add(ModelExpressionObject.Attribute.POPUP, (Object)this.processActionSubParameter(action));
                            break;
                        }
                        if (!bNavigation.isApiNewTab().booleanValue()) break;
                        parameter.add(ModelExpressionObject.Attribute.TAB, (Object)bNavigation.isApiNewTab());
                        break;
                    }
                    case PAUSE: {
                        parameter.add(ModelExpressionObject.Attribute.PAUSE, (Object)((IPause)action).getApiDelay());
                        break;
                    }
                    case DISPLAY: 
                    case SETACTIVEPANEL: 
                    case MOVE: 
                    case RESIZE: 
                    case INSERTINTO: 
                    case SETSELECTION: 
                    case SETVALUE: 
                    case SETFOCUS: 
                    case SCROLLTO: 
                    case ENABLEINPUT: 
                    case ROTATE: {
                        ITarget target = ((ITargetedAction)action).getApiTarget();
                        parameter.add(ModelExpressionObject.Attribute.TARGET, (Object)this.utils.getEventElementName(target));
                        switch (type) {
                            case DISPLAY: {
                                parameter.add(ModelExpressionObject.Attribute.EFFECT, (Object)this.processActionSubParameter(action));
                                break block6;
                            }
                            case SCROLLTO: {
                                parameter.add(ModelExpressionObject.Attribute.AXIS, (Object)ControllerUtils.typeToString(((IScrollTo)action).getApiScrollType()));
                                parameter.add(ModelExpressionObject.Attribute.EFFECT, (Object)this.processActionSubParameter(action));
                                break block6;
                            }
                            case SETACTIVEPANEL: {
                                this.utils.addTransition(parameter, ((ISetActivePanel)action).getApiTransition());
                                break block6;
                            }
                            case MOVE: {
                                IMove moveAction = (IMove)action;
                                Map options = moveAction.getApiMoveOptions();
                                IExpression topValue = ((IMove)action).getApiTop();
                                ModelExpressionObject topContext = new ModelExpressionObject();
                                topContext.add(ModelExpressionObject.Attribute.TYPE, (Object)ControllerUtils.typeToString(((IMove)action).getApiTopMoveType()));
                                if (((IMove)action).getApiTopMoveType() != IMove.ApiMoveType.NO_MOVE) {
                                    topContext.add(ModelExpressionObject.Attribute.VALUE, (Object)this.processExpression(topValue));
                                }
                                parameter.add(ModelExpressionObject.Attribute.TOP, (Object)topContext);
                                IExpression leftValue = ((IMove)action).getApiLeft();
                                ModelExpressionObject leftContext = new ModelExpressionObject();
                                leftContext.add(ModelExpressionObject.Attribute.TYPE, (Object)ControllerUtils.typeToString(((IMove)action).getApiLeftMoveType()));
                                if (((IMove)action).getApiLeftMoveType() != IMove.ApiMoveType.NO_MOVE) {
                                    leftContext.add(ModelExpressionObject.Attribute.VALUE, (Object)this.processExpression(leftValue));
                                }
                                parameter.add(ModelExpressionObject.Attribute.LEFT, (Object)leftContext);
                                parameter.add(ModelExpressionObject.Attribute.CONTAINMENT, options.get(IMove.ApiMoveOption.CONTAINMENT));
                                parameter.add(ModelExpressionObject.Attribute.EFFECT, (Object)this.processActionSubParameter(action));
                                break block6;
                            }
                            case INSERTINTO: {
                                parameter.add(ModelExpressionObject.Attribute.PARENT, (Object)this.utils.getEventElementName((ITarget)((IInsertInto)action).getApiTargetContainer()));
                                break block6;
                            }
                            case SETSELECTION: {
                                parameter.add(ModelExpressionObject.Attribute.VALUE, (Object)this.processExpression(((ISetSelection)action).getApiValue()));
                                break block6;
                            }
                            case SETVALUE: {
                                IExpression aeiValue = ((ISetValue)action).getApiValue();
                                if (target instanceof IVariable) {
                                    parameter.remove(ModelExpressionObject.Attribute.TARGET);
                                    parameter.add(ModelExpressionObject.Attribute.VARIABLE, (Object)ControllerUtils.getName(target));
                                }
                                parameter.add(ModelExpressionObject.Attribute.VALUE, (Object)this.processExpression(aeiValue));
                                if (!(target instanceof IImage) || !(aeiValue instanceof ExpressionConstantImage) || !(((ExpressionConstantImage)aeiValue).getEVCImage() instanceof SVGImage) || !(((ExpressionConstantImage)aeiValue).getEVCImage() instanceof SVGImage) || !((SVGImage)((ExpressionConstantImage)aeiValue).getEVCImage()).isPreserveAspectRatio()) break block6;
                                parameter.add(ModelExpressionObject.Attribute.ASPECTRATIO, (Object)"true");
                                break block6;
                            }
                            case RESIZE: {
                                IExpression widthValue = ((IResize)action).getApiWidth();
                                ModelExpressionObject widthContext = new ModelExpressionObject();
                                widthContext.add(ModelExpressionObject.Attribute.TYPE, (Object)ControllerUtils.typeToString(((IResize)action).getApiWidthResizeType()));
                                if (((IResize)action).getApiWidthResizeType() != IResize.ApiResizeType.NO_RESIZE) {
                                    widthContext.add(ModelExpressionObject.Attribute.VALUE, (Object)this.processExpression(widthValue));
                                }
                                parameter.add(ModelExpressionObject.Attribute.WIDTH, (Object)widthContext);
                                if (!(target instanceof ILine)) {
                                    IExpression heightValue = ((IResize)action).getApiHeight();
                                    ModelExpressionObject heightContext = new ModelExpressionObject();
                                    heightContext.add(ModelExpressionObject.Attribute.TYPE, (Object)ControllerUtils.typeToString(((IResize)action).getApiHeightResizeType()));
                                    if (((IResize)action).getApiHeightResizeType() != IResize.ApiResizeType.NO_RESIZE) {
                                        heightContext.add(ModelExpressionObject.Attribute.VALUE, (Object)this.processExpression(heightValue));
                                    }
                                    parameter.add(ModelExpressionObject.Attribute.HEIGHT, (Object)heightContext);
                                }
                                parameter.add(ModelExpressionObject.Attribute.EFFECT, (Object)this.processActionSubParameter(action));
                                break block6;
                            }
                            case ROTATE: {
                                IExpression angleValue = ((IRotate)action).getApiAngle();
                                ModelExpressionObject angleContext = new ModelExpressionObject();
                                angleContext.add(ModelExpressionObject.Attribute.TYPE, (Object)ControllerUtils.typeToString(((IRotate)action).getApiRotateType()));
                                angleContext.add(ModelExpressionObject.Attribute.VALUE, (Object)this.processExpression(angleValue));
                                parameter.add(ModelExpressionObject.Attribute.ANGLE, (Object)angleContext);
                                parameter.add(ModelExpressionObject.Attribute.EFFECT, (Object)this.processActionSubParameter(action));
                                break block6;
                            }
                        }
                        break;
                    }
                }
                context = parameter;
            }
        }
        return context;
    }

    private ModelExpression processActionSubParameter(IAction action) {
        ModelExpressionObject context = null;
        switch (TypeAdaptor.getActionType(action)) {
            case DISPLAY: 
            case MOVE: 
            case RESIZE: 
            case SCROLLTO: 
            case ROTATE: {
                IEffect effect = ((IEffectAction)action).getApiEffect();
                if (effect == null) break;
                Map options = effect.getApiEffectOptions();
                context = new ModelExpressionObject();
                context.add(ModelExpressionObject.Attribute.TYPE, (Object)ControllerUtils.normalizeEffectType(effect.getApiEffectType()));
                context.add(ModelExpressionObject.Attribute.EASING, options.get(IEffect.ApiEffectOption.EASING));
                context.add(ModelExpressionObject.Attribute.DURATION, options.get(IEffect.ApiEffectOption.DURATION));
                context.add(ModelExpressionObject.Attribute.DIRECTION, options.get(IEffect.ApiEffectOption.DIRECTION));
                break;
            }
            case INTERNALNAVIGATION: 
            case EXTERNALNAVIGATION: 
            case BACKWARDNAVIGATION: {
                INavigate navigation = (INavigate)action;
                if (!navigation.isApiPopup().booleanValue()) break;
                context = new ModelExpressionObject();
                context.add(ModelExpressionObject.Attribute.WIDTH, (Object)navigation.getApiWidth());
                context.add(ModelExpressionObject.Attribute.HEIGHT, (Object)navigation.getApiHeight());
                context.add(ModelExpressionObject.Attribute.ISCENTERED, (Object)navigation.isApiCentered());
                context.add(ModelExpressionObject.Attribute.TOP, (Object)navigation.getApiTop());
                context.add(ModelExpressionObject.Attribute.LEFT, (Object)navigation.getApiLeft());
                context.add(ModelExpressionObject.Attribute.HASSCROLLBARS, (Object)(navigation.hasApiScrollBars() != false ? "yes" : "no"));
                context.add(ModelExpressionObject.Attribute.ISRESIZABLE, (Object)(navigation.isApiResizable() != false ? "yes" : "no"));
                break;
            }
        }
        return context;
    }

    private ModelExpression processExpression(IExpression expression) {
        ModelExpression context = null;
        if (expression instanceof IFunction) {
            context = this.processFunction((IFunction)expression);
        } else if (expression instanceof IOperand) {
            context = this.processOperand((IOperand)expression);
        }
        return context;
    }

    private ModelExpression processFunction(IFunction function) {
        ModelExpressionObject context = new ModelExpressionObject();
        context.add(ModelExpressionObject.Attribute.ACTION, (Object)this.utils.getFunctionName(function));
        context.add(ModelExpressionObject.Attribute.PARAMETER, (Object)this.processFunctionParameter(function));
        return context;
    }

    private ModelExpression processFunctionParameter(IFunction function) {
        ModelExpression context = null;
        List parameters = function.getApiParameters();
        switch (function.getApiFunctionType()) {
            case FEMPTY: {
                break;
            }
            case FNEW: {
                BusinessObject newDataMaster = ((FBOData)function).getBusinessObject();
                ModelExpressionObject datamaster = new ModelExpressionObject();
                datamaster.add(ModelExpressionObject.Attribute.DATATYPE, (Object)"datamaster");
                datamaster.add(ModelExpressionObject.Attribute.DATAMASTER, (Object)ControllerUtils.getName((ITarget)newDataMaster));
                ModelExpressionObject newFields = new ModelExpressionObject();
                Integer newParamIndex = 0;
                for (IField field : newDataMaster.getApiFields()) {
                    try {
                        Integer n = newParamIndex;
                        newParamIndex = n + 1;
                        newFields.add(ControllerUtils.getName((ITarget)field), (Object)this.processExpression((IExpression)parameters.get(n)));
                    }
                    catch (IndexOutOfBoundsException e) {
                        Generator.LOG.error((Object)INVALID_PARAMETER_COUNT, (Throwable)e);
                    }
                }
                datamaster.add(ModelExpressionObject.Attribute.FIELDS, (Object)newFields);
                context = datamaster;
                break;
            }
            case FMODIFY: {
                context = this.processExpression((IExpression)parameters.get(0));
                BusinessObject modifyDataMaster = ((FBOData)function).getBusinessObject();
                ModelExpressionObject modifyFields = new ModelExpressionObject();
                Integer modifyParamIndex = 1;
                for (IField field : modifyDataMaster.getApiFields()) {
                    try {
                        Integer n = modifyParamIndex;
                        modifyParamIndex = n + 1;
                        modifyFields.add(ControllerUtils.getName((ITarget)field), (Object)this.processExpression((IExpression)parameters.get(n)));
                    }
                    catch (IndexOutOfBoundsException e) {
                        Generator.LOG.error((Object)"INVALID_PARAMETER_COUNT", (Throwable)e);
                    }
                }
                ((ModelExpressionObject)context).add(ModelExpressionObject.Attribute.FIELDS, modifyFields);
                break;
            }
            case FDELETE: 
            case FGETVALUE: 
            case FGETSELECTEDVALUE: {
                context = this.processExpression((IExpression)parameters.get(0));
                break;
            }
            case FFIRSTPAGE: 
            case FLASTPAGE: 
            case FNEXTPAGE: 
            case FPREVIOUSPAGE: {
                context = new ModelExpressionObject();
                IDataView dataView = ((FPaginationData)function).getDataView();
                ((ModelExpressionObject)context).add(ModelExpressionObject.Attribute.TARGET, dataView instanceof IDataView ? this.utils.getEventElementName((ITarget)dataView) : new ModelExpressionObject());
                break;
            }
            case FCOUNTDATA: {
                context = this.processExpression((IExpression)parameters.get(0));
                break;
            }
            case FAVGDATA: 
            case FSELECTDISTINCT: 
            case FFILTERDISTINCT: 
            case FFILTER: 
            case FMAXDATA: 
            case FMINDATA: 
            case FSELECT: 
            case FSORT: 
            case FSUMDATA: {
                try {
                    context = this.processExpression((IExpression)parameters.get(0));
                    ((ModelExpressionObject)context).add(ModelExpressionObject.Attribute.VALUE, this.processExpression((IExpression)parameters.get(1)));
                }
                catch (IndexOutOfBoundsException e) {
                    Generator.LOG.error((Object)INVALID_PARAMETER_COUNT, (Throwable)e);
                }
                break;
            }
            case FADDTO: 
            case FREMOVEFROM: {
                ModelExpressionArray datasources = new ModelExpressionArray();
                try {
                    datasources.add(this.processExpression((IExpression)parameters.get(0)));
                    datasources.add(this.processExpression((IExpression)parameters.get(1)));
                }
                catch (IndexOutOfBoundsException e) {
                    Generator.LOG.error((Object)INVALID_PARAMETER_COUNT, (Throwable)e);
                }
                context = datasources;
                break;
            }
            default: {
                ModelExpressionArray functionParameter = new ModelExpressionArray();
                Integer size = parameters.size();
                Integer index = 0;
                while (index < size) {
                    functionParameter.add(this.processExpression((IExpression)parameters.get(index)));
                    index = index + 1;
                }
                context = functionParameter;
            }
        }
        return context;
    }

    private ModelExpression processOperand(IOperand operand) {
        ModelExpression context = null;
        if (operand instanceof IVariable) {
            ModelExpressionObject variable = new ModelExpressionObject();
            variable.add(ModelExpressionObject.Attribute.DATATYPE, (Object)"variable");
            variable.add(ModelExpressionObject.Attribute.ELEMENT, (Object)ControllerUtils.getName((ITarget)((IVariable)operand)));
            context = variable;
        } else if (operand instanceof IField) {
            ModelExpressionObject field = new ModelExpressionObject();
            field.add(ModelExpressionObject.Attribute.FIELD, (Object)this.utils.getEventElementName((ITarget)((IField)operand)));
            context = field;
        } else if (operand instanceof IMutablePropertyOperand) {
            ModelExpressionObject parameter = new ModelExpressionObject();
            ITarget target = ((IMutablePropertyOperand)operand).getApiTarget();
            if (((IMutablePropertyOperand)operand).getApiMutablePropertyType() == MutablePropertyType.VALUE) {
                if (target instanceof IDataMaster) {
                    ModelExpressionObject datamaster = new ModelExpressionObject();
                    datamaster.add(ModelExpressionObject.Attribute.DATATYPE, (Object)"datamaster");
                    datamaster.add(ModelExpressionObject.Attribute.DATAMASTER, (Object)ControllerUtils.getName((ITarget)((IDataMaster)target)));
                    context = datamaster;
                    return context;
                }
                if (target instanceof IDataGrid) {
                    ModelExpressionObject datagrid = new ModelExpressionObject();
                    datagrid.add(ModelExpressionObject.Attribute.DATATYPE, (Object)"datagrid");
                    datagrid.add(ModelExpressionObject.Attribute.DATAMASTER, (Object)ControllerUtils.getName((ITarget)((IDataGrid)target).getApiDataMaster()));
                    datagrid.add(ModelExpressionObject.Attribute.ELEMENT, (Object)this.utils.getEventElementName((ITarget)((IDataGrid)target)));
                    context = datagrid;
                    return context;
                }
                if (target instanceof IDataGridCell) {
                    IDataGrid dataGrid = ((IDataGridCell)target).getApiParent();
                    ModelExpressionObject gridcell = new ModelExpressionObject();
                    gridcell.add(ModelExpressionObject.Attribute.DATATYPE, (Object)"gridcell");
                    gridcell.add(ModelExpressionObject.Attribute.DATAMASTER, (Object)ControllerUtils.getName((ITarget)dataGrid.getApiDataMaster()));
                    gridcell.add(ModelExpressionObject.Attribute.ELEMENT, (Object)this.utils.getEventElementName((ITarget)dataGrid));
                    context = gridcell;
                    return context;
                }
                if (target instanceof IDataList) {
                    ModelExpressionObject dataList = new ModelExpressionObject();
                    dataList.add(ModelExpressionObject.Attribute.DATATYPE, (Object)"datalist");
                    dataList.add(ModelExpressionObject.Attribute.DATAMASTER, (Object)ControllerUtils.getName((ITarget)((IDataList)target).getApiDataMaster()));
                    dataList.add(ModelExpressionObject.Attribute.ELEMENT, (Object)this.utils.getEventElementName((ITarget)((IDataList)target)));
                    context = dataList;
                    return context;
                }
                if (target instanceof IDataRow) {
                    IDataList dataList = ((IDataRow)target).getApiParent();
                    ModelExpressionObject datarow = new ModelExpressionObject();
                    datarow.add(ModelExpressionObject.Attribute.DATATYPE, (Object)"datarow");
                    datarow.add(ModelExpressionObject.Attribute.DATAMASTER, (Object)ControllerUtils.getName((ITarget)dataList.getApiDataMaster()));
                    datarow.add(ModelExpressionObject.Attribute.ELEMENT, (Object)this.utils.getEventElementName((ITarget)dataList));
                    context = datarow;
                    return context;
                }
            }
            parameter.add(ModelExpressionObject.Attribute.DATATYPE, (Object)"property");
            parameter.add(ModelExpressionObject.Attribute.TARGET, (Object)this.utils.getEventElementName(target));
            parameter.add(ModelExpressionObject.Attribute.PROPERTY, (Object)this.utils.getMutablePropertyName((IMutablePropertyOperand)operand));
            context = parameter;
        } else if (operand instanceof IConstant) {
            IConstant constant = (IConstant)operand;
            switch (constant.getApiConstantType()) {
                case EMPTY: {
                    context = new ModelExpressionObject();
                    break;
                }
                case TEXT: 
                case DATE: {
                    context = new ModelExpressionValue((Object)constant.getApiValue());
                    break;
                }
                case IMAGE: {
                    context = new ModelExpressionValue((Object)(constant.getApiValue().equals("") ? "" : this.paths.getImagePath(constant.getApiValue())));
                    break;
                }
                case IS_CREDITCARD: {
                    context = new ModelExpressionValue((Object)"^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$");
                    break;
                }
                case IS_EMAIL: {
                    context = new ModelExpressionValue((Object)"[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");
                    break;
                }
                case IS_MONEY: {
                    context = new ModelExpressionValue((Object)"^\\$?[1-9][0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{2})?$");
                    break;
                }
                case IS_NUMBER: {
                    context = new ModelExpressionValue((Object)"^[-+]?[0-9]*[\\.|\\,]?[0-9]+$");
                    break;
                }
                case IS_PERCENT: {
                    context = new ModelExpressionValue((Object)"^\\d{0,2}(\\.\\d{1,2})?$");
                    break;
                }
                case IS_PHONE: {
                    context = new ModelExpressionValue((Object)"^[0-9]{2,3}-? ?[0-9]{6,7}$");
                    break;
                }
                case IS_POSTALCODE: {
                    context = new ModelExpressionValue((Object)"(?:NL[- ]\\d{4} [A-Z][A-Z]|(?:[A-Z]{1,2}[- ])?\\d{2,3}(?:\\d\\d?| \\d\\d|\\d-\\d{3}))");
                    break;
                }
                case IS_URL: {
                    context = new ModelExpressionValue((Object)"^[A-Za-z]{2,}\\:\\/\\/(\\/)?([A-Za-z0-9]+:[A-Za-z0-9]+@)?[A-Za-z0-9\\.-]{3,}(:[0-9]{2,10})?(\\/[A-Za-z0-9]+)*((\\?[A-Za-z0-9]+=[A-Za-z0-9]+)(&amp;[A-Za-z0-9]+=[A-Za-z0-9]+)*|\\/)?(#[A-Za-z0-9]+)?$");
                    break;
                }
                case SYSTEMDATE: 
                case SYSTEMTIME: 
                case RANDOM: 
                case WINDOW_WIDTH: 
                case WINDOW_HEIGHT: 
                case WINDOW_SCROLL_X: 
                case WINDOW_SCROLL_Y: 
                case CURSOR_X: 
                case CURSOR_Y: {
                    ModelExpressionObject constantFunction = new ModelExpressionObject();
                    constantFunction.add(ModelExpressionObject.Attribute.ACTION, (Object)this.utils.getFunctionName(constant));
                    context = constantFunction;
                    break;
                }
            }
        }
        return context;
    }
}

