/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.event;

import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.event.ModelExpressionObject;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.event.EventType;
import com.justinmind.prototyper.api.ui.event.IConstant;
import com.justinmind.prototyper.api.ui.event.IFunction;
import com.justinmind.prototyper.api.ui.event.IMutablePropertyOperand;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.prototyper.api.ui.event.action.IAction;
import com.justinmind.prototyper.api.ui.event.action.IDisplay;
import com.justinmind.prototyper.api.ui.event.action.IEnableInput;
import com.justinmind.prototyper.api.ui.event.action.IPagination;
import com.justinmind.prototyper.api.ui.event.action.IRecordAction;
import com.justinmind.prototyper.api.ui.event.function.ISort;
import com.justinmind.prototyper.api.ui.event.transition.ITransition;
import com.justinmind.util.datamanage.Utils;
import java.util.Locale;

public final class EventControllerUtils {
    protected String getEventElementName(ITarget target) {
        StringBuilder name = new StringBuilder();
        switch (TypeAdaptor.getComponentType(target)) {
            case NONE: {
                break;
            }
            case VARIABLE: 
            case FIELD: {
                name.append(ControllerUtils.getName(target));
                break;
            }
            default: {
                name.append(Utils.isComponentIntoDataView((IComponent)((IComponent)target)) ? "." : "#");
                name.append(ControllerUtils.getID((IComponent)target));
            }
        }
        return name.toString();
    }

    protected String buildDelegateSelector(String canvasName, EventType type) {
        StringBuilder selector = new StringBuilder();
        selector.append(canvasName);
        selector.append(" .");
        selector.append(ControllerUtils.typeToString(type));
        return selector.toString();
    }

    protected String getFunctionName(IAction action) {
        String name = "";
        switch (TypeAdaptor.getActionType(action)) {
            case CHANGESTYLE: {
                name = "jimChangeStyle";
                break;
            }
            case DISPLAY: {
                name = ((IDisplay)action).getApiDisplayType() == IDisplay.ApiDisplayType.SHOW ? "jimShow" : "jimHide";
                break;
            }
            case SETACTIVEPANEL: {
                name = "jimShow";
                break;
            }
            case ENABLEINPUT: {
                name = ((IEnableInput)action).setApiEnabled() != false ? "jimEnable" : "jimDisable";
                break;
            }
            case INSERTINTO: {
                name = "jimInsert";
                break;
            }
            case INTERNALNAVIGATION: 
            case EXTERNALNAVIGATION: 
            case BACKWARDNAVIGATION: {
                name = "jimNavigation";
                break;
            }
            case MOVE: {
                name = "jimMove";
                break;
            }
            case RESIZE: {
                name = "jimResize";
                break;
            }
            case ROTATE: {
                name = "jimRotate";
                break;
            }
            case PAGINATION: {
                name = this.getFunctionName(((IPagination)action).getApiFunction());
                break;
            }
            case PAUSE: {
                name = "jimPause";
                break;
            }
            case RECORDACTION: {
                name = this.getFunctionName(((IRecordAction)action).getApiFunction());
                break;
            }
            case SETFOCUS: {
                name = "jimFocusOn";
                break;
            }
            case SCROLLTO: {
                name = "jimScrollTo";
                break;
            }
            case SETSELECTION: {
                name = "jimSetSelection";
                break;
            }
            case SETVALUE: {
                name = "jimSetValue";
                break;
            }
        }
        return name;
    }

    protected String getFunctionName(IFunction function) {
        String name = null;
        switch (function.getApiFunctionType()) {
            case FDIFF: {
                name = "jimNotEquals";
                break;
            }
            case FEQUALS: {
                name = "jimEquals";
                break;
            }
            case FGREATER: {
                name = "jimGreater";
                break;
            }
            case FGREATEREQUALS: {
                name = "jimGreaterOrEquals";
                break;
            }
            case FLESS: {
                name = "jimLess";
                break;
            }
            case FLESSEQUALS: {
                name = "jimLessOrEquals";
                break;
            }
            case FAVGDATA: {
                name = "jimAvgData";
                break;
            }
            case FDELETE: {
                name = "jimDeleteData";
                break;
            }
            case FMODIFY: {
                name = "jimUpdateData";
                break;
            }
            case FNEW: {
                name = "jimCreateData";
                break;
            }
            case FCOUNTDATA: {
                name = "jimCountData";
                break;
            }
            case FREMOVEFROM: {
                name = "jimRemoveFromData";
                break;
            }
            case FSELECTDISTINCT: {
                name = "jimSelectDistinctData";
                break;
            }
            case FFILTERDISTINCT: {
                name = "jimFilterDistinctData";
                break;
            }
            case FFILTER: {
                name = "jimFilterData";
                break;
            }
            case FMAXDATA: {
                name = "jimMaxData";
                break;
            }
            case FMINDATA: {
                name = "jimMinData";
                break;
            }
            case FFIRSTPAGE: {
                name = "jimFirstPageData";
                break;
            }
            case FLASTPAGE: {
                name = "jimLastPageData";
                break;
            }
            case FNEXTPAGE: {
                name = "jimNextPageData";
                break;
            }
            case FPREVIOUSPAGE: {
                name = "jimPrevPageData";
                break;
            }
            case FSELECT: {
                name = "jimSelectData";
                break;
            }
            case FSORT: {
                name = ((ISort)function).getApiSortOrderType() == ISort.ApiSortOrderType.ASCENDANT ? "jimSortDataAscendant" : "jimSortDataDescendant";
                break;
            }
            case FSUMDATA: {
                name = "jimSumData";
                break;
            }
            case FADDTO: {
                name = "jimAddToData";
                break;
            }
            case FEMPTY: {
                break;
            }
            case FAND: {
                name = "jimAnd";
                break;
            }
            case FNOT: {
                name = "jimNot";
                break;
            }
            case FOR: {
                name = "jimOr";
                break;
            }
            case FXOR: {
                name = "jimXOr";
                break;
            }
            case FABS: {
                name = "jimAbs";
                break;
            }
            case FAVG: {
                name = "jimAvg";
                break;
            }
            case FDIV: {
                name = "jimDivide";
                break;
            }
            case FMAX: {
                name = "jimMax";
                break;
            }
            case FMIN: {
                name = "jimMin";
                break;
            }
            case FMINUS: {
                name = "jimMinus";
                break;
            }
            case FMOD: {
                name = "jimMod";
                break;
            }
            case FMUL: {
                name = "jimMultiply";
                break;
            }
            case FPERCENT: {
                name = "jimPercent";
                break;
            }
            case FPLUS: {
                name = "jimPlus";
                break;
            }
            case FROUND: {
                name = "jimRound";
                break;
            }
            case FSQRT: {
                name = "jimSqrt";
                break;
            }
            case FCONCAT: {
                name = "jimConcat";
                break;
            }
            case FCONTAINS: {
                name = "jimContains";
                break;
            }
            case FCOUNT: {
                name = "jimCount";
                break;
            }
            case FINDEXOF: {
                name = "jimIndexOf";
                break;
            }
            case FLOWERCASE: {
                name = "jimLower";
                break;
            }
            case FREGEX: {
                name = "jimRegExp";
                break;
            }
            case FSUBSTRING: {
                name = "jimSubstring";
                break;
            }
            case FUPPERCASE: {
                name = "jimUpper";
                break;
            }
            case FUPPERFIRSTCASE: {
                name = "jimFirstUpper";
                break;
            }
            case FGETVALUE: {
                name = "jimGetValue";
                break;
            }
            case FGETSELECTEDVALUE: {
                name = "jimGetSelection";
                break;
            }
            case FAREAINTERSECT: {
                name = "jimAreaIntersect";
                break;
            }
            case FAREACONTAINS: {
                name = "jimAreaContains";
                break;
            }
        }
        return name;
    }

    protected String getFunctionName(IConstant constant) {
        String name = null;
        switch (constant.getApiConstantType()) {
            case RANDOM: {
                name = "jimRandom";
                break;
            }
            case SYSTEMDATE: {
                name = "jimSystemDate";
                break;
            }
            case SYSTEMTIME: {
                name = "jimSystemTime";
                break;
            }
            case WINDOW_WIDTH: {
                name = "jimWindowWidth";
                break;
            }
            case WINDOW_HEIGHT: {
                name = "jimWindowHeight";
                break;
            }
            case WINDOW_SCROLL_X: {
                name = "jimWindowScrollX";
                break;
            }
            case WINDOW_SCROLL_Y: {
                name = "jimWindowScrollY";
                break;
            }
            case CURSOR_X: {
                name = "jimCursorX";
                break;
            }
            case CURSOR_Y: {
                name = "jimCursorY";
                break;
            }
        }
        return name;
    }

    protected String getMutablePropertyName(IMutablePropertyOperand operand) {
        String name = null;
        switch (operand.getApiMutablePropertyType()) {
            case VALUE: {
                name = "jimGetValue";
                break;
            }
            case SELECTED_VALUE: {
                name = "jimGetSelectedValue";
                break;
            }
            case POSITION_X: {
                name = "jimGetPositionX";
                break;
            }
            case POSITION_Y: {
                name = "jimGetPositionY";
                break;
            }
            case POSITION_ABSOLUTE_X: {
                name = "jimGetAbsolutePositionX";
                break;
            }
            case POSITION_ABSOLUTE_Y: {
                name = "jimGetAbsolutePositionY";
                break;
            }
            case WIDTH: {
                name = "jimGetWidth";
                break;
            }
            case HEIGHT: {
                name = "jimGetHeight";
                break;
            }
            case ANGLE: {
                name = "jimGetAngle";
                break;
            }
            case VISIBLE: {
                name = "jimIsVisible";
                break;
            }
            case AREA: {
                name = "jimGetArea";
                break;
            }
        }
        return name;
    }

    protected void addTransition(ModelExpressionObject parameter, ITransition transition) {
        if (transition != null) {
            parameter.add(ModelExpressionObject.Attribute.TRANSITION, (Object)transition.getApiTransitionType().toString().toLowerCase(Locale.ENGLISH));
        }
    }
}

