/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.externaltools;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.attributerenderer.StringRenderer;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;

public class ExternalToolsController
extends ContextController {
    public static final String EXTERNAL_SCRIPT = "external_tools.js";
    private static final String GROUP_URL = "com/justinmind/generator/context/externaltools/ExternalTools.stg";
    private static final String TEMPLATE_SCRIPT = "ExternalScript";
    private static final String SCRIPTS = "scripts";
    private final transient Set<String> scriptIncludes = new LinkedHashSet<String>();

    public ExternalToolsController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        if (this.applicationContext.getTestScript() != null) {
            String testScript = this.applicationContext.getTestScript().getTestPage().replaceAll("[\\r\\n]", "");
            testScript = testScript.replaceAll("\" \\+ urlPath \\+ \"", "## + urlPath + ##");
            testScript = testScript.replaceAll("\" \\+ title \\+ \"", "## + title + ##");
            testScript = StringEscapeUtils.escapeEcmaScript((String)testScript);
            testScript = testScript.replaceAll("## \\+ urlPath \\+ ##", "\" + urlPath + \"");
            testScript = testScript.replaceAll("## \\+ title \\+ ##", "\" + title + \"");
            this.scriptIncludes.add(testScript);
            ST scriptCon = this.group.getInstanceOf(TEMPLATE_SCRIPT);
            scriptCon.add(SCRIPTS, this.scriptIncludes);
            this.outputEngine.write(Paths.getExternalToolsScriptOutput(this.paths.output, this.applicationContext.getTime()), scriptCon, this.strategy);
        }
        this.clearCache();
    }

    private void clearCache() {
        if (this.scriptIncludes != null) {
            this.scriptIncludes.clear();
        }
    }
}

