/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.htmlwidget;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDocument;
import com.justinmind.prototyper.api.ui.component.IHtml;
import com.justinmind.prototyper.api.ui.component.IMasterInstance;
import com.justinmind.prototyper.api.ui.component.IUrl;
import com.justinmind.prototyper.api.ui.component.IValuedComponent;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.util.datamanage.Utils;
import java.util.ArrayList;
import java.util.List;
import org.stringtemplate.v4.ST;

public final class HtmlWidgetController<C extends IComponent>
extends ContextController {
    private static final String GROUP_URL = "com/justinmind/generator/context/htmlwidget/HtmlWidgetView.stg";
    private static final String TEMPLATE = "HtmlWidget";
    private static final String HTML = "html";
    private final transient List<Class<C>> includeFilter = new ArrayList<Class<C>>(4);
    private final transient List<Class<C>> excludeFilter;

    public HtmlWidgetController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.includeFilter.add(IDocument.class);
        this.includeFilter.add(IHtml.class);
        this.includeFilter.add(IUrl.class);
        this.excludeFilter = new ArrayList<Class<C>>(1);
        this.excludeFilter.add(IMasterInstance.class);
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        for (ICanvas canvas : this.prototype.getApiCanvases()) {
            for (IComponent browser : Utils.getDescendants((IComponent)canvas.getApiRoot(), this.includeFilter, this.excludeFilter, (boolean)false)) {
                String html = ((IValuedComponent)browser).getApiValue();
                if (html == null) continue;
                String fileName = String.valueOf(this.paths.output) + "external/documents/" + ControllerUtils.getName((ITarget)browser);
                ST context = this.group.getInstanceOf(TEMPLATE);
                context.add(HTML, (Object)html);
                this.outputEngine.write(fileName, context, this.strategy);
            }
        }
    }
}

