/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.include;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.application.review.ReviewPaths;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.attributerenderer.StringRenderer;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import java.util.LinkedHashSet;
import java.util.Set;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;

public class IncludeController
extends ContextController {
    public static final String INCLUDE_CSS = "include.css";
    public static final String INCLUDE_IE_CSS = "include-ie.css";
    public static final String INCLUDE_SCRIPT = "include.js";
    private static final String GROUP_URL = "com/justinmind/generator/context/include/Include.stg";
    private static final String TEMPLATE_STYLE = "IncludeStyle";
    private static final String TEMPLATE_SCRIPT = "IncludeScript";
    private static final String STYLES = "styles";
    private static final String SCRIPTS = "scripts";
    private final transient Set<String> styleIncludes = new LinkedHashSet<String>();
    private final transient Set<String> styleIEIncludes = new LinkedHashSet<String>();
    private final transient Set<String> styleIE8Includes = new LinkedHashSet<String>();
    private final transient Set<String> scriptIncludes = new LinkedHashSet<String>();
    private final transient String cssResources;
    private final transient String jsResources;

    public IncludeController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.cssResources = this.paths.cssResourcesReference;
        this.jsResources = String.valueOf(this.paths.resourcesReference) + "javascript/";
        this.group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        this.styleIEIncludes.add(String.valueOf(this.cssResources) + "jim-ie.css");
        if (this.optimize.booleanValue()) {
            this.styleIncludes.add(String.valueOf(this.cssResources) + this.paths.cssMinFile);
            this.scriptIncludes.add(String.valueOf(this.jsResources) + this.paths.jsMinFile);
        } else {
            this.styleIncludes.add(String.valueOf(this.cssResources) + "function-external-jquery-ui.css");
            this.styleIncludes.add(String.valueOf(this.cssResources) + "function-jim-common.css");
            this.styleIncludes.add(String.valueOf(this.cssResources) + "function-jim-layout.css");
            this.styleIncludes.add(String.valueOf(this.cssResources) + "function-jim-highlight.css");
            this.styleIncludes.add(String.valueOf(this.cssResources) + "function-jim-annotation.css");
            this.styleIncludes.add(String.valueOf(this.cssResources) + "function-jim-transition.css");
            this.styleIncludes.add(String.valueOf(this.cssResources) + "component-jim-navigationtree.css");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-external-jquery.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-external-jquery-ui.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-external-doT.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-external-form.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-external-autogrowtextarea.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-external-event-drag.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-external-highlight.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-scenarios.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-external-jquery-browser.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-external-datetime.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-jim-navigationtree.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-util.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-layout.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-annotation.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-highlight.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-main.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-history.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-transition.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-data.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-event.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-event-base.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-event-function.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-event-action.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-event-data.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-jim-datagrid.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-jim-menu.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-jim-tree.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-jim-dropdown.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-jim-selectionlist.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-shapes.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "function-jim-rendercomponent.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-external-customSelect.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-external-highlight-menu.js");
            this.scriptIncludes.add(String.valueOf(this.jsResources) + "component-jim-customSlider.js");
        }
        this.scriptIncludes.add("./resources/scenarios/function-jim-links" + this.applicationContext.getTime() + ".js");
        this.addMobileResources();
        Object appendJS = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.APPENDJS);
        Boolean append = appendJS instanceof Boolean ? (Boolean)appendJS : true;
        if (append.booleanValue()) {
            this.scriptIncludes.add(ReviewPaths.getPrototypeOutput(this.paths.base, this.applicationContext.getTime()));
        } else {
            if (!this.prototype.getApiVariables().isEmpty() || !this.prototype.getApiDataMasters().isEmpty()) {
                this.scriptIncludes.add(Paths.getDataOutput(this.paths.base, this.applicationContext.getTime()));
            }
            this.scriptIncludes.add(Paths.getLookUpOutput(this.paths.base, this.applicationContext.getTime()));
            for (ICanvas canvas : this.prototype.getApiCanvases()) {
                if (canvas.getApiAllEvents().isEmpty()) continue;
                this.scriptIncludes.add(Paths.getCanvasOutput(this.paths.base, canvas, this.applicationContext.getTime()).append(".js").toString());
            }
        }
        this.styleIncludes.add(Paths.getFontFaceOutput("../../", this.applicationContext.getTime()));
        if (this.prototype.getApiSimulationSettings().getApiScale() != 100 || this.prototype.getApiSimulationSettings().hasApiFitScreen()) {
            this.scriptIncludes.add(Paths.getScaleOutput("./", this.applicationContext.getTime()));
            this.styleIncludes.add(Paths.getScaleStyleOutput("../../", this.applicationContext.getTime()));
        }
        ST styleCon = this.group.getInstanceOf(TEMPLATE_STYLE);
        styleCon.add(STYLES, this.styleIncludes);
        this.outputEngine.write(Paths.getIncludeStyleOutput(this.paths.output, this.paths.folderHTML, this.applicationContext.getTime()), styleCon, this.strategy);
        ST styleIECon = this.group.getInstanceOf(TEMPLATE_STYLE);
        styleIECon.add(STYLES, this.styleIEIncludes);
        this.outputEngine.write(Paths.getIncludeStyleIEOutput(this.paths.output, this.paths.folderHTML, this.applicationContext.getTime()), styleIECon, this.strategy);
        ST styleIE8Con = this.group.getInstanceOf(TEMPLATE_STYLE);
        styleIE8Con.add(STYLES, this.styleIE8Includes);
        this.outputEngine.write(Paths.getIncludeStyleIE8Output(this.paths.output, this.paths.folderHTML, this.applicationContext.getTime()), styleIE8Con, this.strategy);
        ST scriptCon = this.group.getInstanceOf(TEMPLATE_SCRIPT);
        scriptCon.add(SCRIPTS, this.scriptIncludes);
        this.outputEngine.write(Paths.getIncludeScriptOutput(this.paths.output, this.paths.folderHTML, this.applicationContext.getTime()), scriptCon, this.strategy);
        this.clearCache();
    }

    private void clearCache() {
        this.styleIncludes.clear();
        this.styleIEIncludes.clear();
        this.styleIE8Includes.clear();
        this.scriptIncludes.clear();
    }

    private void addMobileResources() {
        if (this.optimize.booleanValue()) {
            switch (this.applicationContext.getPrototype().getApiSimulationSettings().getApiSimulationDevice()) {
                case WEB: {
                    break;
                }
                case IPHONE6PLUS: 
                case IPHONE6: 
                case IPHONE5: 
                case IPHONE4: {
                    String iosVersion = "ios" + this.applicationContext.getPrototype().getApiSimulationSettings().getApiSimulationiOSVersion().toNumber() + "/";
                    String iPhoneDevice = this.prototype.getApiSimulationSettings().getApiSimulationDevice().getName().toLowerCase();
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "jim-mobile-min.css");
                    this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie8.css");
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/jim-ios-common-min.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/jim-ios-common-ie8-min.css");
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/jim-" + iPhoneDevice + "-min.css");
                    this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/function-jim-" + iPhoneDevice + "-ie.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/jim-" + iPhoneDevice + "-ie8-min.css");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/" + iosVersion + "iphone/jim-iphone-min.js");
                    this.scriptIncludes.add(String.valueOf(this.paths.base) + "resources/" + "scroll-" + this.applicationContext.getTime() + ".js");
                    break;
                }
                case IPAD: {
                    String iosVersion = "ios" + this.applicationContext.getPrototype().getApiSimulationSettings().getApiSimulationiOSVersion().toNumber() + "/";
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "jim-mobile-min.css");
                    this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie8.css");
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/jim-ios-common-min.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/jim-ios-common-ie8-min.css");
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-min.css");
                    this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + "ipad/function-jim-ipad-ie.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-ie8-min.css");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-min.js");
                    this.scriptIncludes.add(String.valueOf(this.paths.base) + "resources/" + "scroll-" + this.applicationContext.getTime() + ".js");
                    break;
                }
                case ANDROID_PHONE: {
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "android/phone/" + "function-jim-android-phone.css");
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "jim-mobile-min.css");
                    this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie8.css");
                    this.styleIncludes.add("../../resources/mobile/function-jim-custom-" + this.applicationContext.getTime() + ".css");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "custom/jim-custom-min.js");
                    this.scriptIncludes.add(String.valueOf(this.paths.base) + "resources/" + "scroll-" + this.applicationContext.getTime() + ".js");
                    break;
                }
                case ANDROID_TABLET: 
                case GOOGLE_GLASS: 
                case MOBILECUSTOM: {
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "custom/" + "function-jim-custom.css");
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "jim-mobile-min.css");
                    this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie8.css");
                    this.styleIncludes.add("../../resources/mobile/function-jim-custom-" + this.applicationContext.getTime() + ".css");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "custom/jim-custom-min.js");
                    this.scriptIncludes.add(String.valueOf(this.paths.base) + "resources/" + "scroll-" + this.applicationContext.getTime() + ".js");
                }
            }
        } else {
            if (this.applicationContext.isMobile().booleanValue()) {
                this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile.css");
                this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie.css");
                this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "function-jim-mobile-ie8.css");
                this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "function-jim-mobile.js");
                this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "function-jim-caret.js");
                this.scriptIncludes.add(String.valueOf(this.paths.base) + "resources/" + "scroll-" + this.applicationContext.getTime() + ".js");
            }
            switch (this.applicationContext.getPrototype().getApiSimulationSettings().getApiSimulationDevice()) {
                case WEB: {
                    break;
                }
                case IPHONE6PLUS: 
                case IPHONE6: 
                case IPHONE5: 
                case IPHONE4: {
                    String iosVersion = "ios" + this.applicationContext.getPrototype().getApiSimulationSettings().getApiSimulationiOSVersion().toNumber() + "/";
                    String iPhoneDevice = this.prototype.getApiSimulationSettings().getApiSimulationDevice().getName().toLowerCase();
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/function-jim-" + iPhoneDevice + ".css");
                    this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/function-jim-" + iPhoneDevice + "-ie.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/function-jim-" + iPhoneDevice + "-ie8.css");
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/function-jim-ios-common.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/function-jim-ios-common-ie8.css");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/" + iosVersion + "iphone/function-jim-iphone.js");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/" + iosVersion + "function-external-overscroll.js");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/component-jim-ios-boolean.js");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/component-jim-ios-dropdown.js");
                    break;
                }
                case IPAD: {
                    String iosVersion = "ios" + this.applicationContext.getPrototype().getApiSimulationSettings().getApiSimulationiOSVersion().toNumber() + "/";
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + "ipad/function-jim-ipad.css");
                    this.styleIEIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + "ipad/function-jim-ipad-ie.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/" + iosVersion + "ipad/function-jim-ipad-ie8.css");
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/function-jim-ios-common.css");
                    this.styleIE8Includes.add(String.valueOf(this.cssResources) + "mobile/" + "ios/function-jim-ios-common-ie8.css");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/" + iosVersion + "function-external-overscroll.js");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/" + iosVersion + "ipad/function-jim-ipad.js");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/component-jim-ios-boolean.js");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "ios/component-jim-ios-dropdown.js");
                    break;
                }
                case ANDROID_PHONE: {
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "android/phone/" + "function-jim-android-phone.css");
                    this.styleIncludes.add("../../resources/mobile/function-jim-custom-" + this.applicationContext.getTime() + ".css");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "custom/function-external-overscroll.js");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "custom/function-jim-custom.js");
                    break;
                }
                case ANDROID_TABLET: 
                case GOOGLE_GLASS: 
                case MOBILECUSTOM: {
                    this.styleIncludes.add(String.valueOf(this.cssResources) + "mobile/" + "custom/" + "function-jim-custom.css");
                    this.styleIncludes.add("../../resources/mobile/function-jim-custom-" + this.applicationContext.getTime() + ".css");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "custom/function-external-overscroll.js");
                    this.scriptIncludes.add(String.valueOf(this.jsResources) + "mobile/" + "custom/function-jim-custom.js");
                }
            }
        }
    }
}

