/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.json;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.attributerenderer.StringRenderer;
import com.justinmind.generator.engine.modeladaptor.CommentAdaptor;
import com.justinmind.prototyper.api.comment.IComment;
import java.io.File;
import java.util.List;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;

public class JsonController
extends ContextController {
    private static final String GROUP_URL = "com/justinmind/generator/context/json/Json.stg";
    private static final String TEMPLATE = "Json";
    private static final String JSON = "json";

    public JsonController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.group.registerModelAdaptor(IComment.class, (ModelAdaptor)new CommentAdaptor(applicationContext.getTimeZone(), applicationContext.getLocale()));
        this.group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        List comments = this.prototype.getApiComments();
        if (!comments.isEmpty()) {
            ST context = this.group.getInstanceOf(TEMPLATE);
            context.add(JSON, (Object)comments);
            this.outputEngine.write(String.valueOf(this.paths.output) + "comments/annotations.json", context, this.strategy);
        } else {
            File annotationsFile = new File(String.valueOf(this.paths.output) + "comments/annotations.json");
            if (annotationsFile.exists()) {
                annotationsFile.delete();
            }
        }
    }
}

