/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.mobile;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.mobile.MobileRule;
import com.justinmind.generator.context.mobile.MobileUtils;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.IPrototype;
import com.justinmind.prototyper.api.ui.StyleProperty;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.canvas.IScreen;
import com.justinmind.prototyper.api.ui.component.ICellContainer;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataGridCell;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.prototyper.api.ui.component.IPanel;
import com.justinmind.prototyper.api.ui.component.IRootComponent;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.prototyper.api.ui.simulation.SimulationDevice;
import com.justinmind.util.datamanage.Utils;
import java.util.ArrayList;
import java.util.List;
import org.stringtemplate.v4.ST;

public class MobileController
extends ContextController {
    private static final String GROUP_URL = "com/justinmind/generator/context/mobile/Mobile.stg";
    private static final String TEMPLATE = "Mobile";
    private static final String TEMPLATE_SCROLL = "MobileScroll";
    private static final String EXTENSION = ".css";
    protected static final String RULES = "rules";
    private static Integer CUSTOM_IMAGE_WIDTH = 45;
    private MobileUtils utils;

    public MobileController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.utils = new MobileUtils(applicationContext);
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    protected String getExtension() {
        return EXTENSION;
    }

    @Override
    public void generate() throws GeneratorException {
        if (this.applicationContext.isMobile().booleanValue()) {
            SimulationDevice device = this.prototype.getApiSimulationSettings().getApiSimulationDevice();
            if (device == SimulationDevice.MOBILECUSTOM || SimulationDevice.isAndroidDevice((SimulationDevice)device)) {
                ST context = this.group.getInstanceOf(TEMPLATE);
                this.setCustomSizeRules(context, this.prototype);
                String fileName = MobileController.getCssOutput(this.paths.output, "function-jim-custom", this.applicationContext.getTime()).append(this.getExtension()).toString();
                this.outputEngine.write(fileName, context, this.strategy);
            }
            ArrayList<ICanvas> canvasList = new ArrayList<ICanvas>();
            canvasList.addAll(this.prototype.getApiScreens());
            if (this.applicationContext.getInitialCanvas() != null && !this.applicationContext.getInitialCanvas().getClass().equals(IScreen.class)) {
                canvasList.add(this.applicationContext.getInitialCanvas());
            }
            ArrayList<MobileRule> mobileRules = new ArrayList<MobileRule>();
            for (ICanvas canvas : canvasList) {
                IRootComponent root = canvas.getApiRoot();
                mobileRules.addAll(this.processMobileRules("", (IComponent)root));
            }
            String fileName = String.valueOf(this.paths.output) + "resources/" + "scroll-" + this.applicationContext.getTime() + ".js";
            ST context = this.group.getInstanceOf(TEMPLATE_SCROLL);
            context.add(RULES, mobileRules);
            this.outputEngine.write(fileName, context, this.strategy);
        }
    }

    private List<MobileRule> processMobileRules(String rootID, IComponent component) {
        ArrayList<MobileRule> rules = new ArrayList<MobileRule>();
        TypeAdaptor.ComponentType type = TypeAdaptor.getComponentType((ITarget)component);
        block0 : switch (type) {
            case ROOTCOMPONENT: {
                ICanvas canvas = ((IRootComponent)component).getApiCanvas();
                switch (TypeAdaptor.getComponentType((ITarget)canvas)) {
                    case SCREEN: {
                        String screenRootID = "." + ControllerUtils.getID((IComponent)canvas);
                        String templateRootID = "." + ControllerUtils.getID((IComponent)((IScreen)canvas).getApiTemplate());
                        MobileRule rule = new MobileRule("." + ControllerUtils.getID((IComponent)canvas) + " .ui-page");
                        if (!canvas.getApiCanvasBackgroundGrowth().equals((Object)ICanvas.ApiCanvasBackgroundGrowth.NONE)) {
                            this.utils.setCanvasCustomVisibleScrollBars(canvas, component, rule);
                            rules.add(rule);
                        }
                        rules.addAll(this.processChildren(screenRootID, component));
                        rules.addAll(this.processChildren(templateRootID, (IComponent)((IScreen)canvas).getApiTemplate()));
                        break block0;
                    }
                    case TEMPLATE: 
                    case MASTER: {
                        String screenRootID = "." + ControllerUtils.getID((IComponent)canvas);
                        MobileRule rule = new MobileRule("." + ControllerUtils.getID((IComponent)canvas) + " .ui-page");
                        this.utils.setAlwaysVisibleScrollBars(component, rule);
                        rules.add(rule);
                        rules.addAll(this.processChildren(screenRootID, component));
                        break block0;
                    }
                }
                break;
            }
            case PANEL: {
                IPanel panel = (IPanel)component;
                if (panel.getApiHorizontalOverflow() != ILayout.ApiOverflowType.HIDDEN || panel.getApiVerticalOverflow() != ILayout.ApiOverflowType.HIDDEN) {
                    MobileRule rule = new MobileRule(String.valueOf(rootID) + " " + (Utils.isComponentIntoDataView((IComponent)component) ? "." : "#") + ControllerUtils.getID((IComponent)panel));
                    this.utils.setVisibleScrollBars((IComponent)panel, rule);
                    rules.add(rule);
                }
                rules.addAll(this.processChildren(rootID, component));
                break;
            }
            case CELLCONTAINER: 
            case DATACELL: {
                ICellContainer cell = (ICellContainer)component;
                if (cell.getApiHorizontalOverflow() != ILayout.ApiOverflowType.HIDDEN || cell.getApiVerticalOverflow() != ILayout.ApiOverflowType.HIDDEN) {
                    MobileRule rule = new MobileRule(String.valueOf(rootID) + " " + (Utils.isComponentIntoDataView((IComponent)component) ? "." : "#") + ControllerUtils.getID((IComponent)cell) + " .layout");
                    this.utils.setVisibleScrollBars((IComponent)cell, rule);
                    rules.add(rule);
                }
                rules.addAll(this.processChildren(rootID, component));
                break;
            }
            case GRIDCELL: {
                IDataGridCell gridCell = (IDataGridCell)component;
                if (gridCell.getApiHorizontalOverflow() != ILayout.ApiOverflowType.HIDDEN || gridCell.getApiVerticalOverflow() != ILayout.ApiOverflowType.HIDDEN) {
                    MobileRule rule = new MobileRule(String.valueOf(rootID) + " " + (Utils.isComponentIntoDataView((IComponent)component) ? "." : "#") + ControllerUtils.getID((IComponent)gridCell) + " .layout");
                    this.utils.setVisibleScrollBars((IComponent)gridCell, rule);
                    rules.add(rule);
                }
                rules.addAll(this.processChildren(rootID, component));
                break;
            }
            case SELECTIONLIST: 
            case MULTISELECTIONLIST: 
            case CHECKBOXLIST: 
            case RADIOBUTTONLIST: {
                MobileRule rule = new MobileRule(String.valueOf(rootID) + " " + (Utils.isComponentIntoDataView((IComponent)component) ? "." : "#") + ControllerUtils.getID(component));
                this.utils.setCustomVisibleScrollBars(component, rule, "vertical", false);
                rules.add(rule);
                break;
            }
            case MASTERINSTANCE: 
            case GROUP: 
            case DYNAMICPANEL: 
            case TABLE: 
            case ROW: 
            case DATAGRID: 
            case DATALIST: 
            case DATAROW: {
                rules.addAll(this.processChildren(rootID, component));
            }
        }
        return rules;
    }

    protected List<MobileRule> processChildren(String rootID, IComponent component) {
        ArrayList<MobileRule> rules = new ArrayList<MobileRule>();
        for (IComponent child : component.getApiChildren()) {
            rules.addAll(this.processMobileRules(rootID, child));
        }
        return rules;
    }

    private void setCustomSizeRules(ST context, IPrototype prototype) {
        CUSTOM_IMAGE_WIDTH = prototype.getApiSimulationSettings().getApiSimulationDevice().equals((Object)SimulationDevice.ANDROID_PHONE) ? 55 : 45;
        MobileRule rule = new MobileRule("#jim-mobile");
        rule.add(StyleProperty.WIDTH, String.valueOf(prototype.getApiSimulationSettings().getApiWidth() + CUSTOM_IMAGE_WIDTH * 2) + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-mobile.landscape");
        rule.add(StyleProperty.WIDTH, String.valueOf(prototype.getApiSimulationSettings().getApiHeight() + CUSTOM_IMAGE_WIDTH * 2) + "px");
        rule.add(StyleProperty.HEIGHT, String.valueOf(prototype.getApiSimulationSettings().getApiWidth() + CUSTOM_IMAGE_WIDTH * 2) + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case");
        rule.add(StyleProperty.WIDTH, String.valueOf(prototype.getApiSimulationSettings().getApiWidth() + CUSTOM_IMAGE_WIDTH * 2) + "px");
        rule.add(StyleProperty.HEIGHT, String.valueOf(prototype.getApiSimulationSettings().getApiHeight() + CUSTOM_IMAGE_WIDTH * 2) + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-container.portrait");
        rule.add(StyleProperty.POSITION, "absolute");
        rule.add(StyleProperty.TOP, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.LEFT, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.WIDTH, prototype.getApiSimulationSettings().getApiWidth() + "px");
        rule.add(StyleProperty.HEIGHT, prototype.getApiSimulationSettings().getApiHeight() + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-container.landscape");
        rule.add(StyleProperty.POSITION, "absolute");
        rule.add(StyleProperty.TOP, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.LEFT, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.WIDTH, prototype.getApiSimulationSettings().getApiHeight() + "px");
        rule.add(StyleProperty.HEIGHT, prototype.getApiSimulationSettings().getApiWidth() + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-top-left");
        rule.add(StyleProperty.WIDTH, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.HEIGHT, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.BACKGROUND_SIZE, CUSTOM_IMAGE_WIDTH + "px" + " " + CUSTOM_IMAGE_WIDTH + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-top-center");
        rule.add(StyleProperty.WIDTH, prototype.getApiSimulationSettings().getApiWidth() + "px");
        rule.add(StyleProperty.HEIGHT, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.BACKGROUND_SIZE, prototype.getApiSimulationSettings().getApiWidth() + "px" + " " + CUSTOM_IMAGE_WIDTH + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-top-right");
        rule.add(StyleProperty.WIDTH, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.HEIGHT, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.BACKGROUND_SIZE, CUSTOM_IMAGE_WIDTH + "px" + " " + CUSTOM_IMAGE_WIDTH + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-center-left");
        rule.add(StyleProperty.WIDTH, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.HEIGHT, prototype.getApiSimulationSettings().getApiHeight() + "px");
        rule.add(StyleProperty.BACKGROUND_SIZE, CUSTOM_IMAGE_WIDTH + "px" + " " + prototype.getApiSimulationSettings().getApiHeight() + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-center-center");
        rule.add(StyleProperty.WIDTH, prototype.getApiSimulationSettings().getApiWidth() + "px");
        rule.add(StyleProperty.HEIGHT, prototype.getApiSimulationSettings().getApiHeight() + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-center-right");
        rule.add(StyleProperty.WIDTH, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.HEIGHT, prototype.getApiSimulationSettings().getApiHeight() + "px");
        rule.add(StyleProperty.BACKGROUND_SIZE, CUSTOM_IMAGE_WIDTH + "px" + " " + prototype.getApiSimulationSettings().getApiHeight() + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-bottom-left");
        rule.add(StyleProperty.WIDTH, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.HEIGHT, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.BACKGROUND_SIZE, CUSTOM_IMAGE_WIDTH + "px" + " " + CUSTOM_IMAGE_WIDTH + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-bottom-center");
        rule.add(StyleProperty.WIDTH, prototype.getApiSimulationSettings().getApiWidth() + "px");
        rule.add(StyleProperty.HEIGHT, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.BACKGROUND_SIZE, prototype.getApiSimulationSettings().getApiWidth() + "px" + " " + CUSTOM_IMAGE_WIDTH + "px");
        context.add(RULES, (Object)rule);
        rule = new MobileRule("#jim-case #jim-case-bottom-right");
        rule.add(StyleProperty.WIDTH, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.HEIGHT, CUSTOM_IMAGE_WIDTH + "px");
        rule.add(StyleProperty.BACKGROUND_SIZE, CUSTOM_IMAGE_WIDTH + "px" + " " + CUSTOM_IMAGE_WIDTH + "px");
        context.add(RULES, (Object)rule);
    }

    public static StringBuilder getCssOutput(String outputBase, String filename, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append("resources/");
        output.append("mobile/");
        output.append(filename);
        output.append("-");
        output.append(time);
        return output;
    }
}

