/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.mobile;

import com.justinmind.evc.model.actions.ItemContainer;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.mobile.MobileRule;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.component.ICellContainer;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataGridCell;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.prototyper.api.ui.component.IPanel;
import com.justinmind.siteXmlDef.Igu.model.AbstractModel;
import com.justinmind.util.datamanage.Utils;

public class MobileUtils {
    public MobileUtils(ApplicationContext applicationContext) {
    }

    public void setVisibleScrollBars(IComponent component, MobileRule rule) {
        boolean parentHasVerticalScroll = false;
        boolean parentHasHorizontalScroll = false;
        boolean horizontalScrollBar = false;
        boolean verticalScrollBar = false;
        if (component instanceof IPanel) {
            if (!((IPanel)component).getApiHorizontalOverflow().equals((Object)ILayout.ApiOverflowType.HIDDEN)) {
                horizontalScrollBar = true;
            }
            if (!((IPanel)component).getApiVerticalOverflow().equals((Object)ILayout.ApiOverflowType.HIDDEN)) {
                verticalScrollBar = true;
            }
        } else if (component instanceof ICellContainer) {
            if (!((ICellContainer)component).getApiHorizontalOverflow().equals((Object)ILayout.ApiOverflowType.HIDDEN)) {
                horizontalScrollBar = true;
            }
            if (!((ICellContainer)component).getApiVerticalOverflow().equals((Object)ILayout.ApiOverflowType.HIDDEN)) {
                verticalScrollBar = true;
            }
        } else if (component instanceof IDataGridCell) {
            if (!((IDataGridCell)component).getApiHorizontalOverflow().equals((Object)ILayout.ApiOverflowType.HIDDEN)) {
                horizontalScrollBar = true;
            }
            if (!((IDataGridCell)component).getApiVerticalOverflow().equals((Object)ILayout.ApiOverflowType.HIDDEN)) {
                verticalScrollBar = true;
            }
        }
        for (AbstractModel parent : Utils.findParents((AbstractModel)((AbstractModel)component))) {
            if (!(parent instanceof ItemContainer)) continue;
            if (((ItemContainer)parent).getHorizontalScrollbarVisible() > 0) {
                parentHasHorizontalScroll = true;
            }
            if (((ItemContainer)parent).getVerticalScrollbarVisible() <= 0) continue;
            parentHasVerticalScroll = true;
        }
        if (!parentHasHorizontalScroll && !parentHasVerticalScroll) {
            rule.showScrolls = true;
        }
        if (horizontalScrollBar && verticalScrollBar) {
            rule.direction = "multi";
        } else if (horizontalScrollBar) {
            rule.direction = "horizontal";
        } else if (verticalScrollBar) {
            rule.direction = "vertical";
        }
    }

    public void setAlwaysVisibleScrollBars(IComponent component, MobileRule rule) {
        rule.direction = "multi";
        rule.showScrolls = true;
    }

    public void setCustomVisibleScrollBars(IComponent component, MobileRule rule, String direction, boolean showScrolls) {
        rule.direction = direction;
        rule.showScrolls = showScrolls;
    }

    public void setCanvasCustomVisibleScrollBars(ICanvas canvas, IComponent component, MobileRule rule) {
        if (canvas.getApiCanvasBackgroundGrowth().equals((Object)ICanvas.ApiCanvasBackgroundGrowth.BOTH)) {
            rule.showScrolls = true;
            rule.direction = "multi";
        } else if (canvas.getApiCanvasBackgroundGrowth().equals((Object)ICanvas.ApiCanvasBackgroundGrowth.HORIZONTAL)) {
            rule.showScrolls = true;
            rule.direction = "horizontal";
        } else if (canvas.getApiCanvasBackgroundGrowth().equals((Object)ICanvas.ApiCanvasBackgroundGrowth.VERTICAL)) {
            rule.showScrolls = true;
            rule.direction = "vertical";
        } else {
            rule.direction = "none";
            rule.showScrolls = false;
        }
    }
}

