/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.requirements;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.requirements.ModelRequirement;
import com.justinmind.generator.context.requirements.ModelRequirementItem;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.output.HtmlStrategy;
import com.justinmind.generator.engine.output.OutputStrategy;
import com.justinmind.prototyper.api.requirement.IRequirement;
import com.justinmind.prototyper.api.requirement.IRootRequirement;
import com.justinmind.prototyper.api.scenario.IScenario;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.siteXmlDef.Igu.model.requirements.RequirementModel;
import java.util.ArrayList;
import java.util.List;
import org.stringtemplate.v4.ST;

public class RequirementsController
extends ContextController {
    private static final String TEMPLATE_REQUIREMENTS = "RequirementsTree";
    private static final String REQUIREMENTS = "nodes";
    private static final String GROUP_URL = "com/justinmind/generator/context/requirements/Requirements.stg";
    private static final String[] DFIELDS = new String[]{"Author", "Name", "Type", "Source", "Comments", "Description", "Justification", "Fit criteria", "Test"};

    public RequirementsController(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    protected OutputStrategy getOutputStrategy() {
        Object prettifyProperty = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.PRETTIFY);
        Boolean prettify = prettifyProperty instanceof Boolean ? (Boolean)prettifyProperty : true;
        Object compressHtml = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.COMPRESSHTML);
        Boolean compress = compressHtml instanceof Boolean ? (Boolean)compressHtml : false;
        return new HtmlStrategy(prettify, compress);
    }

    @Override
    public void generate() throws GeneratorException {
    }

    public String generateAsString() throws GeneratorException {
        if (this.prototype.getApiSimulationSettings().hasApiIncludeRequirements() && this.prototype.getApiRequirements().size() > 0) {
            ArrayList<ModelRequirement> reqs = new ArrayList<ModelRequirement>();
            Boolean[] defaultFields = this.filterVisibleDefaultFields(this.prototype.getApiVisibleDefaultRequirementFields());
            List visibleCustomFields = this.prototype.getApiVisibleCustomRequirementFields();
            for (IRootRequirement root : this.prototype.getApiRequirements()) {
                String uuid;
                IComponent c;
                IRequirement req = root.getApiActiveVersion();
                ModelRequirement context = new ModelRequirement();
                ArrayList<ModelRequirementItem> items = new ArrayList<ModelRequirementItem>();
                context.name = String.valueOf(req.getApiCode()) + " - " + req.getApiName();
                context.reqID = ((RequirementModel)root).getUuid();
                this.addDefaultFields(defaultFields, req, items);
                for (String customField : visibleCustomFields) {
                    String content = req.getApiCustomFieldValue(customField);
                    if (content == null || content.isEmpty()) continue;
                    items.add(new ModelRequirementItem(customField, content));
                }
                if (req.getApiIntegrationTool() != null && !req.getApiIntegrationTool().isEmpty()) {
                    context.hasIntegration = true;
                    context.integratedWith = req.getApiIntegrationTool();
                    context.integrationURL = req.getApiIntegrationURL();
                }
                if ((c = req.getApiComponent()) != null) {
                    context.hasComponent = true;
                    context.componentID = c.getApiId();
                    context.screenID = ControllerUtils.getID((IComponent)c.getApiCanvas());
                } else if (this.prototype.getApiSimulationSettings().hasApiIncludeScenarios() && (uuid = req.getApiComponentUuid()) != null && !uuid.isEmpty()) {
                    for (IScenario scenario : this.prototype.getApiScenarios()) {
                        if (!scenario.getApiId().equals(uuid)) continue;
                        context.hasComponent = true;
                        context.componentID = uuid;
                        context.screenID = "sc-" + uuid;
                        break;
                    }
                }
                context.items = items;
                reqs.add(context);
            }
            ST context = this.group.getInstanceOf(TEMPLATE_REQUIREMENTS);
            context.add(REQUIREMENTS, reqs);
            return this.outputEngine.writeString(context, this.strategy);
        }
        return "";
    }

    private void addDefaultFields(Boolean[] v, IRequirement req, List<ModelRequirementItem> items) {
        String t = req.getApiAuthor();
        if (v[0].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[0], t));
        }
        t = req.getApiName();
        if (v[1].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[1], t));
        }
        t = req.getApiType();
        if (v[2].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[2], t));
        }
        t = req.getApiSource();
        if (v[3].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[3], t));
        }
        t = req.getApiComments();
        if (v[4].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[4], t));
        }
        t = req.getApiDescription();
        if (v[5].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[5], t));
        }
        t = req.getApiJustification();
        if (v[6].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[6], t));
        }
        t = req.getApiFitCriteria();
        if (v[7].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[7], t));
        }
        t = req.getApiTest();
        if (v[8].booleanValue() && t != null && !t.isEmpty()) {
            items.add(new ModelRequirementItem(DFIELDS[8], t));
        }
    }

    private Boolean[] filterVisibleDefaultFields(List<String> visibleFields) {
        Boolean[] b = new Boolean[9];
        int i = 0;
        while (i < 9) {
            b[i] = this.containsString(visibleFields, DFIELDS[i]) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            ++i;
        }
        return b;
    }

    private boolean containsString(List<String> l, String s) {
        for (String s2 : l) {
            if (!s.equals(s2)) continue;
            return true;
        }
        return false;
    }
}

