/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.scale;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.attributerenderer.StringRenderer;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;

public class ScaleController
extends ContextController {
    private static final String GROUP_URL = "com/justinmind/generator/context/scale/Scale.stg";
    private static final String TEMPLATE_SCRIPT = "ScaleScript";
    private static final String SCALE = "scale";
    private static final String FIT_SCALE = "fitscreen";
    private static final String MODEL_WIDTH = "modelWidth";

    public ScaleController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        if (this.prototype.getApiSimulationSettings().getApiScale() != 100 || this.prototype.getApiSimulationSettings().hasApiFitScreen()) {
            String fileName = Paths.getScaleOutput(this.paths.output, this.applicationContext.getTime());
            ST context = this.group.getInstanceOf(TEMPLATE_SCRIPT);
            context.add(SCALE, (Object)(this.prototype.getApiSimulationSettings().hasApiFitScreen() ? 100 : this.prototype.getApiSimulationSettings().getApiScale()));
            context.add(FIT_SCALE, (Object)this.prototype.getApiSimulationSettings().hasApiFitScreen());
            context.add(MODEL_WIDTH, (Object)this.prototype.getApiWidth());
            this.outputEngine.write(fileName, context, this.strategy);
        }
    }
}

