/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.scenarios;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.context.css.CssControllerUtils;
import com.justinmind.generator.context.css.CssRule;
import com.justinmind.generator.context.scenarios.ModelScenario;
import com.justinmind.generator.context.scenarios.ModelScenarioComponent;
import com.justinmind.generator.context.scenarios.ModelScenarioInclude;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.prototyper.api.scenario.IScenario;
import com.justinmind.prototyper.api.scenario.IScenarioNode;
import com.justinmind.prototyper.api.scenario.IScenarioScreen;
import com.justinmind.prototyper.api.ui.StyleProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.stringtemplate.v4.ST;

public class ScenarioController
extends ContextController {
    private static final String SCENARIO = "scenario";
    private static final String TEMPLATE_SCENARIO = "Scenario";
    private static final String TEMPLATE_CSS = "Css";
    private static final String EXTENSION_CSS = ".css";
    private static final String PAGE = "Page";
    protected static final String RULES = "rules";
    private static final String GROUP_URL = "com/justinmind/generator/context/scenarios/Scenarios.stg";
    protected final transient Map<IScenario, ModelScenario> scenarioCache = new HashMap<IScenario, ModelScenario>();
    protected final transient CssControllerUtils utils;

    public ScenarioController(ApplicationContext applicationContext) {
        super(applicationContext);
        this.utils = new CssControllerUtils(applicationContext);
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    public void generate() throws GeneratorException {
        if (this.prototype.getApiSimulationSettings().hasApiIncludeScenarios() && this.prototype.getApiScenarios().size() > 0) {
            for (IScenario scenario : this.prototype.getApiScenarios()) {
                if (scenario == null) continue;
                String fileName = String.valueOf(this.paths.output) + this.paths.folderHTML + Paths.getScenarioURL(scenario) + ".html";
                ST context = this.group.getInstanceOf(TEMPLATE_SCENARIO);
                context.add(SCENARIO, (Object)this.processScenario(scenario));
                this.outputEngine.write(fileName, context, this.strategy);
                int[] bounds = scenario.getApiBounds();
                String scenarioID = scenario.getApiId();
                String CssFileName = Paths.getScenarioOutput(this.paths.output, scenario, this.applicationContext.getTime()).append(EXTENSION_CSS).toString();
                ST CssContext = this.group.getInstanceOf(TEMPLATE_CSS);
                ArrayList<CssRule> cssRules = new ArrayList<CssRule>();
                for (IScenarioNode node : scenario.getApiNodes()) {
                    cssRules.add(this.processScenarioItemCssRule(node, scenarioID, bounds[0], bounds[1]));
                }
                CssRule wrapper = new CssRule("#scenarioWrapper");
                wrapper.add(StyleProperty.WIDTH, String.valueOf(String.valueOf(bounds[2])) + "px");
                cssRules.add(wrapper);
                CssContext.add(RULES, cssRules);
                this.outputEngine.write(CssFileName, CssContext, this.strategy);
            }
            this.scenarioCache.clear();
        }
    }

    protected ModelScenario processScenario(IScenario scenario) {
        ModelScenario scenarioModel = this.scenarioCache.get(scenario);
        HashMap<String, List<IScenarioNode>> graph = this.processScenarioLinks(scenario);
        if (scenarioModel == null) {
            scenarioModel = new ModelScenario();
            scenarioModel.date = scenario.getApiLastDate();
            scenarioModel.identifier = scenario.getApiId();
            scenarioModel.name = scenario.getApiName();
            scenarioModel.nodes = this.processScenarioComponents(scenario, graph);
            scenarioModel.include = this.processScenarioIncludes(scenario);
            this.scenarioCache.put(scenario, scenarioModel);
        }
        return scenarioModel;
    }

    private List<ModelScenarioComponent> processScenarioComponents(IScenario scenario, HashMap<String, List<IScenarioNode>> graph) {
        ArrayList<ModelScenarioComponent> contexts = new ArrayList<ModelScenarioComponent>();
        for (IScenarioNode node : scenario.getApiNodes()) {
            String sId;
            if (!node.getApiNodeType().equals(PAGE) || (sId = ((IScenarioScreen)node).getApiScreenId()) == null || sId.isEmpty()) continue;
            ModelScenarioComponent context = new ModelScenarioComponent();
            context.identifier = node.getApiId();
            context.type = node.getApiNodeType();
            context.name = node.getApiName();
            context.screenId = sId;
            String edges = "";
            List<IScenarioNode> links = graph.get(node.getApiId());
            int i = 0;
            while (i < links.size() - 1) {
                edges = edges.concat(String.valueOf(links.get(i).getApiId()) + ",");
                ++i;
            }
            if (!links.isEmpty()) {
                edges = edges.concat(links.get(links.size() - 1).getApiId());
            }
            context.linkedScreens = edges;
            contexts.add(context);
        }
        return contexts;
    }

    protected ModelScenarioInclude processScenarioIncludes(IScenario scenario) {
        ModelScenarioInclude context = new ModelScenarioInclude();
        String include = Paths.getScenarioOutput(this.paths.base, scenario, this.applicationContext.getTime()).toString();
        context.style.add(String.valueOf(include) + EXTENSION_CSS);
        context.styleIE.add(String.valueOf(include) + "-ie.css");
        context.styleIE8.add(String.valueOf(include) + "-ie8.css");
        return context;
    }

    private CssRule processScenarioItemCssRule(IScenarioNode node, String scenarioID, int bx, int by) {
        String selector = ".sc-" + scenarioID + " #n" + node.getApiId();
        CssRule rule = new CssRule(selector);
        rule.add(StyleProperty.LEFT, String.valueOf(String.valueOf(node.getApiLeft() - bx)) + "px");
        rule.add(StyleProperty.TOP, String.valueOf(String.valueOf(node.getApiTop() - by)) + "px");
        rule.add(StyleProperty.WIDTH, String.valueOf(String.valueOf(node.getApiWidth())) + "px");
        rule.add(StyleProperty.HEIGHT, String.valueOf(String.valueOf(node.getApiHeight())) + "px");
        return rule;
    }

    private HashMap<String, List<IScenarioNode>> processScenarioLinks(IScenario scenario) {
        HashMap<String, List<IScenarioNode>> map = new HashMap<String, List<IScenarioNode>>();
        for (IScenarioNode n : scenario.getApiNodes()) {
            String id = n.getApiId();
            if (!this.isLinkedScreen(n)) continue;
            List<IScenarioNode> l = this.searchLinkedScreens(n, new ArrayList<Integer>(Collections.nCopies(scenario.getApiNodes().size(), 0)));
            map.put(id, l);
        }
        return map;
    }

    private List<IScenarioNode> searchLinkedScreens(IScenarioNode n, List<Integer> visited) {
        ArrayList<IScenarioNode> l = new ArrayList<IScenarioNode>();
        for (IScenarioNode t : n.getApiOutgoingEdges()) {
            int index = Integer.parseInt(t.getApiId());
            if (visited.get(index) != 0) continue;
            visited.set(index, 1);
            if (this.isLinkedScreen(t)) {
                l.add(t);
                continue;
            }
            l.addAll(this.searchLinkedScreens(t, visited));
        }
        return l;
    }

    private boolean isLinkedScreen(IScenarioNode n) {
        return n.getApiNodeType().equals(PAGE) && ((IScenarioScreen)n).getApiScreenId() != null && !((IScenarioScreen)n).getApiScreenId().isEmpty();
    }
}

