/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.view;

import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextModel;
import com.justinmind.generator.engine.Paths;
import java.util.ArrayList;
import java.util.List;

public final class ModelInclude
extends ContextModel {
    protected transient String cssPath;
    protected transient String cssIEPath;
    protected transient String cssIE8Path;
    protected transient String scriptPath;
    protected transient List<String> style;
    protected transient List<String> styleIE;
    protected transient List<String> styleIE8;
    protected transient List<String> script;

    protected ModelInclude() {
        this.style = new ArrayList<String>();
        this.styleIE = new ArrayList<String>();
        this.styleIE8 = new ArrayList<String>();
        this.script = new ArrayList<String>();
    }

    protected ModelInclude(ApplicationContext applicationContext) {
        this();
        Paths paths = applicationContext.getPaths();
        this.cssPath = Paths.getIncludeStyleOutput(paths.base, paths.folderHTML, applicationContext.getTime());
        this.cssIEPath = Paths.getIncludeStyleIEOutput(paths.base, paths.folderHTML, applicationContext.getTime());
        this.cssIE8Path = Paths.getIncludeStyleIE8Output(paths.base, paths.folderHTML, applicationContext.getTime());
        this.scriptPath = Paths.getIncludeScriptOutput(paths.base, paths.folderHTML, applicationContext.getTime());
    }

    protected ModelInclude(ModelInclude original) {
        if (original == null) {
            this.style = new ArrayList<String>();
            this.styleIE = new ArrayList<String>();
            this.styleIE8 = new ArrayList<String>();
            this.script = new ArrayList<String>();
        } else {
            this.cssPath = original.cssPath;
            this.cssIEPath = original.cssIEPath;
            this.cssIE8Path = original.cssIE8Path;
            this.scriptPath = original.scriptPath;
            this.style = new ArrayList<String>(original.style);
            this.styleIE = new ArrayList<String>(original.styleIE);
            this.script = new ArrayList<String>(original.script);
        }
    }

    public String getCssPath() {
        return this.cssPath;
    }

    public String getCssIEPath() {
        return this.cssIEPath;
    }

    public String getCssIE8Path() {
        return this.cssIE8Path;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public List<String> getStyle() {
        return this.style;
    }

    public List<String> getStyleIE() {
        return this.styleIE;
    }

    public List<String> getStyleIE8() {
        return this.styleIE8;
    }

    public List<String> getScript() {
        return this.script;
    }
}

