/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.view;

import com.justinmind.generator.context.ContextModel;
import com.justinmind.generator.context.view.ModelComponent;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.ui.component.ICellContainer;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataCell;
import com.justinmind.prototyper.api.ui.component.IDataGridCell;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.prototyper.api.ui.component.IPanel;
import com.justinmind.prototyper.api.ui.event.ITarget;
import java.util.ArrayList;
import java.util.List;

public final class ModelLayout
extends ContextModel {
    public static final String LAYOUT_FREE = "free";
    public static final String LAYOUT_VERTICAL = "vertical";
    public static final String LAYOUT_HORIZONTAL = "horizontal";
    protected transient String layout;
    protected transient String align;
    protected transient String valign;
    protected transient String vspacing;
    protected transient String hspacing;
    protected transient String id;
    protected transient String parentID;
    protected transient List<ModelComponent> components;
    public transient boolean isWrap;
    public transient boolean isHSpaced;

    protected ModelLayout(ILayout layout) {
        this.isWrap = false;
        this.isHSpaced = false;
        switch (layout.getApiLayoutType()) {
            case FREE: {
                this.layout = LAYOUT_FREE;
                this.vspacing = String.valueOf(0);
                this.hspacing = String.valueOf(0);
                break;
            }
            case HORIZONTAL: {
                this.layout = LAYOUT_HORIZONTAL;
                this.valign = layout.getApiVerticalAlignment().toString();
                this.align = layout.getApiHorizontalAlignment().toString();
                this.hspacing = String.valueOf(layout.getApiHorizontalSpacing());
                this.vspacing = String.valueOf(layout.getApiVerticalSpacing());
                if (layout.getApiHorizontalSpacing() == 0) break;
                this.isHSpaced = true;
                break;
            }
            case VERTICAL: {
                this.layout = LAYOUT_VERTICAL;
                this.valign = layout.getApiVerticalAlignment().toString();
                this.align = layout.getApiHorizontalAlignment().toString();
                this.vspacing = String.valueOf(layout.getApiVerticalSpacing());
                this.hspacing = String.valueOf(layout.getApiHorizontalSpacing());
                break;
            }
        }
        this.components = new ArrayList<ModelComponent>();
        this.id = "";
        this.parentID = "";
    }

    protected ModelLayout(ModelLayout original) {
        this.layout = original.layout;
        this.align = original.align;
        this.valign = original.valign;
        this.components = new ArrayList<ModelComponent>(original.components);
    }

    public void setWrap(IComponent container) {
        TypeAdaptor.ComponentType type = TypeAdaptor.getComponentType((ITarget)container);
        switch (type) {
            case CELLCONTAINER: {
                ICellContainer cell = (ICellContainer)container;
                this.isWrap = cell.getApiHorizontalOverflow() == ILayout.ApiOverflowType.WRAP || cell.getApiVerticalOverflow() == ILayout.ApiOverflowType.WRAP;
                break;
            }
            case PANEL: {
                IPanel panel = (IPanel)container;
                this.isWrap = panel.getApiHorizontalOverflow() == ILayout.ApiOverflowType.WRAP || panel.getApiVerticalOverflow() == ILayout.ApiOverflowType.WRAP;
                break;
            }
            case DATACELL: {
                IDataCell dcell = (IDataCell)container;
                this.isWrap = dcell.getApiHorizontalOverflow() == ILayout.ApiOverflowType.WRAP || dcell.getApiVerticalOverflow() == ILayout.ApiOverflowType.WRAP;
                break;
            }
            case GRIDCELL: {
                IDataGridCell dgcell = (IDataGridCell)container;
                this.isWrap = dgcell.getApiHorizontalOverflow() == ILayout.ApiOverflowType.WRAP || dgcell.getApiVerticalOverflow() == ILayout.ApiOverflowType.WRAP;
                break;
            }
            default: {
                this.isWrap = false;
            }
        }
    }

    public void setId(IComponent comp) {
        this.id = comp.getApiId();
    }

    public void setParentId(IComponent comp) {
        this.parentID = comp.getApiId();
    }

    private String swapLayouts() {
        if (this.layout.equals(LAYOUT_VERTICAL)) {
            return "horizontal verticalWrap";
        }
        return this.layout;
    }

    public String getLayout() {
        return this.layout;
    }

    public String getAlign() {
        return this.align;
    }

    public String getValign() {
        return this.valign;
    }

    public List<ModelComponent> getComponents() {
        return this.components;
    }

    public Boolean hasFreeLayout() {
        return this.layout.equals(LAYOUT_FREE);
    }

    public String getVspacing() {
        return this.vspacing;
    }

    public String getHspacing() {
        return this.hspacing;
    }

    public boolean getIsHSpaced() {
        return this.isHSpaced;
    }

    public String getClasses() {
        StringBuilder classNames = new StringBuilder();
        classNames.append("layout");
        classNames.append(" ");
        classNames.append(this.isWrap ? this.swapLayouts() : this.layout);
        classNames.append(" ");
        classNames.append("insertionpoint");
        classNames.append(" ");
        classNames.append("verticalalign");
        classNames.append(this.isWrap ? " wrap" : "");
        if (!this.layout.equals(LAYOUT_FREE)) {
            classNames.append(" ");
            classNames.append(this.id);
            classNames.append(" ");
            classNames.append(this.parentID);
        }
        return classNames.toString();
    }
}

