/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.view;

import com.justinmind.evc.model.actions.folders.AbstractFolder;
import com.justinmind.evc.model.actions.folders.CanvasFolder;
import com.justinmind.evc.model.actions.folders.FolderType;
import com.justinmind.evc.model.projects.EVCProjectModel;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.requirements.RequirementsController;
import com.justinmind.generator.context.view.ModelHighlightOptions;
import com.justinmind.generator.context.view.ModelInclude;
import com.justinmind.generator.context.view.ModelIndex;
import com.justinmind.generator.context.view.ModelMobileOptions;
import com.justinmind.generator.context.view.ModelNavigationTreeNode;
import com.justinmind.generator.context.view.ModelScenarioNavigationTreeNode;
import com.justinmind.generator.context.view.ViewController;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.prototyper.api.scenario.IScenario;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.event.EventType;
import com.justinmind.prototyper.api.ui.simulation.SimulationDevice;
import com.justinmind.prototyper.api.ui.simulation.SimulationOrientation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ViewControllerReview
extends ViewController {
    private static final String GROUP_URL = "com/justinmind/generator/context/view/ViewReview.stg";
    private RequirementsController requirementsController;

    public ViewControllerReview(ApplicationContext applicationContext) {
        super(applicationContext);
        this.requirementsController = new RequirementsController(applicationContext);
    }

    @Override
    protected String getGroupURL() {
        return GROUP_URL;
    }

    @Override
    protected ModelIndex processIndex() {
        ModelIndex index = super.processIndex();
        Object showSidePanel = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.SHOWSIDEPANEL);
        Boolean bHighlight = this.prototype.getApiSimulationSettings().hasApiHighlight();
        Boolean bShowSidePanel = showSidePanel instanceof Boolean ? (Boolean)showSidePanel : true;
        index.title = this.prototype.getApiName();
        index.applicationPath = this.paths.resourcesReference;
        index.nodes = this.processNavigationTree();
        index.simulationClasses = (Object)((Object)this.applicationContext.getApplicationType()) + " offline" + (bShowSidePanel != false ? " showComments" : "") + (bHighlight == false ? " noHighlight " : "");
        index.setTestScript(this.applicationContext.getTestScript());
        index.include = new ModelInclude(this.applicationContext);
        index.autoHighlight = bHighlight != false ? "on" : "off";
        index.showSidePanel = bShowSidePanel;
        index.mobileOptions = this.processMobileOptions();
        index.highlightOptions = this.processHighlightOptions();
        Boolean includeScenarios = this.prototype.getApiSimulationSettings().hasApiIncludeScenarios();
        int size = this.prototype.getApiScenarios().size();
        if (size == 1) {
            IScenario def = (IScenario)this.prototype.getApiScenarios().get(0);
            if (def.getApiName().equals("default") && def.getApiNodes().size() == 0) {
                includeScenarios = false;
            }
        } else if (size == 0) {
            includeScenarios = false;
        }
        index.simulationClasses = index.simulationClasses.concat(includeScenarios == false ? " noScenarios" : "");
        index.scenarioNodes = this.processScenarioTree();
        if (this.prototype.getApiSimulationSettings().hasApiIncludeRequirements() && this.prototype.getApiRequirements().size() > 0) {
            index.hasRequirements = true;
            try {
                index.requirementNodes = this.requirementsController.generateAsString();
            }
            catch (GeneratorException generatorException) {}
        } else {
            index.hasRequirements = false;
        }
        return index;
    }

    @Override
    protected ModelInclude processCanvasIncludes(ICanvas canvas) {
        ModelInclude context = new ModelInclude();
        String include = Paths.getCanvasOutput(this.paths.base, canvas, this.applicationContext.getTime()).toString();
        context.style.add(String.valueOf(include) + ".css");
        context.styleIE.add(String.valueOf(include) + "-ie.css");
        context.styleIE8.add(String.valueOf(include) + "-ie8.css");
        return context;
    }

    private List<ModelScenarioNavigationTreeNode> processScenarioTree() {
        ArrayList<ModelScenarioNavigationTreeNode> scenarios = new ArrayList<ModelScenarioNavigationTreeNode>();
        List modelScenarios = ((EVCProjectModel)this.prototype).getApiScenarios();
        for (IScenario scenario : modelScenarios) {
            if (scenario == null) continue;
            ModelScenarioNavigationTreeNode node = new ModelScenarioNavigationTreeNode();
            node.text = scenario.getApiName();
            node.link = Paths.getScenarioURL(scenario);
            node.scenarioID = scenario.getApiId();
            scenarios.add(node);
        }
        return scenarios;
    }

    private List<ModelNavigationTreeNode> processNavigationTree() {
        List<ModelNavigationTreeNode> nodes = this.processNavigationTreeNode((AbstractFolder)((EVCProjectModel)this.prototype).getFolderManager().getRootFolder());
        nodes.get((int)(nodes.size() - 1)).classes.add("last");
        return nodes;
    }

    private List<ModelNavigationTreeNode> processNavigationTreeNode(AbstractFolder folder) {
        ArrayList<ModelNavigationTreeNode> nodes = new ArrayList<ModelNavigationTreeNode>();
        for (AbstractFolder child : folder.getChildFolders()) {
            ModelNavigationTreeNode node = new ModelNavigationTreeNode();
            String name = child.getName();
            if (name == null) continue;
            node.text = name;
            if (child.getType().equals((Object)FolderType.CANVAS)) {
                node.link = Paths.getCanvasURL((ICanvas)((CanvasFolder)child).getAbstractCanvas());
                node.canvasId = ((CanvasFolder)child).getAbstractCanvas().getCompleteUserId();
            } else {
                node.isFolder = true;
                node.link = "#";
                node.classes.add("folder");
            }
            if (child.getChildFolders().isEmpty()) {
                node.classes.add("leaf");
            } else {
                node.classes.add("closed");
                node.nodes = this.processNavigationTreeNode(child);
                node.nodes.get((int)(node.nodes.size() - 1)).classes.add("last");
            }
            nodes.add(node);
        }
        return nodes;
    }

    private ModelMobileOptions processMobileOptions() {
        SimulationDevice device = this.prototype.getApiSimulationSettings().getApiSimulationDevice();
        ModelMobileOptions options = new ModelMobileOptions();
        options.device = device.name().toLowerCase(Locale.ENGLISH);
        options.isMobilePrototype = this.applicationContext.isMobile();
        options.isMobileCustomSize = device == SimulationDevice.MOBILECUSTOM || SimulationDevice.isAndroidDevice((SimulationDevice)device);
        options.isMobilePortrait = options.isMobileCustomSize != false ? true : this.prototype.getApiSimulationSettings().getApiSimulationOrientation().compareTo((Enum)SimulationOrientation.PORTRAIT) == 0;
        options.showTopPanel = this.prototype.getApiSimulationSettings().hasApiTopPanel() && options.isMobilePrototype != false;
        options.showRotateButton = this.prototype.getApiSimulationSettings().hasApiRotate();
        options.showToolButton = this.prototype.getApiSimulationSettings().hasApiGestureTool();
        options.showZoomButton = this.prototype.getApiSimulationSettings().hasApiZoom();
        return options;
    }

    private List<ModelHighlightOptions> processHighlightOptions() {
        ArrayList<ModelHighlightOptions> options = new ArrayList<ModelHighlightOptions>();
        ModelHighlightOptions mho = new ModelHighlightOptions();
        mho.name = "All";
        mho.options = "." + ControllerUtils.typeToString(EventType.ON_CLICK) + ", ." + ControllerUtils.typeToString(EventType.ON_TOGGLE) + ", .dblclick, ." + ControllerUtils.typeToString(EventType.ON_RIGHT_CLICK) + ", ." + ControllerUtils.typeToString(EventType.ON_MOUSE_ENTER) + ", ." + ControllerUtils.typeToString(EventType.ON_MOUSE_LEAVE) + ", ." + ControllerUtils.typeToString(EventType.ON_MOUSE_OVER) + ", ." + ControllerUtils.typeToString(EventType.ON_DRAG) + ", ." + ControllerUtils.typeToString(EventType.ON_CHANGE) + ", ." + ControllerUtils.typeToString(EventType.ON_FOCUS_IN) + ", ." + ControllerUtils.typeToString(EventType.ON_FOCUS_OUT) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_UP) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_DOWN) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_LEFT) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHT) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_LEFTUP) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_LEFTDOWN) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHTUP) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHTDOWN) + ", ." + ControllerUtils.typeToString(EventType.ON_TAPHOLD);
        options.add(mho);
        EventType[] eventTypeArray = EventType.values();
        int n = eventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventType eventType = eventTypeArray[n2];
            switch (eventType) {
                case ON_CLICK: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Click/Tap";
                    mho.options = "." + ControllerUtils.typeToString(EventType.ON_CLICK) + ", ." + ControllerUtils.typeToString(EventType.ON_TOGGLE);
                    options.add(mho);
                    break;
                }
                case ON_DOUBLE_CLICK: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Double Click";
                    mho.options = ".dblclick";
                    options.add(mho);
                    break;
                }
                case ON_RIGHT_CLICK: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Right Click";
                    mho.options = "." + ControllerUtils.typeToString(EventType.ON_RIGHT_CLICK);
                    options.add(mho);
                    break;
                }
                case ON_MOUSE_OVER: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Mouse Over";
                    mho.options = "." + ControllerUtils.typeToString(EventType.ON_MOUSE_ENTER) + ", ." + ControllerUtils.typeToString(EventType.ON_MOUSE_LEAVE) + ", ." + ControllerUtils.typeToString(EventType.ON_MOUSE_OVER);
                    options.add(mho);
                    break;
                }
                case ON_DRAG: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Drag";
                    mho.options = "." + ControllerUtils.typeToString(EventType.ON_DRAG);
                    options.add(mho);
                    break;
                }
                case ON_CHANGE: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Change";
                    mho.options = "." + ControllerUtils.typeToString(EventType.ON_CHANGE);
                    options.add(mho);
                    break;
                }
                case ON_FOCUS_IN: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Focus In/Out";
                    mho.options = "." + ControllerUtils.typeToString(EventType.ON_FOCUS_IN) + ", ." + ControllerUtils.typeToString(EventType.ON_FOCUS_OUT);
                    options.add(mho);
                    break;
                }
                case ON_SWIPE_UP: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Swipe";
                    mho.options = "." + ControllerUtils.typeToString(EventType.ON_SWIPE_UP) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_DOWN) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_LEFT) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHT) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_LEFTUP) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_LEFTDOWN) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHTUP) + ", ." + ControllerUtils.typeToString(EventType.ON_SWIPE_RIGHTDOWN);
                    options.add(mho);
                    break;
                }
                case ON_TAPHOLD: {
                    mho = new ModelHighlightOptions();
                    mho.name = "Tap & Hold";
                    mho.options = "." + ControllerUtils.typeToString(EventType.ON_TAPHOLD);
                    options.add(mho);
                    break;
                }
            }
            ++n2;
        }
        return options;
    }
}

