/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.context.view;

import com.justinmind.evc.model.actions.Tab;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.context.css.CssControllerUtils;
import com.justinmind.generator.engine.attributerenderer.StringRenderer;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.ui.IStyle;
import com.justinmind.prototyper.api.ui.StyleProperty;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.canvas.IScreen;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.component.IDataCell;
import com.justinmind.prototyper.api.ui.component.IDataGrid;
import com.justinmind.prototyper.api.ui.component.IDataGridCell;
import com.justinmind.prototyper.api.ui.component.IDataList;
import com.justinmind.prototyper.api.ui.component.IDataRow;
import com.justinmind.prototyper.api.ui.component.IHeaderRow;
import com.justinmind.prototyper.api.ui.component.IInput;
import com.justinmind.prototyper.api.ui.component.ILayout;
import com.justinmind.prototyper.api.ui.component.IMenu;
import com.justinmind.prototyper.api.ui.component.ISelect;
import com.justinmind.prototyper.api.ui.component.ITable;
import com.justinmind.prototyper.api.ui.component.ITextComponent;
import com.justinmind.prototyper.api.ui.component.ITree;
import com.justinmind.prototyper.api.ui.data.IField;
import com.justinmind.prototyper.api.ui.event.EventType;
import com.justinmind.prototyper.api.ui.event.IEvent;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.util.datamanage.StringUtils;
import com.justinmind.util.datamanage.Utils;
import com.justinmind.util.xml.XMLUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class ViewControllerUtils {
    protected static final String FIRER = "firer";
    private static final String COMMENTABLE = "commentable";
    private static final String IE_BACKGROUND = "ie-background";
    protected static final String SHAPE = "shape";
    protected static final String N_SHAPE = "non-processed-shape";
    protected static final String AUTOFIT = "autofit";
    private final transient ApplicationContext applicationContext;

    public ViewControllerUtils(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected String processClasses(IComponent component) {
        Object hasComments;
        TypeAdaptor.ComponentType componentType = TypeAdaptor.getComponentType((ITarget)component);
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        IStyle style = component.getApiStyle();
        if (CssControllerUtils.hasRoundedBorder(style).booleanValue() || CssControllerUtils.hasGradient(style).booleanValue() || CssControllerUtils.hasShadow(style).booleanValue()) {
            classes.add("pie");
        }
        switch (componentType) {
            case BUTTON: 
            case LABEL: {
                classes.add(ControllerUtils.typeToString(componentType));
                classes.add(((ITextComponent)component).isApiSingleLine() ? "singleline" : "multiline");
                break;
            }
            case DATACELL: {
                IDataCell datacell = (IDataCell)component;
                classes.add("datacell");
                ITable parent = datacell.getApiParent();
                if (!(parent instanceof IDataList)) break;
                IStyle evenRowStyle = ((IDataList)parent).getApiEvenItemStyle();
                IStyle oddRowStyle = ((IDataList)parent).getApiOddItemStyle();
                if (!CssControllerUtils.hasGradient(evenRowStyle).booleanValue() && !CssControllerUtils.hasGradient(oddRowStyle).booleanValue()) break;
                classes.add("pie");
                break;
            }
            case DATAROW: {
                IDataRow datarow = (IDataRow)component;
                classes.add(datarow.getApiParent().getApiHeader().equals(datarow) ? "headerrow" : "datarow");
                break;
            }
            case PANEL: {
                classes.add(ControllerUtils.typeToString(componentType));
                Tab tab = (Tab)component;
                classes.add(tab.equals(tab.getTabbedBox().getDefaultTab()) ? "default" : "hidden");
                break;
            }
            case ROOTCOMPONENT: {
                ICanvas canvas = component.getApiCanvas();
                classes.add(ControllerUtils.typeToString(TypeAdaptor.getComponentType((ITarget)canvas)));
                classes.add("growth-" + canvas.getApiCanvasBackgroundGrowth().toString());
                if (!(canvas instanceof IScreen)) break;
                classes.add(canvas.getApiOrientation());
                break;
            }
            case MENU: {
                classes.add(ControllerUtils.typeToString(componentType));
                classes.add(((IMenu)component).getApiLayoutType().equals((Object)ILayout.ApiLayoutType.HORIZONTAL) ? "horizontal" : "vertical");
                break;
            }
            case MENUNODE: {
                classes.add(ControllerUtils.typeToString(componentType));
                if (component.getApiChildren().isEmpty()) break;
                classes.add("has-submenu");
                break;
            }
            case TREE: {
                classes.add(ControllerUtils.typeToString(componentType));
                if (!((ITree)component).showApiLines().booleanValue()) break;
                classes.add("withlines");
                break;
            }
            case LINE: 
            case ELLIPSE: 
            case TRIANGLE: 
            case CALLOUT: {
                classes.add(ControllerUtils.typeToString(componentType));
                classes.add(SHAPE);
                classes.add(N_SHAPE);
                if (!(component instanceof ITextComponent) || !((ITextComponent)component).getApiAutoFit()) break;
                classes.add(AUTOFIT);
                break;
            }
            case DATAGRID: {
                classes.add(ControllerUtils.typeToString(componentType));
                classes.add(((IDataGrid)component).getApiLayoutType().equals((Object)ILayout.ApiLayoutType.HORIZONTAL) ? "horizontal" : "vertical");
                break;
            }
            case NUMBER: 
            case EMAIL: 
            case INPUTURL: {
                classes.add(ControllerUtils.typeToString(componentType));
                classes.add("text");
                break;
            }
            default: {
                classes.add(ControllerUtils.typeToString(componentType));
            }
        }
        classes.add(FIRER);
        for (IEvent event : component.getApiEvents()) {
            EventType eventType = event.getApiEventType();
            switch (eventType) {
                case ON_MOUSE_OVER: {
                    classes.add(ControllerUtils.typeToString(EventType.ON_MOUSE_ENTER));
                    classes.add(ControllerUtils.typeToString(EventType.ON_MOUSE_LEAVE));
                    break;
                }
                case ON_DRAG: {
                    classes.add(ControllerUtils.typeToString(EventType.ON_DRAG_START));
                    classes.add(ControllerUtils.typeToString(EventType.ON_DRAG));
                    classes.add(ControllerUtils.typeToString(EventType.ON_DRAG_END));
                    break;
                }
                case ON_DRAG_END: {
                    classes.add(ControllerUtils.typeToString(EventType.ON_DRAG));
                    classes.add(ControllerUtils.typeToString(EventType.ON_DRAG_END));
                    break;
                }
                default: {
                    classes.add(ControllerUtils.typeToString(eventType));
                }
            }
        }
        String bgColor = style.getProperty(StyleProperty.BACKGROUND_COLOR);
        if (!componentType.equals((Object)TypeAdaptor.ComponentType.RADIOBUTTON) && !componentType.equals((Object)TypeAdaptor.ComponentType.CHECKBOX) && style.getProperty(StyleProperty.BACKGROUND_IMAGE) == null && (bgColor == null || bgColor != null && bgColor.equals("transparent"))) {
            classes.add(IE_BACKGROUND);
        }
        if ((hasComments = this.applicationContext.getProperties().get((Object)ApplicationContext.PropertyType.COMMENTABLE)) instanceof Boolean && ((Boolean)hasComments).booleanValue() && this.isCommentable(componentType)) {
            classes.add(COMMENTABLE);
        }
        StringBuilder classNames = new StringBuilder();
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            classNames.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            classNames.append(" ");
        }
        return classNames.toString();
    }

    private boolean isCommentable(TypeAdaptor.ComponentType componentType) {
        boolean isCommentable = true;
        switch (componentType) {
            case CELLCONTAINER: 
            case TEXTCELL: 
            case DATAROW: 
            case DATACELL: {
                isCommentable = false;
            }
        }
        return isCommentable;
    }

    protected Object processValue(IInput component) {
        Object value = null;
        if (this.inDataView((IComponent)component).booleanValue() && component.getApiField() != null) {
            value = this.processProperty(component.getApiField());
        } else {
            switch (TypeAdaptor.getComponentType((ITarget)component)) {
                case TEXTAREA: {
                    String text = component.getApiValue();
                    if ("\r\n".equals(text)) {
                        text = "\r\n\r\n";
                    }
                    text = StringUtils.replace((String)text, (String)"&", (String)"&amp;");
                    text = StringUtils.replace((String)text, (String)"<", (String)" &lt;");
                    text = StringUtils.replace((String)text, (String)">", (String)" &gt;");
                    text = StringUtils.replace((String)text, (String)"\r\n", (String)"&#10;");
                    text = StringUtils.replace((String)text, (String)"\n", (String)"&#10;");
                    value = text;
                    break;
                }
                case CHECKBOX: 
                case RADIOBUTTON: {
                    value = Boolean.parseBoolean(component.getApiValue());
                    break;
                }
                case DROPDOWN: 
                case NATIVEDROPDOWN: {
                    List descriptionList = ((ISelect)component).getApiSelections();
                    value = descriptionList.size() == 1 ? (String)descriptionList.get(0) : "";
                    break;
                }
                default: {
                    value = component.getApiValue();
                }
            }
        }
        return value;
    }

    protected String processProperty(IField field) {
        return "{{!it.userdata[" + StringRenderer.escapeJSON(ControllerUtils.getName((ITarget)field)) + "]}}";
    }

    protected String processXMLtoHTML(Element root, String itemID, String indexPattern) {
        root.removeAttribute("style");
        List srcElements = XMLUtil.selectNodesWithXPath((Object)root, (String)"descendant-or-self::node() [(@src and not(starts-with(@src,'http://'))) or (@name='src')]");
        String url = null;
        for (Element current : srcElements) {
            current.removeAttribute("style");
            if (url == null) {
                Integer split;
                url = current.getName().equals("param") ? current.getAttributeValue("value") : current.getAttributeValue("src");
                Integer idx = (url = url.replace("\\", "/")).indexOf(indexPattern);
                if (idx > 0) {
                    url = String.valueOf(this.applicationContext.getPaths().base) + url.substring(idx);
                }
                if ((split = Integer.valueOf(url.lastIndexOf(".pdf#"))) > 0) {
                    StringBuilder urlFragments = new StringBuilder();
                    urlFragments.append(StringRenderer.escapeURLFragment(url.substring(0, split)));
                    urlFragments.append(url.substring(split));
                    url = urlFragments.toString();
                }
            }
            if (current.getName().equals("param")) {
                current.setAttribute("value", url);
                continue;
            }
            current.setAttribute("src", url);
        }
        XMLOutputter serializer = new XMLOutputter();
        serializer.setFormat(Format.getPrettyFormat().setExpandEmptyElements(true));
        return serializer.outputString(root);
    }

    protected Boolean inDataView(IComponent component) {
        IHeaderRow header;
        Boolean inDataRow = false;
        IDataRow row = (IDataRow)Utils.getParent((IComponent)component, IDataRow.class);
        if (row != null && (header = row.getApiParent().getApiHeader()) != null) {
            inDataRow = !header.equals(row);
        }
        if (inDataRow.booleanValue()) {
            return inDataRow;
        }
        IDataGridCell gridCell = (IDataGridCell)Utils.getParent((IComponent)component, IDataGridCell.class);
        if (gridCell != null) {
            return true;
        }
        return false;
    }
}

