/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine;

import com.justinmind.evc.model.actions.AbstractCanvas;
import com.justinmind.evc.model.actions.Cell;
import com.justinmind.generator.application.ApplicationContext;
import com.justinmind.generator.context.ContextController;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.PostProcess;
import com.justinmind.prototyper.api.IPrototype;
import com.justinmind.prototyper.api.ui.component.ICellContainer;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.util.datamanage.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class Generator {
    public static final Logger LOG = Logger.getLogger((String)"com.justinmind.generator");
    private static final String DASHES = "--------------------------------------------------";
    private final transient List<ParallelGenerator> generators = new ArrayList<ParallelGenerator>();
    private final transient Map<Thread, GeneratorException> threadExceptions = new HashMap<Thread, GeneratorException>();
    private final transient ApplicationContext context;
    private final transient PostProcess postProcessor;
    private final transient List<ContextController> controllers;

    public Generator(IPrototype prototype, String installPath, String outputPath, Boolean optimize, Boolean test) {
        this.context = new ApplicationContext(prototype, optimize, this.getPaths(prototype.getApiPath(), installPath, outputPath), this.getProperties(optimize), this.getType(), test);
        this.postProcessor = this.buildPostProcess(this.context);
        this.controllers = this.getContextControllers(this.context);
    }

    protected abstract Map<ApplicationContext.PropertyType, Object> getProperties(Boolean var1);

    protected abstract ApplicationContext.ApplicationType getType();

    protected abstract List<ContextController> getContextControllers(ApplicationContext var1);

    protected abstract Paths getPaths(String var1, String var2, String var3);

    protected abstract PostProcess buildPostProcess(ApplicationContext var1);

    public final void abortGeneration() {
        for (ParallelGenerator parallelGenerator : this.generators) {
            if (!parallelGenerator.isAlive()) continue;
            parallelGenerator.interrupt();
            parallelGenerator.stop();
            Object var1_2 = null;
        }
        this.clearCache();
        System.gc();
        LOG.info((Object)"generation aborted by user");
    }

    public void startGeneration() throws GeneratorException {
        try {
            long startTime = System.currentTimeMillis();
            this.logHeader(this.context.getPrototype().getApiName());
            this.logParams();
            this.generate();
            this.postProcess();
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("generation took " + (endTime - startTime) + "ms\n"));
        }
        catch (GeneratorException e) {
            LOG.error((Object)"generation failed", (Throwable)e);
            throw e;
        }
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    /*
     * Unable to fully structure code
     */
    private final void generate() throws GeneratorException {
        try {
            for (ContextController controller : this.controllers) {
                generator = new ParallelGenerator(controller);
                this.generators.add(generator);
                generator.start();
            }
            for (ParallelGenerator generator : this.generators) {
                try {
                    generator.join();
                }
                catch (InterruptedException ie) {
                    throw new GeneratorException((Exception)ie, GeneratorException.ExceptionType.CONTEXT_GENERATION_FAILED);
                }
                excpt = this.threadExceptions.get(generator);
                if (excpt == null) continue;
                throw excpt;
            }
        }
        finally {
            cellFilter = new ArrayList<Class<Cell>>();
            cellFilter.add(Cell.class);
            ** for (iCanvas : this.context.getPrototype().getApiCanvases())
        }
lbl-1000:
        // 1 sources

        {
            canvas = (AbstractCanvas)iCanvas;
            for (ICellContainer cell : Utils.getDescendantsByClass((IComponent)canvas, cellFilter)) {
                ((Cell)cell).getCellEventFirer().removeEvents();
            }
            canvas.getEventFirer().removeEvents();
            continue;
        }
lbl29:
        // 1 sources

        this.clearCache();
    }

    private final void postProcess() throws GeneratorException {
        if (this.postProcessor != null) {
            this.postProcessor.execute();
        }
    }

    private final void logHeader(String projectName) {
        double length = (double)(DASHES.length() - projectName.length()) / 2.0;
        Integer prefixLength = Math.max((int)Math.ceil(length), 0);
        Integer suffixLength = Math.max((int)Math.floor(length), 0);
        StringBuilder header = new StringBuilder();
        header.append(DASHES.substring(0, prefixLength));
        header.append("-- ");
        header.append(projectName);
        header.append(" --");
        header.append(DASHES.substring(0, suffixLength));
        LOG.info((Object)header);
    }

    private final void logParams() {
        StringBuilder params = new StringBuilder();
        params.append((Object)this.getType());
        params.append(": [installPath=");
        params.append(this.context.getPaths().install);
        params.append(", outputPath=");
        params.append(this.context.getPaths().output);
        params.append(", optimize=");
        params.append(this.context.getOptimize());
        params.append("]");
        LOG.info((Object)params);
    }

    private final void clearCache() {
        this.generators.clear();
        this.threadExceptions.clear();
    }

    private final class ParallelGenerator
    extends Thread {
        private final transient ContextController controller;

        public ParallelGenerator(ContextController controller) {
            this.controller = controller;
        }

        @Override
        public void run() {
            try {
                this.controller.generate();
            }
            catch (GeneratorException e) {
                Generator.this.threadExceptions.put(this, e);
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
        }
    }
}

