/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine;

import com.justinmind.prototyper.api.scenario.IScenario;
import com.justinmind.prototyper.api.ui.canvas.ICanvas;
import com.justinmind.prototyper.api.ui.canvas.IMaster;
import com.justinmind.prototyper.api.ui.canvas.ITemplate;
import com.justinmind.util.file.FileUtils;

public abstract class Paths {
    public static final String FOLDER_RESOURCES = "resources/";
    public static final String FOLDER_APPLICATION = "_jim/";
    public static final String FOLDER_CSS = "css/";
    public static final String FOLDER_IMAGES = "images/";
    public static final String FOLDER_FONTS = "fonts/";
    public static final String FOLDER_APPICON = "appIcon/";
    public static final String FOLDER_HTML = "html/";
    public static final String FOLDER_SCREENS = "screens/";
    public static final String FOLDER_TEMPLATES = "templates/";
    public static final String FOLDER_SCENARIOS = "scenarios/";
    public static final String FOLDER_MASTERS = "masters/";
    public static final String FOLDER_JAVASCRIPT = "javascript/";
    public static final String FOLDER_COMMENTS = "comments/";
    public static final String FOLDER_ATTACHMENTS = "comments/attachments/";
    public static final String FOLDER_EXTERNAL = "external/";
    public static final String FOLDER_DOCUMENTS = "external/documents/";
    public static final String FOLDER_WEBSITES = "external/websites/";
    public static final String FOLDER_INCLUDES = "includes/";
    public static final String FOLDER_MOBILE = "mobile/";
    public static final String FOLDER_EXTENSIONS = "extensions/";
    public static final String PIE_PATH = "resources/_jim/javascript/PIE.htc";
    public static final String CHROME_EXTENSION = "justinmind_extension.crx";
    public static final String EXTERNAL_TOOL = "external_tool.js";
    public transient String output;
    public transient String project;
    public transient String install;
    public transient String resources;
    public transient String outputResources;
    public transient String base;
    public transient String cssMinFile;
    public transient String jsMinFile;
    public transient String folderHTML;
    public transient String resourcesReference;
    public transient String cssResourcesReference;

    public Paths(String projectPath, String installPath, String outputPath) {
        this.project = FileUtils.correctSeparators((String)projectPath);
        this.install = FileUtils.correctSeparators((String)installPath);
        this.output = FileUtils.correctSeparators((String)outputPath);
        this.resources = String.valueOf(this.install) + FOLDER_RESOURCES + FOLDER_APPLICATION;
        this.outputResources = String.valueOf(this.output) + FOLDER_RESOURCES + FOLDER_APPLICATION;
        this.setApplicationPaths();
    }

    public abstract void setApplicationPaths();

    public static final String getImagePath(String prefix, String path) {
        StringBuilder imgPath = new StringBuilder();
        if (path != null) {
            imgPath.append(prefix);
            imgPath.append(FOLDER_IMAGES);
            imgPath.append(path);
        }
        return imgPath.toString();
    }

    public final String getImagePath(String path) {
        return Paths.getImagePath(this.base, path);
    }

    public String getImagePathPrefix(Boolean isNoEventRule) {
        return this.base;
    }

    public static String getDataOutput(String outputBase, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(FOLDER_RESOURCES);
        output.append("simulationdata-");
        output.append(time);
        output.append(".js");
        return output.toString();
    }

    public static String getLookUpOutput(String outputBase, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(FOLDER_RESOURCES);
        output.append("lookup-");
        output.append(time);
        output.append(".js");
        return output.toString();
    }

    public static String getFontFaceOutput(String outputBase, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(FOLDER_RESOURCES);
        output.append("fonts-");
        output.append(time);
        output.append(".css");
        return output.toString();
    }

    public static final String getCanvasURL(ICanvas canvas) {
        return canvas == null ? "" : String.valueOf(Paths.getCanvasFolder(canvas)) + canvas.getApiId();
    }

    public static final String getScenarioURL(IScenario scenario) {
        return scenario == null ? "" : FOLDER_SCENARIOS + scenario.getApiId();
    }

    public static StringBuilder getCanvasOutput(String outputBase, ICanvas canvas, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(FOLDER_RESOURCES);
        output.append(Paths.getCanvasFolder(canvas));
        output.append(canvas.getApiId());
        output.append("-");
        output.append(time);
        return output;
    }

    public static StringBuilder getScenarioOutput(String outputBase, IScenario canvas, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(FOLDER_RESOURCES);
        output.append(FOLDER_SCENARIOS);
        output.append(canvas.getApiId());
        output.append("-");
        output.append(time);
        return output;
    }

    public static String getIncludeStyleOutput(String outputBase, String folderHTML, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(folderHTML);
        output.append(FOLDER_INCLUDES);
        output.append("include-");
        output.append(time);
        output.append(".css");
        return output.toString();
    }

    public static String getScaleStyleOutput(String outputBase, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(FOLDER_RESOURCES);
        output.append("scale-");
        output.append(time);
        output.append(".css");
        return output.toString();
    }

    public static String getScaleOutput(String outputBase, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(FOLDER_RESOURCES);
        output.append("scale-");
        output.append(time);
        output.append(".js");
        return output.toString();
    }

    public static String getIncludeStyleIEOutput(String outputBase, String folderHTML, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(folderHTML);
        output.append(FOLDER_INCLUDES);
        output.append("include-");
        output.append(time);
        output.append("-ie.css");
        return output.toString();
    }

    public static String getIncludeStyleIE8Output(String outputBase, String folderHTML, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(folderHTML);
        output.append(FOLDER_INCLUDES);
        output.append("include-");
        output.append(time);
        output.append("-ie8.css");
        return output.toString();
    }

    public static String getIncludeScriptOutput(String outputBase, String folderHTML, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(folderHTML);
        output.append(FOLDER_INCLUDES);
        output.append("include-");
        output.append(time);
        output.append(".js");
        return output.toString();
    }

    public static String getExternalToolsScriptOutput(String outputBase, Long time) {
        StringBuilder output = new StringBuilder(outputBase);
        output.append(FOLDER_RESOURCES);
        output.append("external_tools");
        output.append(".js");
        return output.toString();
    }

    private static final String getCanvasFolder(ICanvas canvas) {
        String folder = canvas instanceof ITemplate ? FOLDER_TEMPLATES : (canvas instanceof IMaster ? FOLDER_MASTERS : FOLDER_SCREENS);
        return folder;
    }
}

