/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine;

import com.justinmind.evc.model.actions.EVCFont;
import com.justinmind.evc.model.actions.SVGImage;
import com.justinmind.evc.model.files.EVCDirectory;
import com.justinmind.evc.model.files.EVCFileHandler;
import com.justinmind.evc.model.projects.EVCProjectModel;
import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.Paths;
import com.justinmind.prototyper.api.IPrototype;
import com.justinmind.prototyper.api.scenario.IScenario;
import com.justinmind.prototyper.api.ui.simulation.SimulationDevice;
import com.justinmind.prototyper.api.ui.simulation.SimulationiOSVersion;
import com.justinmind.util.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PostProcess {
    private final transient Boolean optimize;
    protected final transient IPrototype prototype;
    protected final transient Paths paths;
    protected final transient Boolean mobile;

    public PostProcess(IPrototype prototype, Boolean optimize, Paths paths) {
        this.prototype = prototype;
        this.optimize = optimize;
        this.paths = paths;
        this.mobile = !prototype.getApiSimulationSettings().getApiSimulationDevice().equals((Object)SimulationDevice.WEB);
    }

    public void execute() throws GeneratorException {
        try {
            this.processApplicationIncludes();
            this.copyResources();
        }
        catch (IOException e) {
            throw new GeneratorException((Exception)e, Arrays.asList(GeneratorException.ExceptionType.ACCESS_DENIED, GeneratorException.ExceptionType.NO_FILE_FOUND));
        }
    }

    protected void processApplicationIncludes() throws IOException {
        block32: {
            block31: {
                if (!this.optimize.booleanValue()) break block31;
                FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + this.paths.cssMinFile), (String)(String.valueOf(this.paths.outputResources) + "css/" + this.paths.cssMinFile));
                FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "css/" + "fonts/"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "fonts/"), new ArrayList(), (Boolean)false, (Boolean)true);
                FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "function-jim-common-ios.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "function-jim-common-ios.css"));
                FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "jim-ie.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "jim-ie.css"));
                FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "javascript/" + this.paths.jsMinFile), (String)(String.valueOf(this.paths.outputResources) + "javascript/" + this.paths.jsMinFile));
                FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "javascript/" + "PIE.htc"), (String)(String.valueOf(this.paths.outputResources) + "javascript/" + "PIE.htc"));
                FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "javascript/" + "PIE_IE678.js"), (String)(String.valueOf(this.paths.outputResources) + "javascript/" + "PIE_IE678.js"));
                FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "javascript/" + "PIE_IE9.js"), (String)(String.valueOf(this.paths.outputResources) + "javascript/" + "PIE_IE9.js"));
                if (!this.mobile.booleanValue()) {
                    ArrayList<String> excludedFiles = new ArrayList<String>();
                    excludedFiles.add("cursor2.png");
                    excludedFiles.add("touch.cur");
                    excludedFiles.add("blank.cur");
                    FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "css/" + "images/"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "images/"), excludedFiles, (Boolean)false, (Boolean)true);
                } else {
                    FileUtils.copyToDirectory((Object)(String.valueOf(this.paths.resources) + "css/" + "images/"), (String)(String.valueOf(this.paths.outputResources) + "css/"));
                }
                switch (PostProcess.$SWITCH_TABLE$com$justinmind$prototyper$api$ui$simulation$SimulationDevice()[this.prototype.getApiSimulationSettings().getApiSimulationDevice().ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 7: {
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "android/phone/" + "function-jim-android-phone.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "android/phone/" + "function-jim-android-phone.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "jim-mobile-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "jim-mobile-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "function-jim-mobile-ie.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "function-jim-mobile-ie.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "javascript/" + "mobile/" + "custom/jim-custom-min.js"), (String)(String.valueOf(this.paths.outputResources) + "javascript/" + "mobile/" + "custom/jim-custom-min.js"));
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "custom/" + "function-jim-custom.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "custom/" + "function-jim-custom.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "jim-mobile-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "jim-mobile-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "function-jim-mobile-ie.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "function-jim-mobile-ie.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "javascript/" + "mobile/" + "custom/jim-custom-min.js"), (String)(String.valueOf(this.paths.outputResources) + "javascript/" + "mobile/" + "custom/jim-custom-min.js"));
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        String iosVersion = "ios" + this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion().toNumber() + "/";
                        String iPhoneDevice = this.prototype.getApiSimulationSettings().getApiSimulationDevice().getName().toLowerCase();
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "jim-mobile-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "jim-mobile-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "function-jim-mobile-ie.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "function-jim-mobile-ie.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "function-jim-mobile-ie8.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "function-jim-mobile-ie8.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + "jim-ios-common-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + "jim-ios-common-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + "jim-ios-common-ie8-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + "jim-ios-common-ie8-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/jim-" + iPhoneDevice + "-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/jim-" + iPhoneDevice + "-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/function-jim-" + iPhoneDevice + "-ie.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/function-jim-" + iPhoneDevice + "-ie.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/jim-" + iPhoneDevice + "-ie8-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + iosVersion + iPhoneDevice + "/jim-" + iPhoneDevice + "-ie8-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "javascript/" + "mobile/" + "ios/" + iosVersion + "iphone/jim-iphone-min.js"), (String)(String.valueOf(this.paths.outputResources) + "javascript/" + "mobile/" + "ios/" + iosVersion + "iphone/jim-iphone-min.js"));
                        if (this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion() != null && (this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion().equals((Object)SimulationiOSVersion.SEVEN) || this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion().equals((Object)SimulationiOSVersion.EIGHT))) {
                            FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + iosVersion + "/other"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + iosVersion + "/other"), new ArrayList(), (Boolean)false, (Boolean)true);
                            break;
                        }
                        break block32;
                    }
                    case 6: {
                        String iosVersion = "ios" + this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion().toNumber() + "/";
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "jim-mobile-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "jim-mobile-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "function-jim-mobile-ie.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "function-jim-mobile-ie.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "function-jim-mobile-ie8.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "function-jim-mobile-ie8.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + "jim-ios-common-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + "jim-ios-common-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + "jim-ios-common-ie8-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + "jim-ios-common-ie8-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + iosVersion + "ipad/function-jim-ipad-ie.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + iosVersion + "ipad/function-jim-ipad-ie.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-ie8-min.css"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-ie8-min.css"));
                        FileUtils.copyFileTo((String)(String.valueOf(this.paths.resources) + "javascript/" + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-min.js"), (String)(String.valueOf(this.paths.outputResources) + "javascript/" + "mobile/" + "ios/" + iosVersion + "ipad/jim-ipad-min.js"));
                        if (this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion() == null || !this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion().equals((Object)SimulationiOSVersion.SEVEN)) break block32;
                        FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "css/" + "mobile/" + "ios/" + iosVersion + "other"), (String)(String.valueOf(this.paths.outputResources) + "css/" + "mobile/" + "ios/" + iosVersion + "/other"), new ArrayList(), (Boolean)false, (Boolean)true);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block32;
            }
            if (!this.mobile.booleanValue()) {
                ArrayList<String> excludedFiles = new ArrayList<String>();
                excludedFiles.add("mobile");
                excludedFiles.addAll(this.getMinimizatedCssFiles());
                excludedFiles.addAll(this.getMinimizatedJsFiles());
                FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "css/"), (String)(String.valueOf(this.paths.outputResources) + "css/"), excludedFiles, (Boolean)false, (Boolean)true);
                FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "javascript/"), (String)(String.valueOf(this.paths.outputResources) + "javascript/"), excludedFiles, (Boolean)false, (Boolean)true);
            } else {
                ArrayList<String> excludedCss = new ArrayList<String>();
                ArrayList<String> excludedJs = new ArrayList<String>();
                excludedCss.addAll(this.getMinimizatedCssFiles());
                excludedJs.addAll(this.getMinimizatedJsFiles());
                if (this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion() != null) {
                    switch (this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion()) {
                        case SIX: {
                            excludedCss.add("ios7");
                            excludedJs.add("ios7");
                            excludedCss.add("ios8");
                            excludedJs.add("ios8");
                            break;
                        }
                        case SEVEN: {
                            excludedCss.add("ios6");
                            excludedJs.add("ios6");
                            excludedCss.add("ios8");
                            excludedJs.add("ios8");
                            break;
                        }
                        case EIGHT: {
                            excludedCss.add("ios6");
                            excludedJs.add("ios6");
                            excludedCss.add("ios7");
                            excludedJs.add("ios7");
                        }
                    }
                }
                switch (this.prototype.getApiSimulationSettings().getApiSimulationDevice()) {
                    case WEB: {
                        break;
                    }
                    case IPHONE6PLUS: {
                        excludedCss.add("android");
                        excludedCss.add("custom");
                        excludedCss.add("iphone4");
                        excludedCss.add("iphone5");
                        excludedCss.add("iphone6");
                        excludedCss.add("ipad");
                        excludedJs.add("custom");
                        excludedJs.add("ipad");
                        break;
                    }
                    case IPHONE6: {
                        excludedCss.add("android");
                        excludedCss.add("custom");
                        excludedCss.add("iphone4");
                        excludedCss.add("iphone5");
                        excludedCss.add("iphone6plus");
                        excludedCss.add("ipad");
                        excludedJs.add("custom");
                        excludedJs.add("ipad");
                        break;
                    }
                    case IPHONE5: {
                        excludedCss.add("android");
                        excludedCss.add("custom");
                        excludedCss.add("iphone4");
                        excludedCss.add("iphone6plus");
                        excludedCss.add("iphone6");
                        excludedCss.add("ipad");
                        excludedJs.add("custom");
                        excludedJs.add("ipad");
                        break;
                    }
                    case IPHONE4: {
                        excludedCss.add("android");
                        excludedCss.add("custom");
                        excludedCss.add("iphone5");
                        excludedCss.add("iphone6plus");
                        excludedCss.add("iphone6");
                        excludedCss.add("ipad");
                        excludedJs.add("custom");
                        excludedJs.add("ipad");
                        break;
                    }
                    case IPAD: {
                        excludedCss.add("android");
                        excludedCss.add("custom");
                        excludedCss.add("iphone4");
                        excludedCss.add("iphone5");
                        excludedCss.add("iphone6plus");
                        excludedCss.add("iphone6");
                        excludedJs.add("custom");
                        excludedJs.add("iphone");
                        break;
                    }
                    case ANDROID_PHONE: {
                        excludedCss.add("custom");
                        excludedCss.add("ios");
                        excludedJs.add("ios");
                        break;
                    }
                    case ANDROID_TABLET: 
                    case GOOGLE_GLASS: 
                    case MOBILECUSTOM: {
                        excludedCss.add("android");
                        excludedCss.add("ios");
                        excludedJs.add("ios");
                    }
                }
                FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "css/"), (String)(String.valueOf(this.paths.outputResources) + "css/"), excludedCss, (Boolean)false, (Boolean)true);
                FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "javascript/"), (String)(String.valueOf(this.paths.outputResources) + "javascript/"), excludedJs, (Boolean)false, (Boolean)true);
            }
        }
    }

    private Collection<String> getMinimizatedCssFiles() {
        ArrayList<String> excludedFiles = new ArrayList<String>();
        excludedFiles.add("jim-ipad-min.css");
        excludedFiles.add("jim-ipad-ie8-min.css");
        excludedFiles.add("jim-iphone4-min.css");
        excludedFiles.add("jim-iphone4-ie8-min.css");
        excludedFiles.add("jim-iphone5-min.css");
        excludedFiles.add("jim-iphone5-ie8-min.css");
        excludedFiles.add("jim-iphone6-min.css");
        excludedFiles.add("jim-iphone6-ie8-min.css");
        excludedFiles.add("jim-iphone6plus-min.css");
        excludedFiles.add("jim-iphone6plus-ie8-min.css");
        excludedFiles.add("jim-ios-common-min.css");
        excludedFiles.add("jim-ios-common-ie8-min.css");
        excludedFiles.add("jim-mobile-min.css");
        excludedFiles.add("jim-min.css");
        return excludedFiles;
    }

    private Collection<String> getMinimizatedJsFiles() {
        ArrayList<String> excludedFiles = new ArrayList<String>();
        excludedFiles.add("jim-custom-min.js");
        excludedFiles.add("jim-ipad-min.js");
        excludedFiles.add("jim-iphone-min.js");
        excludedFiles.add("jim-min.js");
        return excludedFiles;
    }

    protected void copyResources() throws IOException {
        File icon;
        FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "html/"), (String)(String.valueOf(this.paths.outputResources) + "html/"), (Boolean)false, (Boolean)true);
        FileUtils.copyFileTo((String)(String.valueOf(this.paths.install) + "resources/" + "extensions/" + "justinmind_extension.crx"), (String)(String.valueOf(this.paths.output) + "resources/" + "extensions/" + "justinmind_extension.crx"));
        ArrayList<String> excludedFiles = new ArrayList<String>();
        if (this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion() != null) {
            switch (this.prototype.getApiSimulationSettings().getApiSimulationiOSVersion()) {
                case SIX: {
                    excludedFiles.add("ios7");
                    excludedFiles.add("ios8");
                    break;
                }
                case SEVEN: {
                    excludedFiles.add("ios6");
                    excludedFiles.add("ios8");
                    break;
                }
                case EIGHT: {
                    excludedFiles.add("ios6");
                    excludedFiles.add("ios7");
                }
            }
        }
        switch (this.prototype.getApiSimulationSettings().getApiSimulationDevice()) {
            case WEB: {
                excludedFiles.add("mobile");
                break;
            }
            case IPHONE6PLUS: {
                excludedFiles.add("android");
                excludedFiles.add("custom");
                excludedFiles.add("iphone4");
                excludedFiles.add("iphone5");
                excludedFiles.add("iphone6");
                excludedFiles.add("ipad");
                break;
            }
            case IPHONE6: {
                excludedFiles.add("android");
                excludedFiles.add("custom");
                excludedFiles.add("iphone4");
                excludedFiles.add("iphone5");
                excludedFiles.add("iphone6plus");
                excludedFiles.add("ipad");
                break;
            }
            case IPHONE5: {
                excludedFiles.add("android");
                excludedFiles.add("custom");
                excludedFiles.add("iphone4");
                excludedFiles.add("iphone6");
                excludedFiles.add("iphone6plus");
                excludedFiles.add("ipad");
                break;
            }
            case IPHONE4: {
                excludedFiles.add("android");
                excludedFiles.add("custom");
                excludedFiles.add("iphone5");
                excludedFiles.add("iphone6");
                excludedFiles.add("iphone6plus");
                excludedFiles.add("ipad");
                break;
            }
            case IPAD: {
                excludedFiles.add("android");
                excludedFiles.add("custom");
                excludedFiles.add("iphone4");
                excludedFiles.add("iphone5");
                excludedFiles.add("iphone6");
                excludedFiles.add("iphone6plus");
                break;
            }
            case ANDROID_TABLET: 
            case GOOGLE_GLASS: 
            case MOBILECUSTOM: {
                excludedFiles.add("android");
                excludedFiles.add("ios");
                break;
            }
            case ANDROID_PHONE: {
                excludedFiles.add("custom");
                excludedFiles.add("ios");
                break;
            }
        }
        FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "images/"), (String)(String.valueOf(this.paths.outputResources) + "images/"), excludedFiles, (Boolean)false, (Boolean)true);
        FileUtils.copyDirectoryTo((String)(String.valueOf(this.paths.resources) + "fonts/"), (String)(String.valueOf(this.paths.outputResources) + "fonts/"), excludedFiles, (Boolean)false, (Boolean)true);
        for (EVCFileHandler<?> file : this.getResources()) {
            if (file instanceof EVCDirectory) {
                FileUtils.copyDirectoryTo((String)file.getPath(), (String)(String.valueOf(this.paths.output) + file.getFolder() + "/" + file.getSystemFileName()));
                continue;
            }
            if (file instanceof EVCFont) {
                for (String s : ((EVCFont)file).getPaths()) {
                    String ext = s.substring(s.lastIndexOf("."));
                    FileUtils.copyFileTo((String)s, (String)(String.valueOf(this.paths.output) + file.getFolder() + "/" + file.getSystemFileName() + ext));
                }
                continue;
            }
            if (file instanceof SVGImage) {
                File svgFile = new File(((SVGImage)file).getSVGPath());
                if (svgFile.exists()) {
                    FileUtils.copyFileTo((String)((SVGImage)file).getSVGPath(), (String)(String.valueOf(this.paths.output) + file.getFolder() + "/" + ((SVGImage)file).getSVGSystemFileName()));
                    continue;
                }
                FileUtils.copyFileTo((String)file.getPath(), (String)(String.valueOf(this.paths.output) + file.getFolder() + "/" + file.getSystemFileName()));
                continue;
            }
            FileUtils.copyFileTo((String)file.getPath(), (String)(String.valueOf(this.paths.output) + file.getFolder() + "/" + file.getSystemFileName()));
        }
        if (this.prototype.getApiSimulationSettings().getApiAppIcon() != null && !this.prototype.getApiSimulationSettings().getApiAppIcon().equals("") && (icon = new File(String.valueOf(this.paths.project) + this.prototype.getApiSimulationSettings().getApiAppIcon())).exists()) {
            FileUtils.copyFileTo((String)icon.getAbsolutePath(), (String)(String.valueOf(this.paths.output) + "appIcon/" + this.prototype.getApiSimulationSettings().getApiAppIconName()));
        }
        for (IScenario scenario : this.prototype.getApiScenarios()) {
            File svg = new File(String.valueOf(this.prototype.getApiPath()) + File.separator + "scenarios" + File.separator + scenario.getApiId() + ".png");
            FileUtils.copyFileTo((File)svg, (String)(String.valueOf(this.paths.output) + "resources/" + "scenarios/" + scenario.getApiId() + ".png"));
        }
    }

    protected List<EVCFileHandler<?>> getResources() {
        return ((EVCProjectModel)this.prototype).getResources(Arrays.asList(EVCProjectModel.ResourceFilter.UI));
    }
}

