/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine.attributerenderer;

import com.justinmind.generator.engine.Generator;
import com.justinmind.util.datamanage.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.IllegalFormatException;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import org.stringtemplate.v4.AttributeRenderer;

public final class StringRenderer
implements AttributeRenderer {
    public String toString(Object obj, String formatString, Locale locale) {
        StringBuilder result = new StringBuilder();
        String string = (String)obj;
        if (string != null) {
            if (formatString == null) {
                result.append(string);
            } else {
                switch (Format.getType(formatString)) {
                    case UPPER: {
                        result.append(string.toUpperCase(locale));
                        break;
                    }
                    case LOWER: {
                        result.append(string.toLowerCase(locale));
                        break;
                    }
                    case CAP: {
                        result.append(Character.toUpperCase(string.charAt(0)));
                        result.append(string.substring(1));
                        break;
                    }
                    case HTML: {
                        result.append(StringRenderer.escapeHTML(string));
                        break;
                    }
                    case XML: {
                        result.append(StringEscapeUtils.escapeXml((String)string));
                        break;
                    }
                    case JSON: {
                        result.append(StringRenderer.escapeJSON(string));
                        break;
                    }
                    case JAVASCRIPT: {
                        result.append("\"");
                        result.append(StringEscapeUtils.escapeEcmaScript((String)string));
                        result.append("\"");
                        break;
                    }
                    case QUOTE: {
                        result.append(string.replaceAll("\"", "\\\""));
                        break;
                    }
                    case URL: {
                        try {
                            result.append(URLEncoder.encode(string, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            Generator.LOG.error((Object)e);
                            result.append(string);
                        }
                        break;
                    }
                    case URLFRAGMENT: {
                        result.append(StringRenderer.escapeURLFragment(string));
                        break;
                    }
                    case NONE: {
                        try {
                            result.append(String.format(formatString, string));
                        }
                        catch (IllegalFormatException e) {
                            Generator.LOG.error((Object)e);
                            result.append(string);
                        }
                        break;
                    }
                }
            }
        }
        return result.toString();
    }

    public static String escapeHTML(String string) {
        String html = "";
        if (string != null && string.length() > 0) {
            html = StringEscapeUtils.escapeHtml4((String)string);
            html = StringUtils.replace((String)html, (String)"  ", (String)" &nbsp;");
            html = StringUtils.replace((String)html, (String)"\t", (String)" &nbsp; &nbsp; &nbsp;");
            html = StringUtils.replace((String)html, (String)"\n", (String)"<br />");
        }
        return html;
    }

    public static String escapeJSON(String string) {
        StringBuilder json = new StringBuilder();
        if (string == null || string.length() == 0) {
            json.append("\"\"");
        } else {
            char character = '\u0000';
            json.append('\"');
            Integer len = string.length();
            int i = 0;
            while (i < len) {
                char backup = character;
                character = string.charAt(i);
                switch (character) {
                    case '\"': 
                    case '\\': {
                        json.append('\\');
                        json.append(character);
                        break;
                    }
                    case '/': {
                        if (backup == '<') {
                            json.append('\\');
                        }
                        json.append(character);
                        break;
                    }
                    case '\b': {
                        json.append("\\b");
                        break;
                    }
                    case '\t': {
                        json.append("\\t");
                        break;
                    }
                    case '\n': {
                        json.append("\\n");
                        break;
                    }
                    case '\f': {
                        json.append("\\f");
                        break;
                    }
                    case '\r': {
                        json.append("\\r");
                        break;
                    }
                    default: {
                        if (character < ' ' || character >= '\u0080' && character < '\u00a0' || character >= '\u2000' && character < '\u2100') {
                            String hhhh = "000" + Integer.toHexString(character);
                            json.append("\\u" + hhhh.substring(hhhh.length() - 4));
                            break;
                        }
                        json.append(character);
                    }
                }
                ++i;
            }
            json.append('\"');
        }
        return json.toString();
    }

    public static String escapeURLFragment(String string) {
        StringBuilder fragment = new StringBuilder();
        if (string == null || string.length() == 0) {
            fragment.append("");
        } else {
            Integer len = string.length();
            int i = 0;
            while (i < len) {
                char character = string.charAt(i);
                switch (character) {
                    case '%': {
                        fragment.append("%25");
                        break;
                    }
                    case '#': {
                        fragment.append("%23");
                        break;
                    }
                    case '?': {
                        fragment.append("%3F");
                        break;
                    }
                    case ' ': {
                        fragment.append("%20");
                        break;
                    }
                    default: {
                        fragment.append(character);
                    }
                }
                ++i;
            }
        }
        return fragment.toString();
    }

    private static enum Format {
        UPPER,
        LOWER,
        CAP,
        HTML,
        XML,
        JSON,
        JAVASCRIPT,
        URL,
        URLFRAGMENT,
        QUOTE,
        NONE;


        public static Format getType(String value) {
            Format format;
            try {
                format = Format.valueOf(value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                format = NONE;
            }
            return format;
        }
    }
}

