/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine.modeladaptor;

import com.justinmind.generator.context.ControllerUtils;
import com.justinmind.generator.engine.Paths;
import com.justinmind.generator.engine.modeladaptor.TypeAdaptor;
import com.justinmind.prototyper.api.comment.IComment;
import com.justinmind.prototyper.api.comment.IRootComment;
import com.justinmind.prototyper.api.ui.component.IComponent;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.siteXmlDef.Igu.model.comments.Comment;
import com.justinmind.util.prettydate.PrettyDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

public final class CommentAdaptor
implements ModelAdaptor {
    private static final List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("apiAuthor", "code", "authorID", "parentCode", "apiContent", "apiDate", "prettyDate", "apiAttachment", "read", "apiReplies", "canvasID", "elementID", "canvasURL", "scenarioID"));
    private final transient TimeZone timezone;
    private final transient Locale locale;

    public CommentAdaptor(TimeZone timezone, Locale locale) {
        this.timezone = timezone;
        this.locale = locale;
    }

    public String getProperty(IRootComment comment, String propertyName) {
        String property = "";
        Object result = this.getProperty(null, null, comment, null, propertyName);
        if (result instanceof String) {
            property = (String)result;
        }
        return property;
    }

    public Object getProperty(Interpreter interp, ST self, Object model, Object property, String propertyName) throws STNoSuchPropertyException {
        Object result = null;
        if (PROPERTIES.contains(propertyName)) {
            IComment comment = (IComment)model;
            if ("apiAuthor".equals(propertyName)) {
                result = comment.getApiAuthor();
            } else if ("authorID".equals(propertyName)) {
                result = ((Comment)comment).getAuthorID();
            } else if ("code".equals(propertyName)) {
                result = ((Comment)comment).getCode();
            } else if ("parentCode".equals(propertyName)) {
                result = ((Comment)comment).getParentCode();
                if (result == null) {
                    result = "null";
                }
            } else if ("apiContent".equals(propertyName)) {
                result = comment.getApiContent();
            } else if ("apiDate".equals(propertyName)) {
                result = ((Comment)comment).getDate().getTime();
            } else if ("prettyDate".equals(propertyName)) {
                result = new PrettyDate(comment.getApiDate(), this.locale, this.timezone).getLocalDateFormat();
            } else if ("apiAttachment".equals(propertyName)) {
                result = comment.getApiAttachment();
                if (result == null) {
                    result = "";
                }
            } else if ("read".equals(propertyName)) {
                result = ((Comment)comment).isRead();
            } else if ("apiReplies".equals(propertyName)) {
                result = comment.getApiReplies();
            } else if (comment instanceof IRootComment) {
                IComponent component = ((IRootComment)comment).getApiRelatedComponent();
                if (component != null) {
                    if ("canvasID".equals(propertyName)) {
                        result = ControllerUtils.getID((IComponent)component.getApiCanvas().getApiRoot());
                    } else if ("elementID".equals(propertyName)) {
                        result = ControllerUtils.getID(component);
                        if (TypeAdaptor.getComponentType((ITarget)component.getApiCanvas()).equals((Object)TypeAdaptor.ComponentType.MASTER) && !TypeAdaptor.getComponentType((ITarget)component).equals((Object)TypeAdaptor.ComponentType.ROOTCOMPONENT)) {
                            result = "m-".concat(((String)result).substring(11));
                        }
                    } else if ("canvasURL".equals(propertyName)) {
                        result = Paths.getCanvasURL(component.getApiCanvas());
                    }
                }
                if ("scenarioID".equals(propertyName) && (result = ((IRootComment)comment).getApiScenario()) == null) {
                    result = "";
                }
            }
        } else {
            throw new STNoSuchPropertyException(null, model, propertyName);
        }
        return result;
    }
}

