/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine.modeladaptor;

import com.justinmind.evc.model.businessLogic.FBOData;
import com.justinmind.prototyper.api.scenario.IScenarioNode;
import com.justinmind.prototyper.api.ui.canvas.IMaster;
import com.justinmind.prototyper.api.ui.canvas.IScreen;
import com.justinmind.prototyper.api.ui.canvas.ITemplate;
import com.justinmind.prototyper.api.ui.component.IButton;
import com.justinmind.prototyper.api.ui.component.ICallout;
import com.justinmind.prototyper.api.ui.component.ICellContainer;
import com.justinmind.prototyper.api.ui.component.IDataCell;
import com.justinmind.prototyper.api.ui.component.IDataGrid;
import com.justinmind.prototyper.api.ui.component.IDataGridCell;
import com.justinmind.prototyper.api.ui.component.IDataList;
import com.justinmind.prototyper.api.ui.component.IDataRow;
import com.justinmind.prototyper.api.ui.component.IDocument;
import com.justinmind.prototyper.api.ui.component.IDynamicPanel;
import com.justinmind.prototyper.api.ui.component.IEllipse;
import com.justinmind.prototyper.api.ui.component.IFlash;
import com.justinmind.prototyper.api.ui.component.IGroupContainer;
import com.justinmind.prototyper.api.ui.component.IHtml;
import com.justinmind.prototyper.api.ui.component.IImage;
import com.justinmind.prototyper.api.ui.component.IImageMap;
import com.justinmind.prototyper.api.ui.component.IIndex;
import com.justinmind.prototyper.api.ui.component.IInput;
import com.justinmind.prototyper.api.ui.component.ILabel;
import com.justinmind.prototyper.api.ui.component.ILine;
import com.justinmind.prototyper.api.ui.component.IMasterInstance;
import com.justinmind.prototyper.api.ui.component.IMenu;
import com.justinmind.prototyper.api.ui.component.IMenuNode;
import com.justinmind.prototyper.api.ui.component.IPanel;
import com.justinmind.prototyper.api.ui.component.IRectangle;
import com.justinmind.prototyper.api.ui.component.IRichText;
import com.justinmind.prototyper.api.ui.component.IRootComponent;
import com.justinmind.prototyper.api.ui.component.ISelect;
import com.justinmind.prototyper.api.ui.component.ISummary;
import com.justinmind.prototyper.api.ui.component.ITable;
import com.justinmind.prototyper.api.ui.component.ITableRow;
import com.justinmind.prototyper.api.ui.component.ITextCell;
import com.justinmind.prototyper.api.ui.component.ITextRange;
import com.justinmind.prototyper.api.ui.component.ITree;
import com.justinmind.prototyper.api.ui.component.ITreeNode;
import com.justinmind.prototyper.api.ui.component.ITriangle;
import com.justinmind.prototyper.api.ui.component.IUrl;
import com.justinmind.prototyper.api.ui.component.IWebsite;
import com.justinmind.prototyper.api.ui.data.ICategory;
import com.justinmind.prototyper.api.ui.data.IDataMaster;
import com.justinmind.prototyper.api.ui.data.IField;
import com.justinmind.prototyper.api.ui.data.IVariable;
import com.justinmind.prototyper.api.ui.event.ITarget;
import com.justinmind.prototyper.api.ui.event.action.IAction;
import com.justinmind.prototyper.api.ui.event.action.IBackwardNavigation;
import com.justinmind.prototyper.api.ui.event.action.IChangeStyle;
import com.justinmind.prototyper.api.ui.event.action.IDisplay;
import com.justinmind.prototyper.api.ui.event.action.IEnableInput;
import com.justinmind.prototyper.api.ui.event.action.IExternalNavigation;
import com.justinmind.prototyper.api.ui.event.action.IInsertInto;
import com.justinmind.prototyper.api.ui.event.action.IInternalNavigation;
import com.justinmind.prototyper.api.ui.event.action.IMove;
import com.justinmind.prototyper.api.ui.event.action.IPagination;
import com.justinmind.prototyper.api.ui.event.action.IPause;
import com.justinmind.prototyper.api.ui.event.action.IRecordAction;
import com.justinmind.prototyper.api.ui.event.action.IResize;
import com.justinmind.prototyper.api.ui.event.action.IRotate;
import com.justinmind.prototyper.api.ui.event.action.IScrollTo;
import com.justinmind.prototyper.api.ui.event.action.ISetActivePanel;
import com.justinmind.prototyper.api.ui.event.action.ISetFocus;
import com.justinmind.prototyper.api.ui.event.action.ISetSelection;
import com.justinmind.prototyper.api.ui.event.action.ISetValue;

public final class TypeAdaptor {
    private TypeAdaptor() {
    }

    public static ScenarioComponentType getScenarioComponentType(IScenarioNode target) {
        String type = target.getApiNodeType();
        if (type.equals("Page")) {
            return ScenarioComponentType.PAGE;
        }
        if (type.equals("Decision")) {
            return ScenarioComponentType.DECISION;
        }
        if (type.equals("Action")) {
            return ScenarioComponentType.ACTION;
        }
        if (type.equals("Note")) {
            return ScenarioComponentType.NOTE;
        }
        return ScenarioComponentType.NONE;
    }

    public static ComponentType getComponentType(ITarget target) {
        if (target instanceof IScreen) {
            return ComponentType.SCREEN;
        }
        if (target instanceof ITemplate) {
            return ComponentType.TEMPLATE;
        }
        if (target instanceof IMaster) {
            return ComponentType.MASTER;
        }
        if (target instanceof IMasterInstance) {
            return ComponentType.MASTERINSTANCE;
        }
        if (target instanceof IRootComponent) {
            return ComponentType.ROOTCOMPONENT;
        }
        if (target instanceof IGroupContainer) {
            return ComponentType.GROUP;
        }
        if (target instanceof IDynamicPanel) {
            return ComponentType.DYNAMICPANEL;
        }
        if (target instanceof IPanel) {
            return ComponentType.PANEL;
        }
        if (target instanceof ITable) {
            return target instanceof IDataList ? ComponentType.DATALIST : ComponentType.TABLE;
        }
        if (target instanceof ITableRow) {
            return target instanceof IDataRow ? ComponentType.DATAROW : ComponentType.ROW;
        }
        if (target instanceof ICellContainer) {
            return target instanceof IDataCell ? ComponentType.DATACELL : ComponentType.CELLCONTAINER;
        }
        if (target instanceof ITextCell) {
            return ComponentType.TEXTCELL;
        }
        if (target instanceof IDataGrid) {
            return ComponentType.DATAGRID;
        }
        if (target instanceof IDataGridCell) {
            return ComponentType.GRIDCELL;
        }
        if (target instanceof IIndex) {
            return ComponentType.INDEX;
        }
        if (target instanceof ISummary) {
            return ComponentType.SUMMARY;
        }
        if (target instanceof IEllipse) {
            return ComponentType.ELLIPSE;
        }
        if (target instanceof ITriangle) {
            return ComponentType.TRIANGLE;
        }
        if (target instanceof ICallout) {
            return ComponentType.CALLOUT;
        }
        if (target instanceof ILine) {
            return ComponentType.LINE;
        }
        if (target instanceof IRectangle) {
            return ComponentType.RECTANGLE;
        }
        if (target instanceof ILabel) {
            return ComponentType.LABEL;
        }
        if (target instanceof IButton) {
            return ComponentType.BUTTON;
        }
        if (target instanceof IRichText) {
            return ComponentType.RICHTEXT;
        }
        if (target instanceof ITextRange) {
            return ComponentType.TEXTRANGE;
        }
        if (target instanceof IFlash) {
            return ComponentType.FLASH;
        }
        if (target instanceof IWebsite) {
            return ComponentType.WEBSITE;
        }
        if (target instanceof IUrl) {
            return ComponentType.URL;
        }
        if (target instanceof IHtml) {
            return ComponentType.HTML;
        }
        if (target instanceof IDocument) {
            return ComponentType.DOCUMENT;
        }
        if (target instanceof IImage) {
            return ComponentType.IMAGE;
        }
        if (target instanceof ISelect) {
            switch (((ISelect)target).getApiSelectType()) {
                case CHECKBOXLIST: {
                    return ComponentType.CHECKBOXLIST;
                }
                case DROPDOWN: {
                    return ComponentType.DROPDOWN;
                }
                case NATIVEDROPDOWN: {
                    return ComponentType.NATIVEDROPDOWN;
                }
                case MULTISELECTIONLIST: {
                    return ComponentType.MULTISELECTIONLIST;
                }
                case RADIOBUTTONLIST: {
                    return ComponentType.RADIOBUTTONLIST;
                }
                case SELECTIONLIST: {
                    return ComponentType.SELECTIONLIST;
                }
            }
            return ComponentType.SELECT;
        }
        if (target instanceof IInput) {
            switch (((IInput)target).getApiInputType()) {
                case CHECKBOX: {
                    return ComponentType.CHECKBOX;
                }
                case DATE: {
                    return ComponentType.DATE;
                }
                case FILE: {
                    return ComponentType.FILE;
                }
                case PASSWORD: {
                    return ComponentType.PASSWORD;
                }
                case NUMBER: {
                    return ComponentType.NUMBER;
                }
                case EMAIL: {
                    return ComponentType.EMAIL;
                }
                case URL: {
                    return ComponentType.INPUTURL;
                }
                case RADIOBUTTON: {
                    return ComponentType.RADIOBUTTON;
                }
                case TEXT: {
                    return ComponentType.TEXT;
                }
                case TEXTAREA: {
                    return ComponentType.TEXTAREA;
                }
                case TIME: {
                    return ComponentType.TIME;
                }
                case DATETIME: {
                    return ComponentType.DATETIME;
                }
            }
            return ComponentType.INPUT;
        }
        if (target instanceof IMenu) {
            return ComponentType.MENU;
        }
        if (target instanceof IMenuNode) {
            return ComponentType.MENUNODE;
        }
        if (target instanceof ITree) {
            return ComponentType.TREE;
        }
        if (target instanceof ITreeNode) {
            return ComponentType.TREENODE;
        }
        if (target instanceof IImageMap) {
            return ComponentType.IMAGEMAP;
        }
        if (target instanceof IVariable) {
            return ComponentType.VARIABLE;
        }
        if (target instanceof IDataMaster) {
            return ComponentType.DATAMASTER;
        }
        if (target instanceof IField) {
            return ComponentType.FIELD;
        }
        if (target instanceof ICategory) {
            return ComponentType.CATEGORY;
        }
        return ComponentType.NONE;
    }

    public static ActionType getActionType(IAction action) {
        if (action instanceof IRecordAction || action instanceof IPagination) {
            return ((IRecordAction)action).getApiFunction() instanceof FBOData ? ActionType.RECORDACTION : ActionType.PAGINATION;
        }
        if (action instanceof IInternalNavigation) {
            return ActionType.INTERNALNAVIGATION;
        }
        if (action instanceof IExternalNavigation) {
            return ActionType.EXTERNALNAVIGATION;
        }
        if (action instanceof IBackwardNavigation) {
            return ActionType.BACKWARDNAVIGATION;
        }
        if (action instanceof IPause) {
            return ActionType.PAUSE;
        }
        if (action instanceof IDisplay) {
            return ActionType.DISPLAY;
        }
        if (action instanceof ISetActivePanel) {
            return ActionType.SETACTIVEPANEL;
        }
        if (action instanceof IMove) {
            return ActionType.MOVE;
        }
        if (action instanceof IInsertInto) {
            return ActionType.INSERTINTO;
        }
        if (action instanceof IChangeStyle) {
            return ActionType.CHANGESTYLE;
        }
        if (action instanceof ISetSelection) {
            return ActionType.SETSELECTION;
        }
        if (action instanceof ISetValue) {
            return ActionType.SETVALUE;
        }
        if (action instanceof ISetFocus) {
            return ActionType.SETFOCUS;
        }
        if (action instanceof IScrollTo) {
            return ActionType.SCROLLTO;
        }
        if (action instanceof IEnableInput) {
            return ActionType.ENABLEINPUT;
        }
        if (action instanceof IResize) {
            return ActionType.RESIZE;
        }
        if (action instanceof IRotate) {
            return ActionType.ROTATE;
        }
        return ActionType.NONE;
    }

    public static enum ActionType {
        RECORDACTION,
        PAGINATION,
        INTERNALNAVIGATION,
        EXTERNALNAVIGATION,
        BACKWARDNAVIGATION,
        PAUSE,
        DISPLAY,
        SETACTIVEPANEL,
        MOVE,
        RESIZE,
        INSERTINTO,
        CHANGESTYLE,
        SETSELECTION,
        SETVALUE,
        SETFOCUS,
        SCROLLTO,
        ENABLEINPUT,
        ROTATE,
        NONE;

    }

    public static enum ComponentType {
        NONE,
        CANVAS,
        SCREEN,
        TEMPLATE,
        MASTER,
        MASTERINSTANCE,
        ROOTCOMPONENT,
        GROUP,
        DYNAMICPANEL,
        PANEL,
        TABLE,
        ROW,
        CELLCONTAINER,
        TEXTCELL,
        DATAGRID,
        GRIDCELL,
        DATALIST,
        DATAROW,
        DATACELL,
        INDEX,
        SUMMARY,
        RICHTEXT,
        TEXTRANGE,
        FLASH,
        WEBSITE,
        URL,
        HTML,
        DOCUMENT,
        BUTTON,
        LABEL,
        IMAGE,
        INPUT,
        DATE,
        TIME,
        DATETIME,
        FILE,
        TEXT,
        PASSWORD,
        NUMBER,
        EMAIL,
        INPUTURL,
        TEXTAREA,
        CHECKBOX,
        RADIOBUTTON,
        SELECT,
        SELECTIONLIST,
        MULTISELECTIONLIST,
        DROPDOWN,
        NATIVEDROPDOWN,
        CHECKBOXLIST,
        RADIOBUTTONLIST,
        MENU,
        MENUNODE,
        TREE,
        TREENODE,
        IMAGEMAP,
        RECTANGLE,
        LINE,
        VARIABLE,
        DATAMASTER,
        FIELD,
        CATEGORY,
        RECORD,
        RECORDFIELD,
        ABSTRACTFOLDER,
        CANVASFOLDER,
        ELLIPSE,
        TRIANGLE,
        CALLOUT;

    }

    public static enum ScenarioComponentType {
        NONE,
        PAGE,
        ACTION,
        DECISION,
        NOTE;

    }
}

