/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine.output;

import java.io.IOException;
import java.io.Writer;
import org.stringtemplate.v4.AutoIndentWriter;

public final class ContextWriter
extends AutoIndentWriter {
    private static final String NEWLINE = System.getProperty("line.separator");
    private transient Boolean prettify;

    public ContextWriter(Writer out) {
        this(out, false);
    }

    public ContextWriter(Writer out, Boolean prettify) {
        super(out, prettify != false ? NEWLINE : "");
        this.prettify = prettify;
    }

    public int write(String str) throws IOException {
        StringBuilder output = new StringBuilder();
        if (this.prettify.booleanValue()) {
            output.append(str);
        } else {
            int start = 0;
            int end = str.length();
            while (start < end && str.charAt(start) <= ' ') {
                ++start;
            }
            while (start < end && str.charAt(end - 1) <= ' ') {
                --end;
            }
            Boolean hasEndTrimmed = end < str.length();
            if (start > 0 || hasEndTrimmed.booleanValue()) {
                output.append(str.substring(start, end));
                if (hasEndTrimmed.booleanValue()) {
                    output.append(" ");
                }
            } else {
                output.append(str);
            }
        }
        return super.write(output.toString());
    }
}

