/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine.output;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import com.justinmind.generator.engine.output.StandardStrategy;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.stringtemplate.v4.ST;

public final class HtmlStrategy
extends StandardStrategy {
    private transient HtmlCompressor htmlCompressor = null;
    private final transient Boolean compress;

    public HtmlStrategy(Boolean prettify, Boolean compress) {
        super(prettify);
        this.compress = compress;
    }

    @Override
    public void write(String fileName, ST context) throws IOException {
        if (this.compress.booleanValue()) {
            String compressedHtml = this.getHtmlCompressor().compress(context.render());
            if (compressedHtml == null) {
                super.write(fileName, context);
            } else {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.createFile(fileName), (boolean)this.getAppendMode()));
                try {
                    out.write(compressedHtml);
                    ((Writer)out).flush();
                }
                finally {
                    ((Writer)out).close();
                }
            }
        } else {
            super.write(fileName, context);
        }
    }

    public String generateString(ST context) {
        if (this.compress.booleanValue()) {
            return this.getHtmlCompressor().compress(context.render());
        }
        return context.render();
    }

    private HtmlCompressor getHtmlCompressor() {
        if (this.htmlCompressor == null) {
            this.htmlCompressor = new HtmlCompressor();
            this.htmlCompressor.setEnabled(true);
            this.htmlCompressor.setRemoveComments(true);
            this.htmlCompressor.setRemoveMultiSpaces(true);
            this.htmlCompressor.setRemoveIntertagSpaces(false);
            this.htmlCompressor.setRemoveQuotes(false);
            this.htmlCompressor.setSimpleDoctype(true);
            this.htmlCompressor.setRemoveScriptAttributes(true);
            this.htmlCompressor.setRemoveStyleAttributes(true);
            this.htmlCompressor.setRemoveLinkAttributes(true);
            this.htmlCompressor.setRemoveFormAttributes(true);
            this.htmlCompressor.setRemoveInputAttributes(false);
            this.htmlCompressor.setSimpleBooleanAttributes(true);
            this.htmlCompressor.setRemoveJavaScriptProtocol(true);
            this.htmlCompressor.setRemoveHttpProtocol(false);
            this.htmlCompressor.setRemoveHttpsProtocol(false);
            this.htmlCompressor.setCompressCss(false);
            this.htmlCompressor.setCompressJavaScript(false);
        }
        return this.htmlCompressor;
    }
}

