/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine.output;

import com.justinmind.generator.engine.GeneratorException;
import com.justinmind.generator.engine.output.HtmlStrategy;
import com.justinmind.generator.engine.output.OutputStrategy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.stringtemplate.v4.ST;

public class OutputEngine {
    public void write(String fileName, ST context, OutputStrategy strategy) throws GeneratorException {
        try {
            strategy.write(fileName, context);
        }
        catch (FileNotFoundException e) {
            throw new GeneratorException((Exception)e, Arrays.asList(GeneratorException.ExceptionType.NO_FILE_FOUND, GeneratorException.ExceptionType.ACCESS_DENIED));
        }
        catch (SecurityException e) {
            throw new GeneratorException((Exception)e, GeneratorException.ExceptionType.ACCESS_DENIED);
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneratorException((Exception)e, GeneratorException.ExceptionType.ENCODING_ERROR);
        }
        catch (IOException e) {
            throw new GeneratorException((Exception)e, Arrays.asList(GeneratorException.ExceptionType.ACCESS_DENIED, GeneratorException.ExceptionType.PATH_ERROR));
        }
    }

    public String writeString(ST context, OutputStrategy strategy) {
        if (strategy instanceof HtmlStrategy) {
            return ((HtmlStrategy)strategy).generateString(context);
        }
        return "ERROR";
    }
}

