/*
 * Decompiled with CFR 0.152.
 */
package com.justinmind.generator.engine.output;

import com.justinmind.generator.engine.output.ContextWriter;
import com.justinmind.generator.engine.output.OutputStrategy;
import com.justinmind.util.file.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STWriter;

public class StandardStrategy
implements OutputStrategy {
    protected final transient Boolean prettify;

    public StandardStrategy(Boolean prettify) {
        this.prettify = prettify;
    }

    @Override
    public Boolean getAppendMode() {
        return false;
    }

    @Override
    public void write(String fileName, ST context) throws IOException {
        this.writeFile(this.createFile(fileName), context);
    }

    protected File createFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            FileUtils.deepCreateFile((File)file);
        }
        return file;
    }

    protected void writeFile(File file, ST context) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file, (boolean)this.getAppendMode()));
        try {
            context.write(this.getContextWriter(out));
            ((Writer)out).flush();
        }
        finally {
            ((Writer)out).close();
        }
    }

    protected STWriter getContextWriter(Writer out) {
        return this.prettify != false ? new ContextWriter(out, this.prettify) : new NoIndentWriter(out);
    }
}

