/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import java.util.ArrayList;
import java.util.Iterator;
import net.arnx.wmf2svg.gdi.GdiFont;
import net.arnx.wmf2svg.gdi.GdiUtils;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgObject;
import org.w3c.dom.Text;

class SvgFont
extends SvgObject
implements GdiFont {
    private int height;
    private int width;
    private int escapement;
    private int orientation;
    private int weight;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private int charset;
    private int outPrecision;
    private int clipPrecision;
    private int quality;
    private int pitchAndFamily;
    private String faceName;
    private String lang;

    public SvgFont(SvgGdi svgGdi, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, int n6, int n7, int n8, int n9, int n10, byte[] byArray) {
        super(svgGdi);
        this.height = n;
        this.width = n2;
        this.escapement = n3;
        this.orientation = n4;
        this.weight = n5;
        this.italic = bl;
        this.underline = bl2;
        this.strikeout = bl3;
        this.charset = n6;
        this.outPrecision = n7;
        this.clipPrecision = n8;
        this.quality = n9;
        this.pitchAndFamily = n10;
        this.faceName = GdiUtils.convertString(byArray, n6);
        this.lang = GdiUtils.getLanguage(n6);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getEscapement() {
        return this.escapement;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderlined() {
        return this.underline;
    }

    public boolean isStrikedOut() {
        return this.strikeout;
    }

    public int getCharset() {
        return this.charset;
    }

    public int getOutPrecision() {
        return this.outPrecision;
    }

    public int getClipPrecision() {
        return this.clipPrecision;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    public String getFaceName() {
        return this.faceName;
    }

    public String getLang() {
        return this.lang;
    }

    private String getPitchString() {
        int n = this.pitchAndFamily & 3;
        switch (n) {
            case 1: {
                return "FIXED_PITCH";
            }
            case 2: {
                return "VARIABLE_PITCH";
            }
        }
        return "DEFAULT_PITCH";
    }

    private String getFontFamilyString() {
        int n = this.pitchAndFamily & 0xF0;
        switch (n) {
            case 80: {
                return "FF_DECORATIVE";
            }
            case 48: {
                return "FF_MODERN";
            }
            case 16: {
                return "FF_ROMAN";
            }
            case 64: {
                return "FF_SCRIPT";
            }
            case 32: {
                return "FF_SWISS";
            }
        }
        return "FF_DONTCARE";
    }

    public int[] validateDx(byte[] byArray, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        int[][] nArray2 = GdiUtils.getFirstByteArea(this.charset);
        if (nArray2 == null) {
            return nArray;
        }
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < byArray.length && i < nArray.length; ++i) {
            int n2 = 0xFF & byArray[i];
            if (bl) {
                int n3 = n - 1;
                nArray[n3] = nArray[n3] + nArray[i];
                bl = false;
                continue;
            }
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j][0] > n2 || n2 > nArray2[j][1]) continue;
                bl = true;
                break;
            }
            nArray[n++] = nArray[i];
        }
        int[] nArray3 = new int[n];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        return nArray3;
    }

    public int getFontSize() {
        return Math.abs(this.getGDI().getDC().toRelativeY(this.height));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.charset;
        n = 31 * n + this.clipPrecision;
        n = 31 * n + this.escapement;
        n = 31 * n + (this.faceName == null ? 0 : this.faceName.hashCode());
        n = 31 * n + this.height;
        n = 31 * n + (this.italic ? 1231 : 1237);
        n = 31 * n + this.orientation;
        n = 31 * n + this.outPrecision;
        n = 31 * n + this.pitchAndFamily;
        n = 31 * n + this.quality;
        n = 31 * n + (this.strikeout ? 1231 : 1237);
        n = 31 * n + (this.underline ? 1231 : 1237);
        n = 31 * n + this.weight;
        n = 31 * n + this.width;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SvgFont svgFont = (SvgFont)object;
        if (this.charset != svgFont.charset) {
            return false;
        }
        if (this.clipPrecision != svgFont.clipPrecision) {
            return false;
        }
        if (this.escapement != svgFont.escapement) {
            return false;
        }
        if (this.faceName == null ? svgFont.faceName != null : !this.faceName.equals(svgFont.faceName)) {
            return false;
        }
        if (this.height != svgFont.height) {
            return false;
        }
        if (this.italic != svgFont.italic) {
            return false;
        }
        if (this.orientation != svgFont.orientation) {
            return false;
        }
        if (this.outPrecision != svgFont.outPrecision) {
            return false;
        }
        if (this.pitchAndFamily != svgFont.pitchAndFamily) {
            return false;
        }
        if (this.quality != svgFont.quality) {
            return false;
        }
        if (this.strikeout != svgFont.strikeout) {
            return false;
        }
        if (this.underline != svgFont.underline) {
            return false;
        }
        if (this.weight != svgFont.weight) {
            return false;
        }
        return this.width == svgFont.width;
    }

    public Text createTextNode(String string) {
        return this.getGDI().getDocument().createTextNode("." + string + " { " + this.toString() + " }\n");
    }

    public String toString() {
        String string;
        String string2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.italic) {
            stringBuffer.append("font-style: italic; ");
        }
        if (this.weight != 0 && this.weight != 400) {
            this.weight = this.weight < 100 ? 100 : (this.weight > 900 ? 900 : this.weight / 100 * 100);
            if (this.weight == 700) {
                stringBuffer.append("font-weight: bold; ");
            } else {
                stringBuffer.append("font-weight: " + this.weight + "; ");
            }
        }
        if ((n = this.getFontSize()) != 0) {
            stringBuffer.append("font-size: ").append(n).append("px; ");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.faceName.length() != 0) {
            string2 = this.faceName;
            if (this.faceName.charAt(0) == '@') {
                string2 = this.faceName.substring(1);
            }
            arrayList.add(string2);
            string = (String)this.getGDI().getProperty("alternative-font." + string2);
            if (string != null && string.length() != 0) {
                arrayList.add(string);
            }
        }
        string2 = (String)this.getGDI().getProperty("generic-font." + this.getPitchString());
        string = (String)this.getGDI().getProperty("generic-font." + this.getFontFamilyString());
        if (string2 != null && string2.length() != 0) {
            arrayList.add(string2);
        } else if (string != null && string.length() != 0) {
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            stringBuffer.append("font-family:");
        }
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string3.indexOf(" ") != -1) {
                stringBuffer.append(" \"" + string3 + "\"");
            } else {
                stringBuffer.append(" " + string3);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("; ");
        if (this.underline || this.strikeout) {
            stringBuffer.append("text-decoration:");
            if (this.underline) {
                stringBuffer.append(" underline");
            }
            if (this.strikeout) {
                stringBuffer.append(" overline");
            }
            stringBuffer.append("; ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

