/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgRegion;
import org.w3c.dom.Element;

class SvgRectRegion
extends SvgRegion {
    private int left;
    private int top;
    private int right;
    private int bottom;

    public SvgRectRegion(SvgGdi svgGdi, int n, int n2, int n3, int n4) {
        super(svgGdi);
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public Element createElement() {
        Element element = this.getGDI().getDocument().createElement("rect");
        element.setAttribute("x", "" + this.getGDI().getDC().toAbsoluteX(this.getLeft()));
        element.setAttribute("y", "" + this.getGDI().getDC().toAbsoluteY(this.getTop()));
        element.setAttribute("width", "" + this.getGDI().getDC().toRelativeX(this.getRight() - this.getLeft()));
        element.setAttribute("height", "" + this.getGDI().getDC().toRelativeY(this.getBottom() - this.getTop()));
        return element;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.bottom;
        n = 31 * n + this.left;
        n = 31 * n + this.right;
        n = 31 * n + this.top;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SvgRectRegion svgRectRegion = (SvgRectRegion)object;
        if (this.bottom != svgRectRegion.bottom) {
            return false;
        }
        if (this.left != svgRectRegion.left) {
            return false;
        }
        if (this.right != svgRectRegion.right) {
            return false;
        }
        return this.top == svgRectRegion.top;
    }
}

