/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class AttributeEventImpl
extends DiffXEventBase
implements AttributeEvent {
    private final String name;
    private final String value;
    private int fHashCode;

    public AttributeEventImpl(String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (value == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.value).toHashCode();
        }
        return this.fHashCode;
    }

    public boolean equals(DiffXEvent e) {
        if (e.getClass() != this.getClass()) {
            return false;
        }
        AttributeEventImpl bae = (AttributeEventImpl)e;
        return bae.name.equals(this.name) && bae.value.equals(this.value);
    }

    public String toString() {
        return "attribute: " + this.name + "=" + this.value;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.attribute(this.name, this.value);
    }

    public StringBuffer toXML(StringBuffer xml) throws NullPointerException {
        xml.append(' ');
        xml.append(this.name);
        xml.append("=\"");
        xml.append(ESC.toAttributeValue(this.value));
        xml.append('\"');
        return xml;
    }
}

