/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.load.text.TextTokeniser;
import com.topologi.diffx.load.text.TextTokeniserByWord;
import com.topologi.diffx.load.text.TextTokeniserIgnoreSpace;
import com.topologi.diffx.load.text.TextTokeniserNoSpace;
import com.topologi.diffx.load.text.TextTokeniserSentence;
import com.topologi.diffx.load.text.TextTokeniserSingleBlock;

public final class TokeniserFactory {
    private final DiffXConfig config;
    private final transient int tokeniserChoice;

    public TokeniserFactory(DiffXConfig config) throws NullPointerException {
        if (config == null) {
            throw new NullPointerException("Factory requires a tokeniser.");
        }
        this.config = config;
        this.tokeniserChoice = (this.config.isIgnoreWhiteSpace() ? 2 : 0) + (this.config.isPreserveWhiteSpace() ? 0 : 1);
    }

    public TextTokeniser makeTokeniser(CharSequence text) {
        if (this.config.isTokenizeBlocks()) {
            return new TextTokeniserSingleBlock(text);
        }
        if (this.config.isTokenizeSentences()) {
            return new TextTokeniserSentence(text);
        }
        switch (this.tokeniserChoice) {
            case 0: {
                return new TextTokeniserByWord(text);
            }
            case 1: {
                return new TextTokeniserByWord(text);
            }
            case 2: {
                return new TextTokeniserIgnoreSpace(text);
            }
            case 3: {
                return new TextTokeniserNoSpace(text);
            }
        }
        throw new IllegalStateException("Impossible whitespace configuration: " + this.tokeniserChoice);
    }

    public DiffXConfig getConfig() {
        return this.config;
    }
}

