/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.sequence;

import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.sequence.EventSequence;
import java.io.IOException;

public final class SequenceSlicer {
    final EventSequence sequence1;
    final EventSequence sequence2;
    EventSequence start = null;
    EventSequence end = null;

    public SequenceSlicer(EventSequence seq0, EventSequence seq1) {
        this.sequence1 = seq0;
        this.sequence2 = seq1;
    }

    public void slice() throws IllegalStateException {
        this.sliceStart();
        this.sliceEnd();
    }

    public int sliceStart() throws IllegalStateException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        this.start = new EventSequence();
        int toBeRemoved = 0;
        int depth = 0;
        EventSequence.EventIterator i = this.sequence1.eventIterator();
        EventSequence.EventIterator j = this.sequence2.eventIterator();
        int counter = 0;
        while (i.hasNext() && j.hasNext()) {
            DiffXEvent e = (DiffXEvent)i.next();
            if (!j.next().equals(e)) break;
            ++counter;
            if (e instanceof OpenElementEvent) {
                ++depth;
            } else if (e instanceof CloseElementEvent) {
                --depth;
            }
            if (depth != 1 && depth != 0) continue;
            toBeRemoved = counter;
        }
        for (int k = 0; k < toBeRemoved; ++k) {
            DiffXEvent e = this.sequence1.removeEvent(0);
            this.sequence2.removeEvent(0);
            this.start.addEvent(e);
        }
        return toBeRemoved;
    }

    public int sliceEnd() throws IllegalStateException {
        int k;
        DiffXEvent e1;
        if (this.end != null) {
            throw new IllegalStateException("The end buffer already contains a subsequence.");
        }
        this.end = new EventSequence();
        int depth = 0;
        int toBeRemoved = 0;
        int counter = 0;
        int pos1 = this.sequence1.size() - 1;
        for (int pos2 = this.sequence2.size() - 1; pos1 >= 0 && pos2 >= 0 && (e1 = this.sequence1.getEvent(pos1)).equals(this.sequence2.getEvent(pos2)); --pos1, --pos2) {
            ++counter;
            if (e1 instanceof CloseElementEvent) {
                ++depth;
            } else if (e1 instanceof OpenElementEvent) {
                --depth;
            }
            if (depth != 1 && depth != 0) continue;
            toBeRemoved = counter;
        }
        int downTo = this.sequence1.size() - toBeRemoved;
        for (k = this.sequence1.size() - 1; k >= downTo; --k) {
            DiffXEvent e = this.sequence1.removeEvent(k);
            this.end.addEvent(0, e);
        }
        downTo = this.sequence2.size() - toBeRemoved;
        for (k = this.sequence2.size() - 1; k >= downTo; --k) {
            this.sequence2.removeEvent(k);
        }
        return toBeRemoved;
    }

    public void formatStart(DiffXFormatter formatter) throws NullPointerException, IOException {
        if (this.start == null) {
            return;
        }
        for (int i = 0; i < this.start.size(); ++i) {
            formatter.format(this.start.getEvent(i));
        }
        this.start = null;
    }

    public void formatEnd(DiffXFormatter formatter) throws NullPointerException, IOException {
        if (this.end == null) {
            return;
        }
        for (int i = 0; i < this.end.size(); ++i) {
            formatter.format(this.end.getEvent(i));
        }
        this.end = null;
    }

    public EventSequence getStart() {
        return this.start;
    }

    public EventSequence getEnd() {
        return this.end;
    }
}

