/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static Logger log = Logger.getLogger(XmlUtils.class);
    public static String TRANSFORMER_FACTORY_ORIGINAL;
    public static String TRANSFORMER_FACTORY_PROCESSOR_XALAN;
    public static TransformerFactory tfactory;

    private static void setTFactory() {
        try {
            System.setProperty("javax.xml.transform.TransformerFactory", TRANSFORMER_FACTORY_PROCESSOR_XALAN);
            tfactory = TransformerFactory.newInstance();
            System.setProperty("javax.xml.transform.TransformerFactory", TRANSFORMER_FACTORY_ORIGINAL);
        }
        catch (TransformerFactoryConfigurationError e) {
            log.error((Object)e);
            System.out.println("Warning: Xalan jar missing from classpath; xslt not supported");
            System.setProperty("javax.xml.transform.TransformerFactory", TRANSFORMER_FACTORY_ORIGINAL);
            tfactory = TransformerFactory.newInstance();
        }
        LoggingErrorListener errorListener = new LoggingErrorListener(false);
        tfactory.setErrorListener(errorListener);
    }

    public static Object unwrap(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JAXBElement) {
            log.debug((Object)("Unwrapped " + ((JAXBElement)o).getDeclaredType().getName()));
            log.debug((Object)("name: " + ((JAXBElement)o).getName()));
            return ((JAXBElement)o).getValue();
        }
        return o;
    }

    public static String JAXBElementDebug(JAXBElement o) {
        String prefix = null;
        if (o.getName().getNamespaceURI() != null) {
            try {
                prefix = NamespacePrefixMapperUtils.getPreferredPrefix(o.getName().getNamespaceURI(), null, false);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        if (prefix != null) {
            return prefix + ':' + o.getName().getLocalPart() + " is a javax.xml.bind.JAXBElement; it has declared type " + o.getDeclaredType().getName();
        }
        return o.getName() + " is a javax.xml.bind.JAXBElement; it has declared type " + o.getDeclaredType().getName();
    }

    public static Object unmarshal(InputStream is) throws JAXBException {
        return XmlUtils.unmarshal(is, Context.jc);
    }

    public static Object unmarshal(InputStream is, JAXBContext jc) throws JAXBException {
        Object o = null;
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        o = u.unmarshal(is);
        return o;
    }

    public static Object unmarshalString(String str) throws JAXBException {
        return XmlUtils.unmarshalString(str, Context.jc);
    }

    public static Object unmarshalString(String str, JAXBContext jc, Class declaredType) throws JAXBException {
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        JAXBElement o = u.unmarshal((Source)new StreamSource(new StringReader(str)), declaredType);
        if (o instanceof JAXBElement) {
            return o.getValue();
        }
        return o;
    }

    public static Object unmarshalString(String str, JAXBContext jc) throws JAXBException {
        log.debug((Object)("Unmarshalling '" + str + "'"));
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        return u.unmarshal((Source)new StreamSource(new StringReader(str)));
    }

    public static Object unmarshal(Node n) throws JAXBException {
        Unmarshaller u = Context.jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        return u.unmarshal(n);
    }

    public static Object unmarshal(Node n, JAXBContext jc, Class declaredType) throws JAXBException {
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        JAXBElement o = u.unmarshal(n, declaredType);
        if (o instanceof JAXBElement) {
            return o.getValue();
        }
        return o;
    }

    public static Object unmarshallFromTemplate(String wmlTemplateString, HashMap<String, String> mappings) throws JAXBException {
        return XmlUtils.unmarshallFromTemplate(wmlTemplateString, mappings, Context.jc);
    }

    public static Object unmarshallFromTemplate(String wmlTemplateString, HashMap<String, String> mappings, JAXBContext jc) throws JAXBException {
        String wmlString = XmlUtils.replace(wmlTemplateString, 0, new StringBuilder(), mappings).toString();
        log.debug((Object)("Results of substitution: " + wmlString));
        return XmlUtils.unmarshalString(wmlString, jc);
    }

    public static Object unmarshallFromTemplate(String wmlTemplateString, HashMap<String, String> mappings, JAXBContext jc, Class<?> declaredType) throws JAXBException {
        String wmlString = XmlUtils.replace(wmlTemplateString, 0, new StringBuilder(), mappings).toString();
        return XmlUtils.unmarshalString(wmlString, jc, declaredType);
    }

    private static StringBuilder replace(String s, int offset, StringBuilder b, HashMap<String, String> mappings) {
        int startKey = s.indexOf("${", offset);
        if (startKey == -1) {
            return b.append(s.substring(offset));
        }
        b.append(s.substring(offset, startKey));
        int keyEnd = s.indexOf(125, startKey);
        String key = s.substring(startKey + 2, keyEnd);
        String val = mappings.get(key);
        if (val == null) {
            log.warn((Object)("Invalid key '" + key + "' or key not mapped to a value"));
            b.append(key);
        } else {
            b.append(val);
        }
        return XmlUtils.replace(s, keyEnd + 1, b, mappings);
    }

    public static String marshaltoString(Object o, boolean suppressDeclaration) {
        JAXBContext jc = Context.jc;
        return XmlUtils.marshaltoString(o, suppressDeclaration, false, jc);
    }

    public static String marshaltoString(Object o, boolean suppressDeclaration, JAXBContext jc) {
        return XmlUtils.marshaltoString(o, suppressDeclaration, false, jc);
    }

    public static String marshaltoString(Object o, boolean suppressDeclaration, boolean prettyprint) {
        JAXBContext jc = Context.jc;
        return XmlUtils.marshaltoString(o, suppressDeclaration, prettyprint, jc);
    }

    public static String marshaltoString(Object o, boolean suppressDeclaration, boolean prettyprint, JAXBContext jc) {
        if (o == null) {
            return null;
        }
        try {
            Marshaller m = jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(m, NamespacePrefixMapperUtils.getPrefixMapper());
            if (prettyprint) {
                m.setProperty("jaxb.formatted.output", (Object)true);
            }
            if (suppressDeclaration) {
                m.setProperty("jaxb.fragment", (Object)true);
            }
            StringWriter sWriter = new StringWriter();
            m.marshal(o, (Writer)sWriter);
            return sWriter.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static String marshaltoString(Object o, boolean suppressDeclaration, boolean prettyprint, JAXBContext jc, String uri, String local, Class declaredType) {
        try {
            Marshaller m = jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(m, NamespacePrefixMapperUtils.getPrefixMapper());
            if (prettyprint) {
                m.setProperty("jaxb.formatted.output", (Object)true);
            }
            if (suppressDeclaration) {
                m.setProperty("jaxb.fragment", (Object)true);
            }
            StringWriter sWriter = new StringWriter();
            m.marshal((Object)new JAXBElement(new QName(uri, local), declaredType, o), (Writer)sWriter);
            return sWriter.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream marshaltoInputStream(Object o, boolean suppressDeclaration, JAXBContext jc) {
        try {
            Marshaller m = jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(m, NamespacePrefixMapperUtils.getPrefixMapper());
            if (suppressDeclaration) {
                m.setProperty("jaxb.fragment", (Object)true);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            m.marshal(o, (OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document marshaltoW3CDomDocument(Object o) {
        return XmlUtils.marshaltoW3CDomDocument(o, Context.jc);
    }

    public static Document marshaltoW3CDomDocument(Object o, JAXBContext jc) {
        try {
            Marshaller marshaller = jc.createMarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().newDocument();
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            marshaller.marshal(o, (Node)doc);
            return doc;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document marshaltoW3CDomDocument(Object o, JAXBContext jc, String uri, String local, Class declaredType) {
        try {
            Marshaller marshaller = jc.createMarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().newDocument();
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            marshaller.marshal((Object)new JAXBElement(new QName(uri, local), declaredType, o), (Node)doc);
            return doc;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deepCopy(T value) {
        return XmlUtils.deepCopy(value, Context.jc);
    }

    public static <T> T deepCopy(T value, JAXBContext jc) {
        if (value == null) {
            throw new IllegalArgumentException("Can't clone a null argument");
        }
        try {
            Object res;
            Class<?> valueClass;
            JAXBElement elem;
            if (value instanceof JAXBElement) {
                log.debug((Object)"deep copy of JAXBElement..");
                elem = (JAXBElement)value;
                valueClass = elem.getDeclaredType();
            } else {
                log.debug((Object)("deep copy of " + value.getClass().getName()));
                Class<?> classT = value.getClass();
                elem = new JAXBElement(new QName("temp"), classT, value);
                valueClass = classT;
            }
            Marshaller mar = jc.createMarshaller();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(256);
            mar.marshal((Object)elem, (OutputStream)bout);
            Unmarshaller unmar = jc.createUnmarshaller();
            elem = unmar.unmarshal((Source)new StreamSource(new ByteArrayInputStream(bout.toByteArray())), valueClass);
            if (value instanceof JAXBElement) {
                JAXBElement resT;
                res = resT = elem;
            } else {
                Object resT = elem.getValue();
                res = resT;
            }
            return (T)res;
        }
        catch (JAXBException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String w3CDomNodeToString(Node n) {
        StringWriter sw = new StringWriter();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(new DOMSource(n), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document neww3cDomDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendXmlFragment(Document document, Node parent, String fragment) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Node fragmentNode = docBuilder.parse(new InputSource(new StringReader(fragment))).getDocumentElement();
        fragmentNode = document.importNode(fragmentNode, true);
        parent.appendChild(fragmentNode);
    }

    public static JAXBResult prepareJAXBResult(JAXBContext context) throws Docx4JException {
        JAXBResult result;
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            result = new JAXBResult(unmarshaller);
        }
        catch (JAXBException e) {
            throw new Docx4JException("Error preparing empty JAXB result", (Exception)((Object)e));
        }
        return result;
    }

    public static void transform(Document doc, Templates template, Map<String, Object> transformParameters, Result result) throws Docx4JException {
        if (doc == null) {
            Throwable t = new Throwable();
            throw new Docx4JException("Null DOM Doc", t);
        }
        DOMSource domSource = new DOMSource(doc);
        XmlUtils.transform(domSource, template, transformParameters, result);
    }

    public static Templates getTransformerTemplate(Source xsltSource) throws TransformerConfigurationException {
        return tfactory.newTemplates(xsltSource);
    }

    public static void transform(Source source, Templates template, Map<String, Object> transformParameters, Result result) throws Docx4JException {
        Transformer xformer;
        if (source == null) {
            Throwable t = new Throwable();
            throw new Docx4JException("Null Source doc", t);
        }
        try {
            xformer = template.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new Docx4JException("The Transformer is ill-configured", e);
        }
        if (!xformer.getClass().getName().equals("org.apache.xalan.transformer.TransformerImpl")) {
            log.error((Object)("Detected " + xformer.getClass().getName() + ", but require org.apache.xalan.transformer.TransformerImpl. " + "Ensure Xalan 2.7.0 is on your classpath!"));
        }
        LoggingErrorListener errorListener = new LoggingErrorListener(false);
        xformer.setErrorListener(errorListener);
        if (transformParameters != null) {
            for (Map.Entry<String, Object> pairs : transformParameters.entrySet()) {
                if (pairs.getKey() == null) {
                    log.info((Object)"Skipped null key");
                    continue;
                }
                if (pairs.getValue() == null) {
                    log.warn((Object)("parameter '" + pairs.getKey() + "' was null."));
                    continue;
                }
                xformer.setParameter(pairs.getKey(), pairs.getValue());
            }
        }
        try {
            xformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new Docx4JException("Cannot perform the transformation", e);
        }
    }

    public static List<Object> getJAXBNodesViaXPath(Binder<Node> binder, Object jaxbElement, String xpathExpr, boolean refreshXmlFirst) throws JAXBException {
        if (refreshXmlFirst) {
            Node node = (Node)binder.updateXML(jaxbElement);
        }
        Node node = (Node)binder.getXMLNode(jaxbElement);
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Node n : XmlUtils.xpath(node, xpathExpr)) {
            Object o = binder.getJAXBNode((Object)n);
            if (o == null) {
                log.warn((Object)"no object association for xpath result!");
                continue;
            }
            if (o instanceof JAXBElement) {
                log.debug((Object)("added " + XmlUtils.JAXBElementDebug((JAXBElement)o)));
            } else {
                log.debug((Object)("added " + o.getClass().getName()));
            }
            resultList.add(o);
        }
        return resultList;
    }

    public static List<Node> xpath(Node node, String xpathExpression) {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        NamespacePrefixMappings nsContext = new NamespacePrefixMappings();
        return XmlUtils.xpath(node, xpathExpression, nsContext);
    }

    public static List<Node> xpath(Node node, String xpathExpression, NamespaceContext nsContext) {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        xpath.setNamespaceContext(nsContext);
        try {
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList nl = (NodeList)xpath.evaluate(xpathExpression, node, XPathConstants.NODESET);
            log.debug((Object)("evaluate returned " + nl.getLength()));
            for (int i = 0; i < nl.getLength(); ++i) {
                result.add(nl.item(i));
            }
            return result;
        }
        catch (XPathExpressionException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void treeCopy(NodeList sourceNodes, Node destParent) {
        for (int i = 0; i < sourceNodes.getLength(); ++i) {
            XmlUtils.treeCopy(sourceNodes.item(i), destParent);
        }
    }

    public static void treeCopy(Node sourceNode, Node destParent) {
        log.debug((Object)("node type" + sourceNode.getNodeType()));
        switch (sourceNode.getNodeType()) {
            case 9: {
                NodeList nodes = sourceNode.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    log.debug((Object)("child " + i + "of DOCUMENT_NODE"));
                    XmlUtils.treeCopy(nodes.item(i), destParent);
                }
                break;
            }
            case 1: {
                log.debug((Object)("copying: " + sourceNode.getNodeName()));
                Element newChild = destParent instanceof Document ? ((Document)destParent).createElementNS(sourceNode.getNamespaceURI(), sourceNode.getLocalName()) : (sourceNode.getNamespaceURI() != null ? destParent.getOwnerDocument().createElementNS(sourceNode.getNamespaceURI(), sourceNode.getLocalName()) : destParent.getOwnerDocument().createElement(sourceNode.getNodeName()));
                destParent.appendChild(newChild);
                NamedNodeMap atts = sourceNode.getAttributes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    Attr attr = (Attr)atts.item(i);
                    if (attr.getNodeName().startsWith("xmlns:")) continue;
                    if (attr.getNamespaceURI() == null) {
                        newChild.setAttribute(attr.getName(), attr.getValue());
                        continue;
                    }
                    if (attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                    newChild.setAttributeNS(attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
                }
                NodeList children = sourceNode.getChildNodes();
                if (children == null) break;
                for (int i = 0; i < children.getLength(); ++i) {
                    XmlUtils.treeCopy(children.item(i), (Node)newChild);
                }
                break;
            }
            case 3: {
                if (destParent.getOwnerDocument() == null && destParent.getNodeName().equals("#document")) {
                    Text textNode = ((Document)destParent).createTextNode(sourceNode.getNodeValue());
                    destParent.appendChild(textNode);
                    break;
                }
                Text textNode = destParent.getOwnerDocument().createTextNode(sourceNode.getNodeValue());
                destParent.appendChild(textNode);
            }
        }
    }

    static {
        TRANSFORMER_FACTORY_PROCESSOR_XALAN = "org.apache.xalan.processor.TransformerFactoryImpl";
        TransformerFactory tmpfactory = TransformerFactory.newInstance();
        TRANSFORMER_FACTORY_ORIGINAL = tmpfactory.getClass().getName();
        tmpfactory = null;
        log.debug((Object)("Set TRANSFORMER_FACTORY_ORIGINAL to " + TRANSFORMER_FACTORY_ORIGINAL));
        XmlUtils.setTFactory();
        System.out.println(System.getProperty("java.vendor"));
        System.out.println(System.getProperty("java.version"));
        if (System.getProperty("java.version").startsWith("1.6") && System.getProperty("java.vendor").startsWith("Sun") || System.getProperty("java.version").startsWith("1.7") && System.getProperty("java.vendor").startsWith("Oracle")) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        } else {
            log.warn((Object)("Using default SAXParserFactory: " + System.getProperty("javax.xml.parsers.SAXParserFactory")));
        }
    }

    static class LoggingErrorListener
    implements ErrorListener {
        boolean strict;

        public LoggingErrorListener(boolean strict) {
        }

        public void warning(TransformerException exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }

        public void error(TransformerException exception) throws TransformerException {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            if (this.strict) {
                throw exception;
            }
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }
}

