/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.DocumentProperties;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Section;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;

public class Doc {
    private static Logger log = Logger.getLogger(Doc.class);

    public static WordprocessingMLPackage convert(FileInputStream in) throws Exception {
        HWPFDocument doc = new HWPFDocument((InputStream)in);
        WordprocessingMLPackage out = WordprocessingMLPackage.createPackage();
        Doc.convert(doc, out);
        return out;
    }

    private static void convert(HWPFDocument doc, WordprocessingMLPackage wordMLPackage) throws Exception {
        StyleSheet stylesheet = doc.getStyleSheet();
        ListTables listTables = doc.getListTables();
        DocumentProperties docProps = doc.getDocProperties();
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        ObjectFactory factory = new ObjectFactory();
        Range r = doc.getRange();
        for (int x = 0; x < r.numSections(); ++x) {
            Section s = r.getSection(x);
            for (int y = 0; y < s.numParagraphs(); ++y) {
                Paragraph p = s.getParagraph(y);
                if (p.isInTable()) {
                    Table t = s.getTable(p);
                    int cl = Doc.numCol(t);
                    log.info((Object)("Found " + t.numRows() + "x" + cl + " table - TODO - convert"));
                    Doc.handleTable(t, stylesheet, documentPart, factory);
                    y += t.numParagraphs() - 1;
                    continue;
                }
                P paraToAdd = Doc.handleP(p, stylesheet, documentPart, factory);
                documentPart.addObject(paraToAdd);
            }
        }
    }

    private static P handleP(Paragraph p, StyleSheet stylesheet, MainDocumentPart documentPart, ObjectFactory factory) {
        P wmlP = null;
        if (p.getStyleIndex() > 0) {
            log.debug((Object)("Styled paragraph, with index: " + p.getStyleIndex()));
            String styleName = stylesheet.getStyleDescription((int)p.getStyleIndex()).getName();
            log.debug((Object)styleName);
            wmlP = documentPart.createStyledParagraphOfText(Doc.stripSpace(styleName), null);
        } else {
            wmlP = documentPart.createParagraphOfText(null);
        }
        for (int z = 0; z < p.numCharacterRuns(); ++z) {
            CharacterRun run = p.getCharacterRun(z);
            RPr rPr = null;
            if (run.isBold()) {
                if (rPr == null) {
                    rPr = factory.createRPr();
                }
                BooleanDefaultTrue boldOn = factory.createBooleanDefaultTrue();
                boldOn.setVal(Boolean.TRUE);
                rPr.setB(boldOn);
            }
            String text = run.text();
            log.debug((Object)("Processing: " + text));
            String cleansed = Doc.stripNonValidXMLCharacters(text);
            if (!text.equals(cleansed)) {
                log.warn((Object)"Cleansed..");
            }
            Text t = factory.createText();
            t.setValue(cleansed);
            R wmlRun = factory.createR();
            if (rPr != null) {
                wmlRun.setRPr(rPr);
            }
            wmlRun.getRunContent().add(t);
            wmlP.getParagraphContent().add(wmlRun);
        }
        return wmlP;
    }

    private static String stripSpace(String in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == ' ') continue;
            sb.append(in.charAt(i));
        }
        return sb.toString();
    }

    private static void addTODO(ObjectFactory factory, P wmlP, String message) {
        Text t = factory.createText();
        t.setValue(message);
        R wmlRun = factory.createR();
        wmlRun.getRunContent().add(t);
        wmlP.getParagraphContent().add(wmlRun);
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                out.append(current);
                continue;
            }
            out.append("[#?]");
        }
        return out.toString();
    }

    private static int numCol(Table t) {
        int col = 0;
        for (int i = 0; i < t.numRows(); ++i) {
            if (t.getRow(i).numCells() <= col) continue;
            col = t.getRow(i).numCells();
        }
        return col;
    }

    private static void handleTable(Table t, StyleSheet stylesheet, MainDocumentPart documentPart, ObjectFactory factory) {
        Tbl tbl = factory.createTbl();
        documentPart.addObject(tbl);
        TblPr tblPr = factory.createTblPr();
        tbl.setTblPr(tblPr);
        TblGrid tblGrid = factory.createTblGrid();
        tbl.setTblGrid(tblGrid);
        for (int i = 0; i < t.numRows(); ++i) {
            TableRow tr = t.getRow(i);
            Tr trOut = factory.createTr();
            tbl.getEGContentRowContent().add(trOut);
            for (int j = 0; j < tr.numCells(); ++j) {
                TableCell tc = tr.getCell(j);
                Tc tcOut = factory.createTc();
                trOut.getEGContentCellContent().add(tcOut);
                for (int y = 0; y < tc.numParagraphs(); ++y) {
                    Paragraph p = tc.getParagraph(y);
                    P paraToAdd = Doc.handleP(p, stylesheet, documentPart, factory);
                    tcOut.getEGBlockLevelElts().add(paraToAdd);
                    log.debug((Object)"Added p to tc");
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String localPath = "/home/dev/TargetFeatureSet.doc";
        WordprocessingMLPackage out = Doc.convert(new FileInputStream(localPath));
        String outputfilepath = "/home/dev/tmp/test-out.docx";
        SaveToZipFile saver = new SaveToZipFile(out);
        saver.save(outputfilepath);
        log.info((Object)("Done - saved docx as " + outputfilepath));
    }
}

