/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.ListHelper;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.org.xhtmlrenderer.css.constants.CSSName;
import org.docx4j.org.xhtmlrenderer.css.constants.IdentValue;
import org.docx4j.org.xhtmlrenderer.css.style.CalculatedStyle;
import org.docx4j.org.xhtmlrenderer.css.style.DerivedValue;
import org.docx4j.org.xhtmlrenderer.css.style.FSDerivedValue;
import org.docx4j.org.xhtmlrenderer.docx.Docx4JFSImage;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jUserAgent;
import org.docx4j.org.xhtmlrenderer.docx.DocxRenderer;
import org.docx4j.org.xhtmlrenderer.layout.Styleable;
import org.docx4j.org.xhtmlrenderer.newtable.TableBox;
import org.docx4j.org.xhtmlrenderer.newtable.TableCellBox;
import org.docx4j.org.xhtmlrenderer.newtable.TableRowBox;
import org.docx4j.org.xhtmlrenderer.newtable.TableSectionBox;
import org.docx4j.org.xhtmlrenderer.render.AnonymousBlockBox;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.org.xhtmlrenderer.render.Box;
import org.docx4j.org.xhtmlrenderer.render.InlineBox;
import org.docx4j.org.xhtmlrenderer.resource.XMLResource;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTTblLayoutType;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.STTblLayoutType;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSValue;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLImporter {
    protected static Logger log = Logger.getLogger(XHTMLImporter.class);
    private static String hyperlinkStyleId = null;
    private List<Object> imports = new ArrayList<Object>();
    private P currentP;
    private WordprocessingMLPackage wordMLPackage;
    private RelationshipsPart rp;
    private NumberingDefinitionsPart ndp;
    private ListHelper listHelper;
    private DocxRenderer renderer;
    boolean paraStillEmpty;
    private boolean inAlreadyProcessed = false;

    public static void setHyperlinkStyle(String hyperlinkStyleID) {
        hyperlinkStyleId = hyperlinkStyleID;
    }

    private XHTMLImporter(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
        this.rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        this.ndp = wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        this.listHelper = new ListHelper();
        if (hyperlinkStyleId != null && wordMLPackage instanceof WordprocessingMLPackage) {
            wordMLPackage.getMainDocumentPart().getPropertyResolver().activateStyle(hyperlinkStyleId);
        }
    }

    public static List<Object> convert(File file, String baseUrl, WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        XHTMLImporter importer = new XHTMLImporter(wordMLPackage);
        importer.renderer = new DocxRenderer();
        File parent = file.getAbsoluteFile().getParentFile();
        try {
            importer.renderer.setDocument(importer.renderer.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new Docx4JException("Malformed URL", e);
        }
        importer.renderer.layout();
        importer.traverse((Box)importer.renderer.getRootBox(), importer.imports, null);
        return importer.imports;
    }

    public static List<Object> convert(InputSource is, String baseUrl, WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        XHTMLImporter importer = new XHTMLImporter(wordMLPackage);
        importer.renderer = new DocxRenderer();
        Document dom = XMLResource.load((InputSource)is).getDocument();
        importer.renderer.setDocument(dom, baseUrl);
        importer.renderer.layout();
        importer.traverse((Box)importer.renderer.getRootBox(), importer.imports, null);
        return importer.imports;
    }

    public static List<Object> convert(InputStream is, String baseUrl, WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        XHTMLImporter importer = new XHTMLImporter(wordMLPackage);
        importer.renderer = new DocxRenderer();
        Document dom = XMLResource.load((InputStream)is).getDocument();
        importer.renderer.setDocument(dom, baseUrl);
        importer.renderer.layout();
        importer.traverse((Box)importer.renderer.getRootBox(), importer.imports, null);
        return importer.imports;
    }

    public static List<Object> convert(Node node, String baseUrl, WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        XHTMLImporter importer = new XHTMLImporter(wordMLPackage);
        importer.renderer = new DocxRenderer();
        if (node instanceof Document) {
            importer.renderer.setDocument((Document)node, baseUrl);
        } else {
            Document doc = XmlUtils.neww3cDomDocument();
            doc.importNode(node, true);
            importer.renderer.setDocument(doc, baseUrl);
        }
        importer.renderer.layout();
        importer.traverse((Box)importer.renderer.getRootBox(), importer.imports, null);
        return importer.imports;
    }

    public static List<Object> convert(Reader reader, String baseUrl, WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        XHTMLImporter importer = new XHTMLImporter(wordMLPackage);
        importer.renderer = new DocxRenderer();
        Document dom = XMLResource.load((Reader)reader).getDocument();
        importer.renderer.setDocument(dom, baseUrl);
        importer.renderer.layout();
        importer.traverse((Box)importer.renderer.getRootBox(), importer.imports, null);
        return importer.imports;
    }

    public static List<Object> convert(Source source, String baseUrl, WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        XHTMLImporter importer = new XHTMLImporter(wordMLPackage);
        importer.renderer = new DocxRenderer();
        Document dom = XMLResource.load((Source)source).getDocument();
        importer.renderer.setDocument(dom, baseUrl);
        importer.renderer.layout();
        importer.traverse((Box)importer.renderer.getRootBox(), importer.imports, null);
        return importer.imports;
    }

    public static List<Object> convert(URL url, WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        XHTMLImporter importer = new XHTMLImporter(wordMLPackage);
        importer.renderer = new DocxRenderer();
        String urlString = url.toString();
        Document dom = importer.renderer.loadDocument(urlString);
        importer.renderer.setDocument(dom, urlString);
        importer.renderer.layout();
        importer.traverse((Box)importer.renderer.getRootBox(), importer.imports, null);
        return importer.imports;
    }

    public static List<Object> convert(String content, String baseUrl, WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        XHTMLImporter importer = new XHTMLImporter(wordMLPackage);
        importer.renderer = new DocxRenderer();
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        Document dom = XMLResource.load((InputSource)is).getDocument();
        importer.renderer.setDocument(dom, baseUrl);
        importer.renderer.layout();
        importer.traverse((Box)importer.renderer.getRootBox(), importer.imports, null);
        return importer.imports;
    }

    private Map<String, CSSValue> getCascadedProperties(CalculatedStyle cs) {
        HashMap<String, CSSValue> cssMap = new HashMap<String, CSSValue>();
        FSDerivedValue[] derivedValues = cs.getDerivedValues();
        for (int i = 0; i < derivedValues.length; ++i) {
            CSSName name = CSSName.getByID((int)i);
            if (name.toString().startsWith("-fs")) continue;
            FSDerivedValue val = cs.valueByName(name);
            if (val != null && val instanceof DerivedValue) {
                cssMap.put(name.toString(), ((DerivedValue)val).getCSSPrimitiveValue());
                continue;
            }
            if (val != null && val instanceof IdentValue) {
                cssMap.put(name.toString(), ((IdentValue)val).getCSSPrimitiveValue());
                continue;
            }
            if (val != null) {
                log.debug((Object)("Skipping " + name.toString() + " .. " + val.getClass().getName()));
                continue;
            }
            log.debug((Object)("Skipping " + name.toString() + " .. (null value)"));
        }
        return cssMap;
    }

    private void traverse(Box box, List<Object> contentContext, TableProperties tableProperties) throws Docx4JException {
        log.info((Object)box.getClass().getName());
        if (box instanceof BlockBox) {
            BlockBox blockBox = (BlockBox)box;
            Element e = box.getElement();
            if (e == null) {
                log.info((Object)"<NULL>");
            } else {
                log.info((Object)("BB<" + e.getNodeName() + " " + box.getStyle().toStringMine()));
                Map<String, CSSValue> cssMap = this.getCascadedProperties(box.getStyle());
                if (box.getStyle().getDisplayMine().equals("inline")) {
                    if (this.currentP == null) {
                        this.currentP = Context.getWmlObjectFactory().createP();
                        contentContext.add(this.currentP);
                        this.paraStillEmpty = true;
                    }
                } else if (box instanceof TableSectionBox) {
                    log.info((Object)".. processing <tbody");
                } else if (e.getNodeName().equals(box instanceof TableBox) || e.getNodeName().equals("table")) {
                    log.info((Object)".. processing table");
                    TableBox cssTable = (TableBox)box;
                    tableProperties = new TableProperties();
                    tableProperties.setTableBox(cssTable);
                    Tbl tbl = Context.getWmlObjectFactory().createTbl();
                    contentContext.add(tbl);
                    this.paraStillEmpty = true;
                    contentContext = tbl.getContent();
                    TblPr tblPr = Context.getWmlObjectFactory().createTblPr();
                    tbl.setTblPr(tblPr);
                    CTTblPrBase.TblStyle tblStyle = Context.getWmlObjectFactory().createCTTblPrBaseTblStyle();
                    tblStyle.setVal("TableGrid");
                    tblPr.setTblStyle(tblStyle);
                    if (cssTable.getMargin().left() > 0.0f) {
                        log.info((Object)("Calculating TblInd from margin.left: " + cssTable.getMargin().left()));
                        TblWidth tblIW = Context.getWmlObjectFactory().createTblWidth();
                        tblIW.setW(BigInteger.valueOf(Math.round(cssTable.getMargin().left())));
                        tblIW.setType("dxa");
                        tblPr.setTblInd(tblIW);
                    }
                    TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
                    tblW.setW(BigInteger.ZERO);
                    tblW.setType("auto");
                    tblPr.setTblW(tblW);
                    if (cssTable.getStyle().isIdent(CSSName.TABLE_LAYOUT, IdentValue.AUTO) || cssTable.getStyle().isAutoWidth()) {
                        tableProperties.setFixedWidth(false);
                    } else {
                        tableProperties.setFixedWidth(true);
                        CTTblLayoutType tblLayout = Context.getWmlObjectFactory().createCTTblLayoutType();
                        tblLayout.setType(STTblLayoutType.FIXED);
                        tblPr.setTblLayout(tblLayout);
                    }
                    TblGrid tblGrid = Context.getWmlObjectFactory().createTblGrid();
                    tbl.setTblGrid(tblGrid);
                    int[] colPos = tableProperties.getColumnPos();
                    for (int i = 1; i <= cssTable.numEffCols(); ++i) {
                        TblGridCol tblGridCol = Context.getWmlObjectFactory().createTblGridCol();
                        tblGrid.getGridCol().add(tblGridCol);
                        log.info((Object)("colpos=" + colPos[i]));
                        tblGridCol.setW(BigInteger.valueOf(colPos[i] - colPos[i - 1]));
                    }
                } else if (box instanceof TableRowBox) {
                    log.info((Object)".. processing <tr");
                    Tr tr = Context.getWmlObjectFactory().createTr();
                    contentContext.add(tr);
                    this.paraStillEmpty = true;
                    contentContext = tr.getContent();
                } else if (box instanceof TableCellBox) {
                    int colspan;
                    log.info((Object)".. processing <td");
                    TableCellBox tcb = (TableCellBox)box;
                    TableSectionBox section = tcb.getSection();
                    int effCol = tcb.getTable().colToEffCol(tcb.getCol());
                    if (effCol != 0) {
                        TableCellBox prevCell = section.cellAt(tcb.getRow(), tcb.getCol() - 1);
                        log.info((Object)("Got prevCell for " + tcb.getRow() + ", " + tcb.getCol()));
                        log.info((Object)("it is  " + prevCell.getRow() + ", " + prevCell.getCol()));
                        if (prevCell.getRow() < tcb.getRow() && prevCell.getStyle() != null && prevCell.getStyle().getRowSpan() > 1) {
                            Tc dummy = Context.getWmlObjectFactory().createTc();
                            contentContext.add(dummy);
                            TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
                            dummy.setTcPr(tcPr);
                            TcPrInner.VMerge vm = Context.getWmlObjectFactory().createTcPrInnerVMerge();
                            tcPr.setVMerge(vm);
                            this.setCellWidthAuto(tcPr);
                            dummy.getContent().add(new P());
                        }
                    }
                    Tc tc = Context.getWmlObjectFactory().createTc();
                    contentContext.add(tc);
                    contentContext = tc.getContent();
                    this.currentP = Context.getWmlObjectFactory().createP();
                    contentContext.add(this.currentP);
                    this.paraStillEmpty = true;
                    TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
                    tc.setTcPr(tcPr);
                    if (tcb.getStyle().getRowSpan() > 1) {
                        TcPrInner.VMerge vm = Context.getWmlObjectFactory().createTcPrInnerVMerge();
                        vm.setVal("restart");
                        tcPr.setVMerge(vm);
                    }
                    TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
                    tblW.setW(BigInteger.valueOf(tableProperties.getColumnWidth(effCol + 1)));
                    tblW.setType("dxa");
                    tcPr.setTcW(tblW);
                    effCol = tcb.getTable().colToEffCol(tcb.getCol() + tcb.getStyle().getColSpan());
                    int numEffCols = tcb.getTable().numEffCols();
                    if (effCol < numEffCols) {
                        TableCellBox nextCell = tcb.getSection().cellAt(tcb.getRow(), effCol);
                        if (nextCell == null) {
                            throw new Docx4JException("XHTML table import: Null nextCell for row " + tcb.getRow() + ", col " + tcb.getCol());
                        }
                        log.info((Object)("Got nextCell for " + tcb.getRow() + ", " + tcb.getCol()));
                        log.info((Object)("it is  " + nextCell.getRow() + ", " + nextCell.getCol()));
                        if (nextCell.getRow() < tcb.getRow() && nextCell.getTable().colToEffCol(nextCell.getCol() + nextCell.getStyle().getColSpan()) == numEffCols) {
                            log.info((Object)("it has rowspan  " + nextCell.getStyle().getRowSpan()));
                            Tc dummy = Context.getWmlObjectFactory().createTc();
                            contentContext.add(dummy);
                            TcPr tcPr2 = Context.getWmlObjectFactory().createTcPr();
                            dummy.setTcPr(tcPr2);
                            TcPrInner.VMerge vm = Context.getWmlObjectFactory().createTcPrInnerVMerge();
                            tcPr2.setVMerge(vm);
                            this.setCellWidthAuto(tcPr2);
                            dummy.getContent().add(new P());
                        }
                    }
                    if ((colspan = tcb.getStyle().getColSpan()) > 1) {
                        if (tc.getTcPr() != null) {
                            log.warn((Object)"Trying to add GridSpan, when we've already added VMerge");
                        }
                        TcPr tcPr2 = Context.getWmlObjectFactory().createTcPr();
                        tc.setTcPr(tcPr2);
                        TcPrInner.GridSpan gs = Context.getWmlObjectFactory().createTcPrInnerGridSpan();
                        gs.setVal(BigInteger.valueOf(colspan));
                        tcPr2.setGridSpan(gs);
                        this.setCellWidthAuto(tcPr2);
                    }
                } else {
                    if (contentContext.size() > 0 && this.paraStillEmpty) {
                        contentContext.remove(contentContext.size() - 1);
                    }
                    this.currentP = Context.getWmlObjectFactory().createP();
                    contentContext.add(this.currentP);
                    this.paraStillEmpty = true;
                    this.currentP.setPPr(this.addParagraphProperties(cssMap));
                    if (e.getNodeName().equals("li")) {
                        this.addNumbering(e, cssMap);
                    } else if (e.getNodeName().equals("img")) {
                        this.addImage(e);
                    }
                }
            }
            log.info((Object)("Processing children of " + box.getElement().getNodeName()));
            switch (blockBox.getChildrenContentType()) {
                case 2: {
                    log.info((Object)".. which are BlockBox.CONTENT_BLOCK");
                    for (Object o : ((BlockBox)box).getChildren()) {
                        this.traverse((Box)o, contentContext, tableProperties);
                    }
                    break;
                }
                case 1: {
                    log.info((Object)".. which are BlockBox.CONTENT_INLINE");
                    if (((BlockBox)box).getInlineContent() == null) break;
                    for (Object o : ((BlockBox)box).getInlineContent()) {
                        if (o instanceof InlineBox) {
                            this.processInlineBox((InlineBox)o, contentContext);
                            continue;
                        }
                        if (o instanceof BlockBox) {
                            this.traverse((Box)o, contentContext, tableProperties);
                            continue;
                        }
                        log.info((Object)("What to do with " + box.getClass().getName()));
                    }
                    break;
                }
            }
            log.info((Object)("Done processing children of " + box.getClass().getName()));
            if (e.getNodeName().equals("table")) {
                this.paraStillEmpty = false;
            }
        } else if (box instanceof AnonymousBlockBox) {
            log.info((Object)"AnonymousBlockBox");
        }
    }

    private void setCellWidthAuto(TcPr tcPr) {
        TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
        tblW.setW(BigInteger.ZERO);
        tblW.setType("auto");
        tcPr.setTcW(tblW);
    }

    private void addImage(Element e) {
        System.out.println("Detected an image!!! " + e.getAttribute("src"));
        Docx4jUserAgent docx4jUserAgent = this.renderer.getDocx4jUserAgent();
        Docx4JFSImage docx4JFSImage = docx4jUserAgent.getDocx4JImageResource(e.getAttribute("src"));
        Inline inline = null;
        try {
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart(this.wordMLPackage, docx4JFSImage.getBytes());
            inline = imagePart.createImageInline(null, null, 0, 1, false);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        R run = Context.getWmlObjectFactory().createR();
        this.currentP.getContent().add(run);
        Drawing drawing = Context.getWmlObjectFactory().createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        this.paraStillEmpty = false;
    }

    private void addNumbering(Element e, Map<String, CSSValue> cssMap) {
        Numbering.Num num = null;
        try {
            if (cssMap.get("list-style-type").getCssText().equals("decimal")) {
                num = this.listHelper.getOrderedList(this.ndp);
            }
            if (cssMap.get("list-style-type").getCssText().equals("disc")) {
                num = this.listHelper.getUnorderedList(this.ndp);
            }
        }
        catch (JAXBException je) {
            je.printStackTrace();
            log.error((Object)e);
        }
        if (num == null) {
            log.warn((Object)("No support for list-style-type: " + cssMap.get("list-style-type").getCssText()));
        } else {
            this.paraStillEmpty = false;
            PPrBase.NumPr numPr = Context.getWmlObjectFactory().createPPrBaseNumPr();
            this.currentP.getPPr().setNumPr(numPr);
            PPrBase.NumPr.NumId numIdElement = Context.getWmlObjectFactory().createPPrBaseNumPrNumId();
            numPr.setNumId(numIdElement);
            numIdElement.setVal(num.getNumId());
            PPrBase.NumPr.Ilvl ilvlElement = Context.getWmlObjectFactory().createPPrBaseNumPrIlvl();
            numPr.setIlvl(ilvlElement);
            ilvlElement.setVal(BigInteger.valueOf(0L));
            this.currentP.getPPr().setInd(null);
        }
    }

    private void processInlineBox(InlineBox inlineBox, List<Object> contentContext) {
        log.info((Object)inlineBox.toString());
        if (this.inAlreadyProcessed) {
            log.info((Object)".. already done.");
            return;
        }
        InlineBox s = inlineBox;
        if (s.getStyle() == null) {
            log.error((Object)"getStyle returned null!");
        }
        Map<String, CSSValue> cssMap = this.getCascadedProperties(s.getStyle());
        String debug = "<UNKNOWN Styleable";
        if (s.getElement() != null) {
            debug = "<" + s.getElement().getNodeName();
            if (s.getElement().getNodeName().equals("a")) {
                log.info((Object)"Ha!  found a hyperlink. ");
                if (inlineBox.isStartsHere()) {
                    P.Hyperlink h = null;
                    String linkText = inlineBox.getElement().getTextContent();
                    log.info((Object)linkText);
                    if (linkText != null && !linkText.trim().equals("")) {
                        h = this.createHyperlink(s.getElement().getAttribute("href"), this.addRunProperties(cssMap), linkText, this.rp);
                        this.currentP.getContent().add(h);
                        this.inAlreadyProcessed = true;
                        return;
                    }
                    h = this.createHyperlink(s.getElement().getAttribute("href"), this.addRunProperties(cssMap), s.getElement().getAttribute("href"), this.rp);
                    this.currentP.getContent().add(h);
                    return;
                }
                if (inlineBox.isEndsHere()) {
                    this.inAlreadyProcessed = false;
                }
            } else if (s.getElement().getNodeName().equals("p")) {
                log.debug((Object)"p in inline");
                this.currentP = Context.getWmlObjectFactory().createP();
                if (this.paraStillEmpty) {
                    contentContext.remove(contentContext.size() - 1);
                }
                contentContext.add(this.currentP);
                this.paraStillEmpty = true;
                this.currentP.setPPr(this.addParagraphProperties(cssMap));
            }
        }
        if (s.getStyle() != null) {
            debug = debug + " " + s.getStyle().toStringMine();
        }
        log.info((Object)debug);
        this.processInlineBoxContent(inlineBox, (Styleable)s, cssMap);
    }

    private void processInlineBoxContent(InlineBox inlineBox, Styleable s, Map<String, CSSValue> cssMap) {
        if (inlineBox.getTextNode() == null) {
            if (s.getElement().getNodeName().equals("br")) {
                R run = Context.getWmlObjectFactory().createR();
                this.currentP.getContent().add(run);
                run.getContent().add(Context.getWmlObjectFactory().createBr());
            } else {
                log.info((Object)"InlineBox has no TextNode, so skipping");
            }
        } else {
            log.info((Object)inlineBox.getTextNode().getTextContent());
            String theText = inlineBox.getTextNode().getTextContent();
            log.info((Object)("Processing " + theText));
            this.paraStillEmpty = false;
            R run = Context.getWmlObjectFactory().createR();
            Text text = Context.getWmlObjectFactory().createText();
            text.setValue(theText);
            if (theText.startsWith(" ") || theText.endsWith(" ")) {
                text.setSpace("preserve");
            }
            run.getContent().add(text);
            this.currentP.getContent().add(run);
            run.setRPr(this.addRunProperties(cssMap));
        }
    }

    private PPr addParagraphProperties(Map cssMap) {
        PPr pPr = Context.getWmlObjectFactory().createPPr();
        for (Object o : cssMap.keySet()) {
            CSSValue cssValue;
            String cssName = (String)o;
            Property p = PropertyFactory.createPropertyFromCssName(cssName, cssValue = (CSSValue)cssMap.get(cssName));
            if (p == null || !(p instanceof AbstractParagraphProperty)) continue;
            ((AbstractParagraphProperty)p).set(pPr);
        }
        return pPr;
    }

    RPr addRunProperties(Map cssMap) {
        RPr rPr = Context.getWmlObjectFactory().createRPr();
        for (Object o : cssMap.keySet()) {
            CSSValue cssValue;
            String cssName = (String)o;
            Property p = PropertyFactory.createPropertyFromCssName(cssName, cssValue = (CSSValue)cssMap.get(cssName));
            if (p == null || !(p instanceof AbstractRunProperty)) continue;
            ((AbstractRunProperty)p).set(rPr);
        }
        return rPr;
    }

    private P.Hyperlink createHyperlink(String url, RPr rPr, String linkText, RelationshipsPart rp) {
        try {
            ObjectFactory factory = new ObjectFactory();
            Relationship rel = factory.createRelationship();
            rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
            rel.setTarget(url);
            rel.setTargetMode("External");
            rp.addRelationship(rel);
            String hpl = "<w:hyperlink r:id=\"" + rel.getId() + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" " + "xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" >" + "<w:r>" + "<w:t>" + linkText + "</w:t>" + "</w:r>" + "</w:hyperlink>";
            P.Hyperlink hyperlink = (P.Hyperlink)XmlUtils.unmarshalString(hpl);
            R r = (R)hyperlink.getContent().get(0);
            r.setRPr(rPr);
            if (hyperlinkStyleId != null) {
                RStyle rStyle = Context.getWmlObjectFactory().createRStyle();
                rStyle.setVal(hyperlinkStyleId);
                rPr.setRStyle(rStyle);
            }
            return hyperlink;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final class TableProperties {
        private TableBox tableBox;
        private int[] colPos;
        boolean isFixedWidth;

        public TableBox getTableBox() {
            return this.tableBox;
        }

        public void setTableBox(TableBox tableBox) {
            this.tableBox = tableBox;
            this.colPos = tableBox.getColumnPos();
        }

        public int[] getColumnPos() {
            return this.colPos;
        }

        public int getColumnWidth(int col) {
            return this.colPos[col] - this.colPos[col - 1];
        }

        public boolean isFixedWidth() {
            return this.isFixedWidth;
        }

        public void setFixedWidth(boolean isFixedWidth) {
            this.isFixedWidth = isFixedWidth;
        }
    }
}

