/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.P;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtContentBlock;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Containerization {
    private static Logger log = Logger.getLogger(Containerization.class);
    public static final String TAG_SHADING = "XSLT_Shd";
    public static final String TAG_BORDERS = "XSLT_PBdr";
    public static final String TAG_RPR = "XSLT_RPr";

    public static void groupAdjacentBorders(Body body) {
        List<Object> bodyElts = body.getEGBlockLevelElts();
        List<Object> groupedContent = null;
        groupedContent = Containerization.groupBodyContent(bodyElts);
        if (groupedContent != null) {
            body.getEGBlockLevelElts().clear();
            body.getEGBlockLevelElts().addAll(groupedContent);
        }
    }

    private static void groupTable(Tbl table) {
        List<Object> cellElts = null;
        Tr tr = null;
        Tc tc = null;
        for (Object elemTr : table.getEGContentRowContent()) {
            if (elemTr instanceof JAXBElement) {
                elemTr = ((JAXBElement)elemTr).getValue();
            }
            if (!(elemTr instanceof Tr) || (tr = (Tr)elemTr).getEGContentCellContent() == null) continue;
            for (Object elemCe : tr.getEGContentCellContent()) {
                if (elemCe instanceof JAXBElement) {
                    elemCe = ((JAXBElement)elemCe).getValue();
                }
                if (!(elemCe instanceof Tc) || (tc = (Tc)elemCe).getEGBlockLevelElts() == null || (cellElts = Containerization.groupBodyContent(tc.getEGBlockLevelElts())) == null) continue;
                tc.getEGBlockLevelElts().clear();
                tc.getEGBlockLevelElts().addAll(cellElts);
            }
        }
    }

    private static List<Object> groupBodyContent(List<Object> bodyElts) {
        ArrayList<Object> resultElts = new ArrayList<Object>();
        List<Object> paragraphElts = null;
        SdtBlock sdtBorders = null;
        SdtBlock sdtShading = null;
        PPrBase.PBdr lastBorders = null;
        PPrBase.PBdr currentBorders = null;
        CTShd lastShading = null;
        CTShd currentShading = null;
        P paragraph = null;
        for (Object o : bodyElts) {
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            if (o instanceof P) {
                paragraph = (P)o;
                paragraphElts = Containerization.groupRuns(paragraph.getParagraphContent());
                paragraph.getParagraphContent().clear();
                if (paragraphElts != null) {
                    paragraph.getParagraphContent().addAll(paragraphElts);
                }
                currentBorders = null;
                currentShading = null;
                if (paragraph.getPPr() != null) {
                    currentBorders = paragraph.getPPr().getPBdr();
                    currentShading = paragraph.getPPr().getShd();
                }
                if (Containerization.bordersChanged(currentBorders, lastBorders)) {
                    if (currentBorders == null) {
                        sdtBorders = null;
                    } else {
                        sdtBorders = Containerization.createSdt(TAG_BORDERS);
                        resultElts.add(sdtBorders);
                    }
                }
                if (Containerization.shadingChanged(currentShading, lastShading)) {
                    if (currentShading == null) {
                        sdtShading = null;
                    } else {
                        sdtShading = Containerization.createSdt(TAG_SHADING);
                        if (sdtBorders != null) {
                            sdtBorders.getSdtContent().getContent().add(sdtShading);
                        } else {
                            resultElts.add(sdtShading);
                        }
                    }
                }
            } else if (o instanceof Tbl) {
                Containerization.groupTable((Tbl)o);
            }
            if (sdtShading != null) {
                sdtShading.getSdtContent().getContent().add(o);
            } else if (sdtBorders != null) {
                sdtBorders.getSdtContent().getContent().add(o);
            } else {
                resultElts.add(o);
            }
            lastBorders = currentBorders;
            lastShading = currentShading;
        }
        return resultElts;
    }

    private static List<Object> groupRuns(List<Object> paragraphElts) {
        ArrayList<Object> resultElts = new ArrayList<Object>();
        SdtBlock currentBlock = null;
        CTBorder lastBorder = null;
        CTBorder currentBorder = null;
        R run = null;
        for (Object o : paragraphElts) {
            if (o instanceof R) {
                run = (R)o;
                currentBorder = null;
                if (run.getRPr() != null) {
                    currentBorder = run.getRPr().getBdr();
                }
                if (Containerization.borderChanged(currentBorder, lastBorder)) {
                    Containerization.appendRun(currentBlock, resultElts);
                    currentBlock = null;
                    if (currentBorder != null) {
                        currentBlock = Containerization.createSdt(TAG_RPR, run.getRPr());
                    }
                }
            }
            if (currentBlock != null) {
                currentBlock.getSdtContent().getContent().add(o);
            } else {
                resultElts.add(o);
            }
            lastBorder = currentBorder;
        }
        Containerization.appendRun(currentBlock, resultElts);
        return resultElts;
    }

    private static void appendRun(SdtBlock currentBlock, List<Object> resultElts) {
        List<Object> blkElements = null;
        R run = null;
        RPr blockRPr = null;
        if (currentBlock != null) {
            blkElements = currentBlock.getSdtContent().getContent();
            if (blkElements.size() == 1) {
                resultElts.add(blkElements.get(0));
            } else {
                resultElts.add(currentBlock);
                blockRPr = Containerization.findBlockRPr(currentBlock);
                for (Object elem : blkElements) {
                    if (!(elem instanceof R) || (run = (R)elem).getRPr() == null) continue;
                    run.getRPr().setBdr(null);
                    if (Containerization.shadingChanged(blockRPr.getShd(), run.getRPr().getShd())) continue;
                    run.getRPr().setShd(null);
                }
            }
        }
    }

    private static RPr findBlockRPr(SdtBlock currentBlock) {
        for (Object obj : currentBlock.getSdtPr().getRPrOrAliasOrLock()) {
            if (!(obj instanceof RPr)) continue;
            return (RPr)obj;
        }
        return null;
    }

    private static SdtBlock createSdt(String tagVal) {
        return Containerization.createSdt(tagVal, null);
    }

    private static SdtBlock createSdt(String tagVal, RPr rPr) {
        SdtBlock sdtBlock = Context.getWmlObjectFactory().createSdtBlock();
        SdtPr sdtPr = Context.getWmlObjectFactory().createSdtPr();
        sdtBlock.setSdtPr(sdtPr);
        SdtContentBlock sdtContent = Context.getWmlObjectFactory().createSdtContentBlock();
        sdtBlock.setSdtContent(sdtContent);
        Tag tag = Context.getWmlObjectFactory().createTag();
        tag.setVal(tagVal);
        sdtPr.setTag(tag);
        if (rPr != null) {
            sdtPr.getRPrOrAliasOrLock().add(XmlUtils.deepCopy(rPr));
        }
        return sdtBlock;
    }

    private static boolean bordersChanged(PPrBase.PBdr currentBorders, PPrBase.PBdr lastBorders) {
        if (currentBorders != lastBorders) {
            if (currentBorders != null && lastBorders != null) {
                return Containerization.borderChanged(currentBorders.getTop(), lastBorders.getTop()) || Containerization.borderChanged(currentBorders.getBottom(), lastBorders.getBottom());
            }
            return true;
        }
        return false;
    }

    private static boolean borderChanged(CTBorder currentBorder, CTBorder lastBorder) {
        if (currentBorder != lastBorder) {
            if (currentBorder != null && lastBorder != null) {
                return !currentBorder.getVal().equals((Object)lastBorder.getVal());
            }
            return true;
        }
        return false;
    }

    private static boolean shadingChanged(CTShd currentShading, CTShd lastShading) {
        if (currentShading == null && lastShading == null) {
            return false;
        }
        if (currentShading == null && lastShading != null) {
            return true;
        }
        if (currentShading != null && lastShading == null) {
            return true;
        }
        if (currentShading.getFill() == null || lastShading.getFill() == null) {
            return true;
        }
        return !currentShading.getFill().equals(lastShading.getFill());
    }
}

