/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.ModelConverter;
import org.docx4j.model.Model;
import org.docx4j.model.TransformState;
import org.docx4j.model.table.Cell;
import org.docx4j.model.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OasisTableWriter
extends ModelConverter {
    private static final Logger logger = Logger.getLogger(OasisTableWriter.class);

    public Node toNode(Model tableModel, TransformState state) throws TransformerException {
        TableModel table = (TableModel)tableModel;
        logger.debug((Object)("Table asXML:\n" + table.debugStr()));
        Document doc = XmlUtils.neww3cDomDocument();
        DocumentFragment docfrag = doc.createDocumentFragment();
        Element tbls = doc.createElement("tables");
        tbls.setAttribute("id", "table");
        docfrag.appendChild(tbls);
        Element tbl = doc.createElement("table");
        tbl.setAttribute("frame", "all");
        tbls.appendChild(tbl);
        Element title = doc.createElement("title");
        tbl.appendChild(title);
        int cols = table.getColCount();
        Element tgroup = doc.createElement("tgroup");
        tbl.appendChild(tgroup);
        tgroup.setAttribute("cols", String.valueOf(cols));
        for (int i = 0; i < cols; ++i) {
            String s = String.valueOf(i);
            Element colspec = doc.createElement("colspec");
            tgroup.appendChild(colspec);
            colspec.setAttribute("colnum", s);
            colspec.setAttribute("colname", table.getColName(i));
        }
        Element tbody = doc.createElement("tbody");
        tgroup.appendChild(tbody);
        for (List<Cell> rows : table.getCells()) {
            Element row = doc.createElement("row");
            tbody.appendChild(row);
            for (Cell cell : rows) {
                if (cell.isDummy()) continue;
                int col = cell.getColumn();
                String start = table.getColName(col);
                String end = table.getColName(col + cell.getExtraCols());
                Element cellNode = doc.createElement("entry");
                row.appendChild(cellNode);
                cellNode.setAttribute("namest", start);
                cellNode.setAttribute("nameend", end);
                int morerows = cell.getExtraRows();
                if (morerows > 0) {
                    cellNode.setAttribute("morerows", String.valueOf(morerows));
                }
                XmlUtils.treeCopy(cell.getContent().getChildNodes(), (Node)cellNode);
            }
        }
        return docfrag;
    }
}

