/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out;

import java.util.List;
import org.apache.log4j.Logger;
import org.docx4j.wml.Body;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.Br;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;
import org.docx4j.wml.STBrType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageBreak {
    private static Logger log = Logger.getLogger(PageBreak.class);

    public static void movePageBreaks(Body body) {
        List<Object> elts = body.getEGBlockLevelElts();
        for (Object o : elts) {
            if (!(o instanceof P)) continue;
            PageBreak.updateParagraph((P)o);
        }
    }

    private static void updateParagraph(P paragraph) {
        boolean containsPageBreak = PageBreak.checkPageBreak(paragraph.getParagraphContent());
        if (containsPageBreak) {
            if (paragraph.getPPr() == null) {
                paragraph.setPPr(new PPr());
            }
            paragraph.getPPr().setPageBreakBefore(new BooleanDefaultTrue());
        }
    }

    private static boolean checkPageBreak(List<Object> content) {
        int foundIdx = -1;
        Object ce = null;
        if (content != null && !content.isEmpty()) {
            for (int i = 0; foundIdx == -1 && i < content.size(); ++i) {
                ce = content.get(i);
                if (ce instanceof R) {
                    if (!PageBreak.checkPageBreak(((R)ce).getRunContent())) continue;
                    if (((R)ce).getRunContent() == null || ((R)ce).getRunContent().isEmpty()) {
                        foundIdx = i;
                        continue;
                    }
                    return true;
                }
                if (!(ce instanceof Br) || !STBrType.PAGE.equals((Object)((Br)ce).getType())) continue;
                foundIdx = i;
            }
            if (foundIdx > -1) {
                content.remove(foundIdx);
            }
        }
        return foundIdx > -1;
    }
}

