/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.Containerization;
import org.docx4j.convert.out.Converter;
import org.docx4j.convert.out.PageBreak;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.convert.out.html.HTMLConversionImageHandler;
import org.docx4j.convert.out.html.SymbolWriter;
import org.docx4j.convert.out.html.TableWriter;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.SymbolModel;
import org.docx4j.model.TransformState;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.model.table.TableModel;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Document;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RPr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlExporterNG2
extends AbstractHtmlExporter {
    protected static Logger log = Logger.getLogger(HtmlExporterNG2.class);
    static Templates xslt;

    public static void log(String message) {
        log.info((Object)message);
    }

    public static void setXslt(Templates xslt) {
        HtmlExporterNG2.xslt = xslt;
    }

    @Override
    public void output(Result result) throws Docx4JException {
        if (this.wmlPackage == null) {
            throw new Docx4JException("Must setWmlPackage");
        }
        if (this.htmlSettings == null) {
            log.debug((Object)"Using empty HtmlSettings");
            this.htmlSettings = new AbstractHtmlExporter.HtmlSettings();
        }
        try {
            this.html(this.wmlPackage, result, this.htmlSettings);
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to create HTML output", e);
        }
    }

    @Override
    @Deprecated
    public void html(WordprocessingMLPackage wmlPackage, Result result, String imageDirPath) throws Exception {
        this.html(wmlPackage, result, true, imageDirPath);
    }

    @Override
    @Deprecated
    public void html(WordprocessingMLPackage wmlPackage, Result result, boolean fontFamilyStack, String imageDirPath) throws Exception {
        AbstractHtmlExporter.HtmlSettings htmlSettings = new AbstractHtmlExporter.HtmlSettings();
        htmlSettings.setFontFamilyStack(fontFamilyStack);
        if (imageDirPath == null) {
            imageDirPath = "";
        }
        htmlSettings.setImageDirPath(imageDirPath);
        this.html(wmlPackage, result, htmlSettings);
    }

    @Override
    public void html(WordprocessingMLPackage wmlPackage, Result result, AbstractHtmlExporter.HtmlSettings htmlSettings) throws Exception {
        MainDocumentPart mdp = wmlPackage.getMainDocumentPart();
        Document tmpDoc = (Document)XmlUtils.deepCopy(wmlPackage.getMainDocumentPart().getJaxbElement());
        Containerization.groupAdjacentBorders(tmpDoc.getBody());
        PageBreak.movePageBreaks(tmpDoc.getBody());
        org.w3c.dom.Document doc = XmlUtils.marshaltoW3CDomDocument(tmpDoc);
        if (htmlSettings == null) {
            htmlSettings = new AbstractHtmlExporter.HtmlSettings();
        }
        boolean privateImageHandler = false;
        if (htmlSettings.getImageHandler() == null) {
            htmlSettings.setImageHandler(new HTMLConversionImageHandler(htmlSettings.getImageDirPath(), htmlSettings.getImageTargetUri(), htmlSettings.isImageIncludeUUID()));
            privateImageHandler = true;
        }
        if (htmlSettings.getFontMapper() == null) {
            htmlSettings.setFontMapper(wmlPackage.getFontMapper());
            log.debug((Object)"FontMapper set.. ");
        }
        htmlSettings.setWmlPackage(wmlPackage);
        HashMap<String, TransformState> modelStates = new HashMap<String, TransformState>();
        htmlSettings.getSettings().put("modelStates", modelStates);
        Converter.getInstance().registerModelConverter("w:tbl", new TableWriter());
        Converter.getInstance().registerModelConverter("w:sym", new SymbolWriter());
        modelStates.put("w:tbl", new TableModel.TableModelTransformState());
        modelStates.put("w:sym", new SymbolModel.SymbolModelTransformState());
        modelStates.put("footnoteNumber", new FootnoteState());
        modelStates.put("endnoteNumber", new EndnoteState());
        Converter.getInstance().start(wmlPackage);
        log.debug((Object)"About to transform...");
        XmlUtils.transform(doc, xslt, htmlSettings.getSettings(), result);
        if (privateImageHandler) {
            htmlSettings.getSettings().remove("imageHandler");
        }
        log.info((Object)"wordDocument transformed to xhtml ..");
    }

    public static DocumentFragment notImplemented(NodeIterator nodes, String message) {
        org.w3c.dom.Node n = nodes.nextNode();
        log.warn((Object)("NOT IMPLEMENTED: support for " + n.getNodeName() + "; " + message));
        if (log.isDebugEnabled()) {
            if (message == null) {
                message = "";
            }
            log.debug((Object)XmlUtils.w3CDomNodeToString(n));
            return HtmlExporterNG2.message("NOT IMPLEMENTED: support for " + n.getNodeName() + " - " + message);
        }
        return null;
    }

    public static DocumentFragment message(String message) {
        if (!log.isDebugEnabled()) {
            return null;
        }
        String html = "<div style=\"color:red\" >" + message + "</div>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        StringReader reader = new StringReader(html);
        InputSource inputSource = new InputSource(reader);
        org.w3c.dom.Document doc = null;
        try {
            doc = dbf.newDocumentBuilder().parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reader.close();
        DocumentFragment docfrag = doc.createDocumentFragment();
        docfrag.appendChild(doc.getDocumentElement());
        return docfrag;
    }

    public static DocumentFragment createBlockForSdt(WordprocessingMLPackage wmlPackage, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, String tag) {
        DocumentFragment docfrag = HtmlExporterNG2.createBlock(wmlPackage, pPrNodeIt, pStyleVal, childResults, "div");
        return docfrag;
    }

    public static DocumentFragment createBlockForPPr(WordprocessingMLPackage wmlPackage, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults) {
        return HtmlExporterNG2.createBlock(wmlPackage, pPrNodeIt, pStyleVal, childResults, "p");
    }

    private static DocumentFragment createBlock(WordprocessingMLPackage wmlPackage, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, String htmlElementName) {
        StyleTree styleTree = wmlPackage.getMainDocumentPart().getStyleTree();
        if (pStyleVal == null || pStyleVal.equals("")) {
            pStyleVal = wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultParagraphStyle().getStyleId();
        }
        log.debug((Object)("style '" + pStyleVal));
        try {
            org.w3c.dom.Node n;
            PPr pPr = null;
            if (pPrNodeIt != null && (n = pPrNodeIt.nextNode()) != null) {
                Unmarshaller u = Context.jc.createUnmarshaller();
                u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                Object jaxb = u.unmarshal(n);
                try {
                    pPr = (PPr)jaxb;
                }
                catch (ClassCastException e) {
                    log.error((Object)("Couldn't cast " + jaxb.getClass().getName() + " to PPr!"));
                }
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            org.w3c.dom.Document document = factory.newDocumentBuilder().newDocument();
            Element xhtmlBlock = document.createElement(htmlElementName);
            document.appendChild(xhtmlBlock);
            if (log.isDebugEnabled() && pPr != null) {
                log.debug((Object)XmlUtils.marshaltoString((Object)pPr, true, true));
            }
            log.debug((Object)pStyleVal);
            Tree<StyleTree.AugmentedStyle> pTree = styleTree.getParagraphStylesTree();
            Node<StyleTree.AugmentedStyle> asn = pTree.get(pStyleVal);
            xhtmlBlock.setAttribute("class", StyleTree.getHtmlClassAttributeValue(pTree, asn));
            boolean ignoreBorders = htmlElementName.equals("p");
            if (pPr != null) {
                StringBuffer inlineStyle = new StringBuffer();
                HtmlExporterNG2.createCss(wmlPackage, pPr, inlineStyle, ignoreBorders);
                if (!inlineStyle.toString().equals("")) {
                    xhtmlBlock.setAttribute("style", inlineStyle.toString());
                }
            }
            org.w3c.dom.Node n2 = childResults.nextNode();
            do {
                if (n2.getNodeType() == 9) {
                    log.debug((Object)"handling DOCUMENT_NODE");
                    NodeList nodes = n2.getChildNodes();
                    if (nodes == null) continue;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        if (nodes.item(i).getLocalName().equals("span") && !nodes.item(i).hasChildNodes()) {
                            log.debug((Object)".. ignoring <span/> ");
                            continue;
                        }
                        XmlUtils.treeCopy(nodes.item(i), (org.w3c.dom.Node)xhtmlBlock);
                    }
                } else {
                    XmlUtils.treeCopy(n2, (org.w3c.dom.Node)xhtmlBlock);
                }
            } while ((n2 = childResults.nextNode()) != null);
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
            log.error((Object)e);
            return null;
        }
    }

    public static DocumentFragment createBlockForRPr(WordprocessingMLPackage wmlPackage, String pStyleVal, NodeIterator rPrNodeIt, NodeIterator childResults) {
        StyleTree styleTree = wmlPackage.getMainDocumentPart().getStyleTree();
        try {
            Unmarshaller u = Context.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            Object jaxb = u.unmarshal(rPrNodeIt.nextNode());
            RPr rPr = null;
            try {
                rPr = (RPr)jaxb;
            }
            catch (ClassCastException e) {
                log.error((Object)("Couldn't cast " + jaxb.getClass().getName() + " to RPr!"));
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            org.w3c.dom.Document document = factory.newDocumentBuilder().newDocument();
            Element span = document.createElement("span");
            document.appendChild(span);
            if (rPr == null) {
                Text err = document.createTextNode("Couldn't cast " + jaxb.getClass().getName() + " to PPr!");
                span.appendChild(err);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)XmlUtils.marshaltoString((Object)rPr, true, true));
                }
                if (pStyleVal == null || pStyleVal.equals("")) {
                    pStyleVal = wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultParagraphStyle().getStyleId();
                }
                if (rPr.getRStyle() != null) {
                    String rStyleVal = rPr.getRStyle().getVal();
                    Tree<StyleTree.AugmentedStyle> cTree = styleTree.getCharacterStylesTree();
                    Node<StyleTree.AugmentedStyle> asn = cTree.get(rStyleVal);
                    if (asn == null) {
                        log.warn((Object)("No style node for: " + rStyleVal));
                    } else {
                        span.setAttribute("class", StyleTree.getHtmlClassAttributeValue(cTree, asn));
                    }
                }
                StringBuffer inlineStyle = new StringBuffer();
                HtmlExporterNG2.createCss(wmlPackage, rPr, inlineStyle);
                if (!inlineStyle.toString().equals("")) {
                    span.setAttribute("style", inlineStyle.toString());
                }
                org.w3c.dom.Node n = childResults.nextNode();
                XmlUtils.treeCopy(n, (org.w3c.dom.Node)span);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
            log.error((Object)e);
            return null;
        }
    }

    public static int getNextFootnoteNumber(HashMap<String, TransformState> modelStates) {
        FootnoteState fs = (FootnoteState)modelStates.get("footnoteNumber");
        return fs.getNextFootnoteNumber();
    }

    public static int getNextEndnoteNumber(HashMap<String, TransformState> modelStates) {
        EndnoteState fs = (EndnoteState)modelStates.get("endnoteNumber");
        return fs.getNextEndnoteNumber();
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/convert/out/html/docx2xhtmlNG2.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static class EndnoteState
    implements TransformState {
        int endnoteNumber = 0;

        public int getNextEndnoteNumber() {
            ++this.endnoteNumber;
            return this.endnoteNumber;
        }
    }

    public static class FootnoteState
    implements TransformState {
        int footnoteNumber = 0;

        public int getNextFootnoteNumber() {
            ++this.footnoteNumber;
            return this.footnoteNumber;
        }
    }
}

