/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.html.SdtTagHandler;
import org.docx4j.jaxb.Context;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.SdtPr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class SdtWriter {
    private static Logger log = Logger.getLogger(SdtWriter.class);
    private static Map<String, SdtTagHandler> handlers = new HashMap<String, SdtTagHandler>();
    static IdentityHandler identity = new IdentityHandler();

    public static void registerTagHandler(String key, SdtTagHandler handler) {
        handlers.put(key, handler);
    }

    public static Node toNode(WordprocessingMLPackage wmlPackage, NodeIterator sdtPrNodeIt, NodeIterator childResults) throws TransformerException {
        SdtTagHandler handler;
        SdtPr sdtPr;
        Node result = null;
        try {
            Node n = sdtPrNodeIt.nextNode();
            sdtPr = (SdtPr)XmlUtils.unmarshal(n, Context.jc, SdtPr.class);
        }
        catch (JAXBException e1) {
            throw new TransformerException("Missing or broken w:sdtPr", e1);
        }
        if (sdtPr.getTag() == null) {
            if (handlers.get("*") != null) {
                SdtTagHandler handler2 = handlers.get("*");
                result = handler2.toNode(wmlPackage, null, null, childResults);
            } else {
                result = identity.toNode(wmlPackage, null, null, childResults);
            }
            return result;
        }
        HashMap<String, String> map = QueryString.parseQueryString(sdtPr.getTag().getVal(), true);
        for (String key : map.keySet()) {
            handler = handlers.get(key);
            if (handler == null) {
                log.error((Object)("No model registered for sdt tag key " + key + "; ignoring .."));
                continue;
            }
            log.debug((Object)("Using model " + handler.getClass().getName() + " for sdt tag key " + key));
            if (result == null) {
                result = handler.toNode(wmlPackage, sdtPr, map, childResults);
                continue;
            }
            result = handler.toNode(wmlPackage, sdtPr, map, result);
        }
        if (handlers.get("**") != null) {
            handler = handlers.get("**");
            result = result == null ? handler.toNode(wmlPackage, sdtPr, map, childResults) : handler.toNode(wmlPackage, sdtPr, map, result);
        }
        if (result == null) {
            if (handlers.get("*") != null) {
                handler = handlers.get("*");
                result = handler.toNode(wmlPackage, sdtPr, map, childResults);
            } else {
                result = identity.toNode(wmlPackage, sdtPr, map, childResults);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullHandler
    extends SdtTagHandler {
        NullHandler() {
        }

        @Override
        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, NodeIterator childResults) throws TransformerException {
            return this.emptyFragment();
        }

        @Override
        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, Node resultSoFar) throws TransformerException {
            return this.emptyFragment();
        }

        private DocumentFragment emptyFragment() throws TransformerException {
            Document document;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                document = factory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new TransformerException(e);
            }
            return document.createDocumentFragment();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdentityHandler
    extends SdtTagHandler {
        IdentityHandler() {
        }

        @Override
        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, NodeIterator childResults) throws TransformerException {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document document = factory.newDocumentBuilder().newDocument();
                DocumentFragment docfrag = document.createDocumentFragment();
                return this.attachContents(docfrag, (Node)docfrag, childResults);
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }

        @Override
        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, Node resultSoFar) throws TransformerException {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document document = factory.newDocumentBuilder().newDocument();
                DocumentFragment docfrag = document.createDocumentFragment();
                return this.attachContents(docfrag, (Node)docfrag, resultSoFar);
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }
    }
}

