/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.pdf.viaXSLFO;

import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.ModelConverter;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.fop.fonts.Typeface;
import org.docx4j.model.Model;
import org.docx4j.model.SymbolModel;
import org.docx4j.model.TransformState;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SymbolWriter
extends ModelConverter {
    private static final Logger log = Logger.getLogger(SymbolWriter.class);

    public Node toNode(Model symbolModel, TransformState state) throws TransformerException {
        Document doc = XmlUtils.neww3cDomDocument();
        SymbolModel sm = (SymbolModel)symbolModel;
        String fontName = sm.getSym().getFont();
        String textValue = sm.getSym().getChar();
        PhysicalFont pf = this.wordMLPackage.getFontMapper().getFontMappings().get(fontName);
        char chValue = '\u0000';
        Typeface typeface = null;
        if (pf != null && (typeface = pf.getTypeface()) != null) {
            if (textValue.length() > 1) {
                try {
                    chValue = (char)Integer.parseInt(textValue, 16);
                }
                catch (NumberFormatException nfe) {
                    chValue = '\u0000';
                }
            } else {
                chValue = textValue.charAt(0);
            }
            if (chValue != '\u0000') {
                if (chValue > '\uf000') {
                    chValue = (char)(chValue - 61440);
                }
                if (typeface.mapChar(chValue) == '\u0000' && typeface.mapChar(chValue = (char)(chValue + 61440)) == '\u0000') {
                    chValue = '\u0000';
                }
                if (chValue != '\u0000') {
                    textValue = Character.toString(chValue);
                }
            }
        }
        Text theChar = doc.createTextNode(textValue);
        DocumentFragment docfrag = doc.createDocumentFragment();
        if (pf == null) {
            log.warn((Object)("No physical font present for:" + fontName));
            docfrag.appendChild(theChar);
        } else {
            Element foInline = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
            docfrag.appendChild(foInline);
            foInline.setAttribute("font-family", pf.getName());
            foInline.appendChild(theChar);
        }
        return docfrag;
    }
}

