/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.pdf.viaXSLFO;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.ModelConverter;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;
import org.docx4j.model.Model;
import org.docx4j.model.TransformState;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.table.BorderBottom;
import org.docx4j.model.properties.table.BorderLeft;
import org.docx4j.model.properties.table.BorderRight;
import org.docx4j.model.properties.table.BorderTop;
import org.docx4j.model.table.Cell;
import org.docx4j.model.table.TableModel;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblGridCol;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableWriter
extends ModelConverter {
    private static final Logger logger = Logger.getLogger(TableWriter.class);
    public static final String TABLE_BORDER_MODEL = "border-collapse";

    public Node toNode(Model tableModel, TransformState state) throws TransformerException {
        int i;
        TableModel table = (TableModel)tableModel;
        logger.debug((Object)("Table asXML:\n" + table.debugStr()));
        Document doc = XmlUtils.neww3cDomDocument();
        DocumentFragment docfrag = doc.createDocumentFragment();
        Element foTable = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table");
        docfrag.appendChild(foTable);
        List<Property> properties = PropertyFactory.createProperties(table.getEffectiveTableStyle().getTblPr());
        for (Property p : properties) {
            if (p == null) continue;
            p.setXslFO(foTable);
        }
        if (table.getEffectiveTableStyle().getTcPr() != null) {
            properties = PropertyFactory.createProperties(table.getEffectiveTableStyle().getTcPr());
            for (Property p : properties) {
                if (p == null) continue;
                p.setXslFO(foTable);
            }
        }
        TblBorders tblBorders = null;
        if (table.getEffectiveTableStyle().getTblPr() != null) {
            tblBorders = table.getEffectiveTableStyle().getTblPr().getTblBorders();
        }
        if (table.getEffectiveTableStyle().getTcPr() == null || table.getEffectiveTableStyle().getTcPr().getVAlign() == null) {
            foTable.setAttribute("display-align", "before");
        }
        if (table.isBorderConflictResolutionRequired()) {
            foTable.setAttribute(TABLE_BORDER_MODEL, "collapse");
        } else {
            foTable.setAttribute(TABLE_BORDER_MODEL, "separate");
        }
        int cols = table.getColCount();
        int tWidth = 0;
        if (table.getTblGrid() != null) {
            i = 1;
            for (TblGridCol tblGridCol : table.getTblGrid().getGridCol()) {
                String s = String.valueOf(i);
                Element foTableColumn = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-column");
                foTable.appendChild(foTableColumn);
                foTableColumn.setAttribute("column-number", s);
                int width = tblGridCol.getW().intValue();
                tWidth += width;
                foTableColumn.setAttribute("column-width", UnitsOfMeasurement.twipToBest(width));
                ++i;
            }
            foTable.setAttribute("width", UnitsOfMeasurement.twipToBest(tWidth));
        } else {
            for (i = 1; i <= cols; ++i) {
                String s = String.valueOf(i);
                Element element = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-column");
                foTable.appendChild(element);
                element.setAttribute("column-number", s);
            }
        }
        Element foTableBody = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-body");
        foTable.appendChild(foTableBody);
        foTableBody.setAttribute("start-indent", "3mm");
        foTableBody.setAttribute("end-indent", "3mm");
        for (List list : table.getCells()) {
            Element row = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-row");
            foTableBody.appendChild(row);
            for (Cell cell : list) {
                if (cell.isDummy()) continue;
                int col = cell.getColumn();
                Element cellNode = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-cell");
                row.appendChild(cellNode);
                if (tblBorders != null) {
                    if (tblBorders.getInsideH() != null) {
                        new BorderTop(tblBorders.getTop()).setXslFO(cellNode);
                        new BorderBottom(tblBorders.getBottom()).setXslFO(cellNode);
                    }
                    if (tblBorders.getInsideV() != null) {
                        new BorderRight(tblBorders.getRight()).setXslFO(cellNode);
                        new BorderLeft(tblBorders.getLeft()).setXslFO(cellNode);
                    }
                }
                cellNode.setAttribute("height", "5mm");
                if (cell.getTcPr() != null) {
                    StringBuffer inlineStyle = new StringBuffer();
                    Conversion.createFoAttributes(cell.getTcPr(), cellNode);
                }
                if (cell.getExtraCols() > 0) {
                    cellNode.setAttribute("number-columns-spanned", Integer.toString(cell.getExtraCols() + 1));
                }
                if (cell.getExtraRows() > 0) {
                    cellNode.setAttribute("number-rows-spanned", Integer.toString(cell.getExtraRows() + 1));
                }
                if (cell.getContent() == null) {
                    logger.warn((Object)"model cell had no contents!");
                    continue;
                }
                logger.debug((Object)"copying cell contents..");
                XmlUtils.treeCopy(cell.getContent().getChildNodes(), (Node)cellNode);
            }
        }
        return docfrag;
    }
}

