/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.diff;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.util.JAXBResult;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.diff.Differencer;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.junit.Test;

public class ParagraphDifferencerTest {
    static final String BASE_DIR = "src/test/java/org/docx4j/diff/";
    static final String[] testparagraphs = new String[]{"t2R", "t2RR", "t3L", "t3R", "t4"};

    @Test
    public void testDiff() throws Exception {
        for (int i = 0; i < testparagraphs.length - 1; ++i) {
            for (int j = 0; j < testparagraphs.length; ++j) {
                System.out.println("<h1>TESTING " + testparagraphs[i] + ", " + testparagraphs[j] + "</h1>");
                P pl = Differencer.loadParagraph(BASE_DIR + testparagraphs[i]);
                P pr = Differencer.loadParagraph(BASE_DIR + testparagraphs[j]);
                StreamResult result = new StreamResult(System.out);
                Differencer pd = new Differencer();
                pd.diff(pl, pr, (Result)result, null, null, null, null);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new ParagraphDifferencerTest().testDiffDocx();
    }

    @Test
    public void testDiffDocx() throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        for (int i = 0; i < testparagraphs.length - 1; ++i) {
            for (int j = 0; j < testparagraphs.length; ++j) {
                StreamResult err;
                String msg;
                wordMLPackage.getMainDocumentPart().addParagraphOfText("TESTING " + testparagraphs[i] + ", " + testparagraphs[j]);
                wordMLPackage.getMainDocumentPart().addParagraphOfText("first:");
                P pl = Differencer.loadParagraph(BASE_DIR + testparagraphs[i]);
                wordMLPackage.getMainDocumentPart().addObject(pl);
                wordMLPackage.getMainDocumentPart().addParagraphOfText("second:");
                P pr = Differencer.loadParagraph(BASE_DIR + testparagraphs[j]);
                wordMLPackage.getMainDocumentPart().addObject(pr);
                JAXBContext jc = Context.jc;
                JAXBResult result = new JAXBResult(jc);
                Differencer pd = new Differencer();
                pd.diff(pl, pr, (Result)result, null, null, null, null);
                try {
                    P markedUpP = (P)result.getResult();
                    wordMLPackage.getMainDocumentPart().addParagraphOfText("result:");
                    wordMLPackage.getMainDocumentPart().addObject(markedUpP);
                }
                catch (RuntimeException e) {
                    msg = "failed to apply stylesheet to pre-processed! " + testparagraphs[i] + ", " + testparagraphs[j];
                    System.out.println(msg);
                    e.printStackTrace();
                    wordMLPackage.getMainDocumentPart().addParagraphOfText(msg);
                    err = new StreamResult(System.out);
                    pd.diff(pl, pr, (Result)err, null, null, null, null);
                }
                result = new JAXBResult(jc);
                pd.diff(pl, pr, (Result)result, null, null, null, null);
                try {
                    P markedUpPsimple = (P)result.getResult();
                    wordMLPackage.getMainDocumentPart().addParagraphOfText("no preprocessing:");
                    wordMLPackage.getMainDocumentPart().addObject(markedUpPsimple);
                    continue;
                }
                catch (RuntimeException e) {
                    msg = "failed to apply stylesheet to naive! " + testparagraphs[i] + ", " + testparagraphs[j];
                    System.out.println(msg);
                    e.printStackTrace();
                    wordMLPackage.getMainDocumentPart().addParagraphOfText(msg);
                    err = new StreamResult(System.out);
                    pd.diff(pl, pr, (Result)err, null, null, null, null);
                }
            }
        }
        wordMLPackage.save(new File(System.getProperty("java.io.tmpdir") + "/diff.docx"));
    }
}

