/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.wml.Fonts;

public class IdentityPlusMapper
extends Mapper {
    protected static Logger log = Logger.getLogger(IdentityPlusMapper.class);

    public IdentityPlusMapper() {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") < 0) {
            log.warn((Object)"WARNING! SubstituterWindowsPlatformImpl works best on Windows.  To get good results on other platforms, you'll probably  need to have installed Windows fonts.");
        }
    }

    public void populateFontMappings(Map documentFontNames, Fonts wmlFonts) throws Exception {
        for (Map.Entry pairs : documentFontNames.entrySet()) {
            if (pairs.getKey() == null) {
                log.info((Object)"Skipped null key");
                continue;
            }
            String documentFontname = (String)pairs.getKey();
            log.debug((Object)("Document font: " + documentFontname));
            if (PhysicalFonts.getPhysicalFonts().get(documentFontname) != null) {
                fontMappings.put(documentFontname, PhysicalFonts.getPhysicalFonts().get(documentFontname));
                continue;
            }
            log.warn((Object)("- - No physical font for: " + documentFontname));
        }
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = "C:\\Documents and Settings\\Jason Harrop\\My Documents\\Downloads\\AUMS-easy.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        FontTablePart fontTablePart = wordMLPackage.getMainDocumentPart().getFontTablePart();
        Fonts fonts = (Fonts)fontTablePart.getJaxbElement();
        IdentityPlusMapper s = new IdentityPlusMapper();
        s.populateFontMappings(wordMLPackage.getMainDocumentPart().fontsInUse(), fonts);
    }

    static {
        try {
            PhysicalFonts.discoverPhysicalFonts();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

