/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.docx4j.fonts.FontUtils;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontCache;
import org.docx4j.fonts.fop.fonts.FontResolver;
import org.docx4j.fonts.fop.fonts.FontSetup;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.autodetect.FontFileFinder;
import org.docx4j.fonts.fop.fonts.autodetect.FontInfoFinder;
import org.docx4j.fonts.microsoft.MicrosoftFonts;
import org.docx4j.fonts.microsoft.MicrosoftFontsRegistry;
import org.docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalFonts {
    protected static Logger log = Logger.getLogger(PhysicalFonts.class);
    protected static FontCache fontCache;
    private static final Map<String, PhysicalFont> physicalFontMap;
    private static final Map<String, PhysicalFont> physicalFontMapByFilenameLowercase;
    private static FontResolver fontResolver;
    private static FontInfoFinder fontInfoFinder;
    private static boolean loggedWarningAlready;

    public static Map<String, PhysicalFont> getPhysicalFonts() {
        return physicalFontMap;
    }

    public static final void discoverPhysicalFonts() throws Exception {
        URL fontUrl;
        FontFileFinder fontFileFinder = new FontFileFinder();
        List fontFileList = fontFileFinder.find();
        Iterator iter = fontFileList.iterator();
        while (iter.hasNext()) {
            fontUrl = PhysicalFonts.getURL(iter.next());
            FontInfoFinder finder = new FontInfoFinder();
            PhysicalFonts.addPhysicalFont(fontUrl);
        }
        fontFileList = fontFileFinder.find(ObfuscatedFontPart.getTemporaryEmbeddedFontsDir());
        iter = fontFileList.iterator();
        while (iter.hasNext()) {
            fontUrl = PhysicalFonts.getURL(iter.next());
            PhysicalFonts.addPhysicalFont(fontUrl);
        }
        fontCache.save();
    }

    private static URL getURL(Object o) throws Exception {
        if (o instanceof File) {
            File f = (File)o;
            return f.toURL();
        }
        if (o instanceof URL) {
            return (URL)o;
        }
        throw new Exception("Unexpected object:" + o.getClass().getName());
    }

    public static void addPhysicalFont(URL fontUrl) {
        EmbedFontInfo[] embedFontInfoList = fontInfoFinder.find(fontUrl, fontResolver, fontCache);
        if (embedFontInfoList == null) {
            log.warn((Object)("Aborting: " + fontUrl.toString() + " (can't get EmbedFontInfo[] .. try deleting fop-fonts.cache?)"));
            return;
        }
        StringBuffer debug = new StringBuffer();
        for (EmbedFontInfo fontInfo : embedFontInfoList) {
            block13: {
                if (fontInfo == null) continue;
                debug.append("------- \n");
                try {
                    debug.append(fontInfo.getPostScriptName() + "\n");
                    if (!fontInfo.isEmbeddable()) {
                        log.warn((Object)(fontInfo.getEmbedFile() + " is not embeddable; ignoring this font."));
                        continue;
                    }
                }
                catch (Exception e1) {
                    if (loggedWarningAlready) break block13;
                    log.warn((Object)"Not using patched FOP; isEmbeddable() method missing.");
                    loggedWarningAlready = true;
                }
            }
            FontTriplet triplet = (FontTriplet)fontInfo.getFontTriplets().get(0);
            String lower = fontInfo.getEmbedFile().toLowerCase();
            log.debug((Object)("Processing physical font: " + lower));
            debug.append(".. triplet " + triplet.getName() + " (priority " + triplet.getPriority() + "\n");
            PhysicalFont pf = null;
            if (lower.endsWith(".otf") || lower.endsWith(".ttf") || lower.endsWith(".ttc")) {
                pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
            } else if (lower.endsWith(".pfb")) {
                String afm = FontUtils.pathFromURL(lower);
                afm = afm.substring(0, afm.length() - 4) + ".afm";
                log.debug((Object)("Looking for: " + afm));
                File f = new File(afm);
                if (f.exists()) {
                    log.debug((Object)".. found");
                    pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
                } else {
                    String pfm = FontUtils.pathFromURL(lower);
                    pfm = pfm.substring(0, pfm.length() - 4) + ".pfm";
                    log.debug((Object)("Looking for: " + pfm));
                    f = new File(pfm);
                    if (f.exists()) {
                        log.debug((Object)".. found");
                        pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
                    } else {
                        log.warn((Object)("Skipping " + triplet.getName() + "; couldn't find .afm or .pfm for : " + fontInfo.getEmbedFile()));
                    }
                }
            } else {
                log.warn((Object)("Skipping " + triplet.getName() + "; unsupported type: " + fontInfo.getEmbedFile()));
            }
            if (pf == null) continue;
            physicalFontMap.put(pf.getName(), pf);
            log.debug((Object)("Added " + pf.getName() + " -> " + pf.getEmbeddedFile()));
            String filename = pf.getEmbeddedFile();
            filename = filename.substring(filename.lastIndexOf("/") + 1).toLowerCase();
            physicalFontMapByFilenameLowercase.put(filename, pf);
            log.debug((Object)("added to filename map: " + filename));
        }
        log.debug((Object)debug.toString());
    }

    public static PhysicalFont getBoldForm(PhysicalFont pf) {
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.warn((Object)("No entry in MicrosoftFontsRegistry for: " + pf.getName()));
            return null;
        }
        if (msFont.getBold() == null) {
            log.debug((Object)("No bold form for: " + pf.getName()));
            return null;
        }
        String filename = msFont.getBold().getFilename().toLowerCase();
        log.debug((Object)("Fetching: " + filename));
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static PhysicalFont getBoldItalicForm(PhysicalFont pf) {
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.warn((Object)("No entry in MicrosoftFontsRegistry for: " + pf.getName()));
            return null;
        }
        if (msFont.getBolditalic() == null) {
            log.debug((Object)("No Bolditalic form for: " + pf.getName()));
            return null;
        }
        String filename = msFont.getBolditalic().getFilename().toLowerCase();
        log.debug((Object)("Fetching: " + filename));
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static PhysicalFont getItalicForm(PhysicalFont pf) {
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.debug((Object)("No entry in MicrosoftFontsRegistry for: " + pf.getName()));
            return null;
        }
        if (msFont.getItalic() == null) {
            log.info((Object)("No italic form for: " + pf.getName()));
            return null;
        }
        String filename = msFont.getItalic().getFilename().toLowerCase();
        log.debug((Object)("Fetching: " + filename));
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static void main(String[] args) throws Exception {
        PhysicalFonts.discoverPhysicalFonts();
        System.out.println("That should have listed your physical fonts (provided you have logging enabled).");
    }

    static {
        try {
            fontCache = FontCache.load();
            if (fontCache == null) {
                fontCache = new FontCache();
            }
            physicalFontMap = new HashMap<String, PhysicalFont>();
            physicalFontMapByFilenameLowercase = new HashMap<String, PhysicalFont>();
            fontResolver = FontSetup.createMinimalFontResolver();
            fontInfoFinder = new FontInfoFinder();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        loggedWarningAlready = false;
    }
}

