/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.jaxb;

import java.io.IOException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.utils.ResourceUtils;

public class JaxbValidationEventHandler
implements ValidationEventHandler {
    private static Logger log = Logger.getLogger(JaxbValidationEventHandler.class);
    private boolean shouldContinue = true;
    public static final String UNEXPECTED_MC_ALTERNATE_CONTENT = "unexpected element (uri:\"http://schemas.openxmlformats.org/markup-compatibility/2006\", local:\"AlternateContent\")";
    static Templates mcPreprocessorXslt;

    public void setContinue(boolean val) {
        this.shouldContinue = val;
    }

    public static Templates getMcPreprocessor() throws IOException, TransformerConfigurationException {
        if (mcPreprocessorXslt == null) {
            try {
                StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/jaxb/mc-preprocessor.xslt"));
                mcPreprocessorXslt = XmlUtils.getTransformerTemplate(xsltSource);
            }
            catch (IOException e) {
                log.error((Object)e);
                throw e;
            }
            catch (TransformerConfigurationException e) {
                log.error((Object)e);
                throw e;
            }
        }
        return mcPreprocessorXslt;
    }

    public boolean handleEvent(ValidationEvent ve) {
        if (ve.getSeverity() == 2 || ve.getSeverity() == 1) {
            ValidationEventLocator locator = ve.getLocator();
            if (log.isDebugEnabled() || ve.getMessage().length() < 120) {
                log.warn((Object)(this.printSeverity(ve) + ": " + ve.getMessage()));
            } else {
                log.warn((Object)(this.printSeverity(ve) + ": " + ve.getMessage().substring(0, 120)));
            }
            if (ve.getLinkedException() != null && log.isDebugEnabled()) {
                ve.getLinkedException().printStackTrace();
            }
        } else if (ve.getSeverity() == 0) {
            log.warn((Object)(this.printSeverity(ve) + "Message is " + ve.getMessage()));
        }
        log.info((Object)"continuing (with possible element/attribute loss)");
        return this.shouldContinue;
    }

    public String printSeverity(ValidationEvent ve) {
        String errorLevel;
        switch (ve.getSeverity()) {
            case 2: {
                errorLevel = "(non)FATAL_ERROR";
                break;
            }
            case 1: {
                errorLevel = "ERROR";
                break;
            }
            case 0: {
                errorLevel = "WARNING";
                break;
            }
            default: {
                errorLevel = new Integer(ve.getSeverity()).toString();
            }
        }
        return "[" + errorLevel + "] ";
    }
}

