/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.dml.BaseStyles;
import org.docx4j.dml.TextFont;
import org.docx4j.dml.Theme;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTTblCellMar;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTTblStylePr;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STTheme;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TrPr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolver {
    private static Logger log = Logger.getLogger(PropertyResolver.class);
    private DocDefaults docDefaults;
    private PPr documentDefaultPPr;
    private RPr documentDefaultRPr;
    private StyleDefinitionsPart styleDefinitionsPart;
    private WordprocessingMLPackage wordMLPackage;
    private Styles styles;
    private Map<String, Style> liveStyles = null;
    private ThemePart themePart;
    private NumberingDefinitionsPart numberingDefinitionsPart;
    private Map<String, PPr> resolvedStylePPrComponent = new HashMap<String, PPr>();
    private Map<String, RPr> resolvedStyleRPrComponent = new HashMap<String, RPr>();
    String defaultParagraphStyleId;
    String defaultCharacterStyleId;
    ObjectFactory factory = new ObjectFactory();

    public PropertyResolver(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.wordMLPackage = wordMLPackage;
        MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
        this.styleDefinitionsPart = mdp.getStyleDefinitionsPart();
        this.themePart = mdp.getThemePart();
        this.numberingDefinitionsPart = mdp.getNumberingDefinitionsPart();
        this.init();
    }

    private void init() throws Docx4JException {
        try {
            if (this.styleDefinitionsPart == null) {
                this.styleDefinitionsPart = new StyleDefinitionsPart();
                this.styleDefinitionsPart.unmarshalDefaultStyles();
            }
        }
        catch (Exception e) {
            throw new Docx4JException("Couldn't create default StyleDefinitionsPart", e);
        }
        this.defaultParagraphStyleId = this.styleDefinitionsPart.getDefaultParagraphStyle().getStyleId();
        this.defaultCharacterStyleId = this.styleDefinitionsPart.getDefaultCharacterStyle().getStyleId();
        this.styles = (Styles)this.styleDefinitionsPart.getJaxbElement();
        this.initialiseLiveStyles();
        this.docDefaults = this.styles.getDocDefaults();
        if (this.docDefaults == null) {
            try {
                this.docDefaults = (DocDefaults)XmlUtils.unmarshalString("<w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>");
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>", (Exception)((Object)e));
            }
        }
        if (this.docDefaults.getPPrDefault() == null) {
            try {
                this.documentDefaultPPr = (PPr)XmlUtils.unmarshalString("<w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>");
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>", (Exception)((Object)e));
            }
        } else {
            this.documentDefaultPPr = this.docDefaults.getPPrDefault().getPPr();
        }
        if (this.docDefaults.getRPrDefault() == null) {
            try {
                this.documentDefaultRPr = (RPr)XmlUtils.unmarshalString("<w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>");
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>", (Exception)((Object)e));
            }
        } else {
            this.documentDefaultRPr = this.docDefaults.getRPrDefault().getRPr();
        }
        this.addNormalToResolvedStylePPrComponent();
        this.addDefaultParagraphFontToResolvedStyleRPrComponent();
    }

    private void addNormalToResolvedStylePPrComponent() {
        Stack<PPr> pPrStack = new Stack<PPr>();
        String styleId = this.defaultParagraphStyleId;
        this.fillPPrStack(styleId, pPrStack);
        pPrStack.push(this.documentDefaultPPr);
        PPr effectivePPr = this.factory.createPPr();
        while (!pPrStack.empty()) {
            PPr pPr = pPrStack.pop();
            this.applyPPr(pPr, effectivePPr);
        }
        this.resolvedStylePPrComponent.put(styleId, effectivePPr);
    }

    private void addDefaultParagraphFontToResolvedStyleRPrComponent() {
        Stack<RPr> rPrStack = new Stack<RPr>();
        this.fillRPrStack(this.defaultParagraphStyleId, rPrStack);
        this.fillRPrStack(this.defaultCharacterStyleId, rPrStack);
        rPrStack.push(this.documentDefaultRPr);
        RPr effectiveRPr = this.factory.createRPr();
        while (!rPrStack.empty()) {
            RPr rPr = rPrStack.pop();
            this.applyRPr(rPr, effectiveRPr);
        }
        this.resolvedStyleRPrComponent.put(this.defaultCharacterStyleId, effectiveRPr);
    }

    public Style getEffectiveTableStyle(TblPr tblPr) {
        Style result;
        Stack<Style> tableStyleStack = new Stack<Style>();
        if (tblPr != null && tblPr.getTblStyle() != null) {
            String styleId = tblPr.getTblStyle().getVal();
            log.debug((Object)("Table style: " + styleId));
            this.fillTableStyleStack(styleId, tableStyleStack);
        } else {
            log.debug((Object)"No table style specified");
        }
        if (tableStyleStack.size() > 0) {
            result = (Style)XmlUtils.deepCopy(tableStyleStack.pop());
        } else {
            result = Context.getWmlObjectFactory().createStyle();
            if (tblPr == null) {
                return result;
            }
        }
        while (!tableStyleStack.empty()) {
            Style thisLevel = (Style)tableStyleStack.pop();
            this.applyTableStyle(thisLevel, result);
        }
        if (result.getTblPr() == null) {
            result.setTblPr(Context.getWmlObjectFactory().createCTTblPrBase());
        }
        this.applyTablePr(tblPr, result.getTblPr());
        return result;
    }

    private void applyTableStyle(Style thisLevel, Style result) {
        if (thisLevel.getTblPr() != null) {
            log.debug((Object)"Applying tblPr..");
            if (result.getTblPr() == null) {
                result.setTblPr(XmlUtils.deepCopy(thisLevel.getTblPr()));
            } else {
                this.applyTablePr(thisLevel.getTblPr(), result.getTblPr());
            }
        }
        if (thisLevel.getTblStylePr() != null) {
            log.debug((Object)"Applying tblStylePr.. TODO!");
            this.applyTableStylePr(thisLevel.getTblStylePr(), result.getTblStylePr());
        }
        if (thisLevel.getTrPr() != null) {
            log.debug((Object)"Applying trPr.. TODO!");
            if (result.getTrPr() == null) {
                result.setTrPr(XmlUtils.deepCopy(thisLevel.getTrPr()));
            } else {
                this.applyTrPr(thisLevel.getTrPr(), result.getTrPr());
            }
        }
        if (thisLevel.getTcPr() != null) {
            log.debug((Object)"Applying tcPr.. TODO!");
            if (result.getTcPr() == null) {
                result.setTcPr(XmlUtils.deepCopy(thisLevel.getTcPr()));
            } else {
                this.applyTcPr(thisLevel.getTcPr(), result.getTcPr());
            }
        }
        if (thisLevel.getPPr() != null) {
            log.debug((Object)"Applying pPr..");
            if (result.getPPr() == null) {
                result.setPPr(XmlUtils.deepCopy(thisLevel.getPPr()));
            } else {
                this.applyPPr(thisLevel.getPPr(), result.getPPr());
            }
        }
        if (thisLevel.getRPr() != null) {
            log.debug((Object)"Applying rPr..");
            if (result.getRPr() == null) {
                result.setRPr(XmlUtils.deepCopy(thisLevel.getRPr()));
            } else {
                this.applyRPr(thisLevel.getRPr(), result.getRPr());
            }
        }
    }

    private void applyTablePr(CTTblPrBase thisLevel, CTTblPrBase result) {
        if (thisLevel.getTblInd() != null) {
            if (result.getTblInd() == null) {
                result.setTblInd(XmlUtils.deepCopy(thisLevel.getTblInd()));
            } else {
                result.getTblInd().setW(BigInteger.valueOf(thisLevel.getTblInd().getW().intValue()));
                result.getTblInd().setType(thisLevel.getTblInd().getType());
            }
        }
        if (thisLevel.getTblBorders() != null) {
            if (result.getTblBorders() == null) {
                result.setTblBorders(XmlUtils.deepCopy(thisLevel.getTblBorders()));
            } else {
                TblBorders thisLevelBorders = thisLevel.getTblBorders();
                TblBorders resultBorders = result.getTblBorders();
                if (thisLevelBorders.getTop() != null) {
                    resultBorders.setTop(XmlUtils.deepCopy(thisLevelBorders.getTop()));
                }
                if (thisLevelBorders.getBottom() != null) {
                    resultBorders.setBottom(XmlUtils.deepCopy(thisLevelBorders.getBottom()));
                }
                if (thisLevelBorders.getLeft() != null) {
                    resultBorders.setLeft(XmlUtils.deepCopy(thisLevelBorders.getLeft()));
                }
                if (thisLevelBorders.getRight() != null) {
                    resultBorders.setRight(XmlUtils.deepCopy(thisLevelBorders.getRight()));
                }
                if (thisLevelBorders.getInsideH() != null) {
                    resultBorders.setInsideH(XmlUtils.deepCopy(thisLevelBorders.getInsideH()));
                }
                if (thisLevelBorders.getInsideV() != null) {
                    resultBorders.setInsideV(XmlUtils.deepCopy(thisLevelBorders.getInsideV()));
                }
            }
        }
        if (thisLevel.getTblCellMar() != null) {
            if (result.getTblCellMar() == null) {
                result.setTblCellMar(XmlUtils.deepCopy(thisLevel.getTblCellMar()));
            } else {
                CTTblCellMar thisLevelCellMar = thisLevel.getTblCellMar();
                CTTblCellMar resultCellMar = result.getTblCellMar();
                if (thisLevelCellMar.getTop() != null) {
                    resultCellMar.setTop(XmlUtils.deepCopy(thisLevelCellMar.getTop()));
                }
                if (thisLevelCellMar.getBottom() != null) {
                    resultCellMar.setBottom(XmlUtils.deepCopy(thisLevelCellMar.getBottom()));
                }
                if (thisLevelCellMar.getLeft() != null) {
                    resultCellMar.setLeft(XmlUtils.deepCopy(thisLevelCellMar.getLeft()));
                }
                if (thisLevelCellMar.getRight() != null) {
                    resultCellMar.setRight(XmlUtils.deepCopy(thisLevelCellMar.getRight()));
                }
            }
        }
        if (thisLevel.getTblCellSpacing() != null) {
            result.setTblCellSpacing(XmlUtils.deepCopy(thisLevel.getTblCellSpacing()));
        }
    }

    private void applyTableStylePr(List<CTTblStylePr> thisLevel, List<CTTblStylePr> result) {
    }

    private void applyTrPr(TrPr thisLevel, TrPr result) {
    }

    private void applyTcPr(TcPr thisLevel, TcPr result) {
    }

    private void fillTableStyleStack(String styleId, Stack<Style> tableStyleStack) {
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            log.error((Object)("Style definition not found: " + styleId));
            return;
        }
        tableStyleStack.push(style);
        log.debug((Object)("Added " + styleId + " to table style stack"));
        if (style.getBasedOn() == null) {
            log.debug((Object)("Style " + styleId + " is a root style."));
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            this.fillTableStyleStack(basedOnStyleName, tableStyleStack);
        } else {
            log.debug((Object)("No basedOn set for: " + style.getStyleId()));
        }
    }

    public PPr getEffectivePPr(PPr expressPPr) {
        PPr effectivePPr = null;
        PPr resolvedPPr = null;
        String styleId = expressPPr == null || expressPPr.getPStyle() == null ? this.defaultParagraphStyleId : expressPPr.getPStyle().getVal();
        resolvedPPr = this.getEffectivePPr(styleId);
        if (this.hasDirectPPrFormatting(expressPPr)) {
            if (resolvedPPr == null) {
                log.warn((Object)"resolvedPPr was null. Look into this?");
                effectivePPr = Context.getWmlObjectFactory().createPPr();
            } else {
                effectivePPr = XmlUtils.deepCopy(resolvedPPr);
            }
            this.applyPPr(expressPPr, effectivePPr);
            return effectivePPr;
        }
        return resolvedPPr;
    }

    public PPr getEffectivePPr(String styleId) {
        PPr resolvedPPr = this.resolvedStylePPrComponent.get(styleId);
        if (resolvedPPr != null) {
            return resolvedPPr;
        }
        Style s = this.liveStyles.get(styleId);
        if (s == null) {
            log.error((Object)("Couldn't find style: " + styleId));
            return null;
        }
        PPr expressPPr = s.getPPr();
        if (expressPPr == null) {
            log.error((Object)("style: " + styleId + " has no PPr"));
            String normalId = this.styleDefinitionsPart.getDefaultParagraphStyle().getStyleId();
            resolvedPPr = this.resolvedStylePPrComponent.get(normalId);
            return resolvedPPr;
        }
        Stack<PPr> pPrStack = new Stack<PPr>();
        this.fillPPrStack(styleId, pPrStack);
        pPrStack.push(this.documentDefaultPPr);
        resolvedPPr = this.factory.createPPr();
        while (!pPrStack.empty()) {
            PPr pPr = pPrStack.pop();
            this.applyPPr(pPr, resolvedPPr);
        }
        this.resolvedStylePPrComponent.put(styleId, resolvedPPr);
        return resolvedPPr;
    }

    public RPr getEffectiveRPr(RPr expressRPr, PPr pPr) {
        log.debug((Object)"in getEffectiveRPr");
        RPr effectiveRPr = XmlUtils.deepCopy(this.documentDefaultRPr);
        if (expressRPr == null || expressRPr.getRStyle() == null) {
            this.applyRPr(this.resolvedStyleRPrComponent.get(this.defaultCharacterStyleId), effectiveRPr);
        }
        if (pPr == null) {
            log.debug((Object)"pPr was null");
        } else {
            if (pPr.getPStyle() != null) {
                log.debug((Object)("pstyle:" + pPr.getPStyle().getVal()));
                RPr pPrLevelRunStyle = this.getEffectiveRPr(pPr.getPStyle().getVal());
                this.applyRPr(pPrLevelRunStyle, effectiveRPr);
            }
            if (expressRPr == null && pPr.getRPr() != null && this.hasDirectRPrFormatting(pPr.getRPr())) {
                this.applyRPr(pPr.getRPr(), effectiveRPr);
            }
        }
        RPr resolvedRPr = null;
        if (expressRPr != null && expressRPr.getRStyle() != null) {
            String runStyleId = expressRPr.getRStyle().getVal();
            resolvedRPr = this.getEffectiveRPr(runStyleId);
            this.applyRPr(resolvedRPr, effectiveRPr);
        }
        if (this.hasDirectRPrFormatting(expressRPr)) {
            this.applyRPr(expressRPr, effectiveRPr);
        }
        return effectiveRPr;
    }

    public RPr getEffectiveRPr(String styleId) {
        RPr resolvedRPr = this.resolvedStyleRPrComponent.get(styleId);
        if (resolvedRPr != null) {
            return resolvedRPr;
        }
        Style s = this.liveStyles.get(styleId);
        if (s == null) {
            log.error((Object)("Couldn't find style: " + styleId));
            return null;
        }
        Stack<RPr> rPrStack = new Stack<RPr>();
        this.fillRPrStack(styleId, rPrStack);
        rPrStack.push(this.documentDefaultRPr);
        resolvedRPr = this.factory.createRPr();
        while (!rPrStack.empty()) {
            RPr rPr = rPrStack.pop();
            this.applyRPr(rPr, resolvedRPr);
        }
        this.resolvedStyleRPrComponent.put(styleId, resolvedRPr);
        return resolvedRPr;
    }

    private BooleanDefaultTrue newBooleanDefaultTrue(boolean val) {
        BooleanDefaultTrue newBooleanDefaultTrue = this.factory.createBooleanDefaultTrue();
        newBooleanDefaultTrue.setVal(val);
        return newBooleanDefaultTrue;
    }

    private boolean hasDirectPPrFormatting(PPr pPrToApply) {
        if (pPrToApply == null) {
            return false;
        }
        if (pPrToApply.getKeepNext() != null) {
            return true;
        }
        if (pPrToApply.getKeepLines() != null) {
            return true;
        }
        if (pPrToApply.getPageBreakBefore() != null) {
            return true;
        }
        if (pPrToApply.getWidowControl() != null) {
            return true;
        }
        if (pPrToApply.getNumPr() != null) {
            return true;
        }
        if (pPrToApply.getSuppressLineNumbers() != null) {
            return true;
        }
        if (pPrToApply.getPBdr() != null) {
            return true;
        }
        if (pPrToApply.getShd() != null) {
            return true;
        }
        if (pPrToApply.getTabs() != null) {
            return true;
        }
        if (pPrToApply.getSpacing() != null) {
            return true;
        }
        if (pPrToApply.getInd() != null) {
            return true;
        }
        if (pPrToApply.getJc() != null) {
            return true;
        }
        if (pPrToApply.getTextAlignment() != null) {
            return true;
        }
        return pPrToApply.getOutlineLvl() != null;
    }

    protected void applyPPr(PPr pPrToApply, PPr effectivePPr) {
        log.debug((Object)("apply " + XmlUtils.marshaltoString((Object)pPrToApply, true, true) + "\n\r to " + XmlUtils.marshaltoString((Object)effectivePPr, true, true)));
        if (pPrToApply == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties((OpcPackage)this.wordMLPackage, pPrToApply);
        for (Property p : properties) {
            if (p == null) continue;
            ((AbstractParagraphProperty)p).set(effectivePPr);
        }
        log.debug((Object)("result " + XmlUtils.marshaltoString((Object)effectivePPr, true, true)));
    }

    private boolean hasDirectRPrFormatting(RPr rPrToApply) {
        if (rPrToApply == null) {
            return false;
        }
        if (rPrToApply.getRFonts() != null) {
            return true;
        }
        if (rPrToApply.getB() != null) {
            return true;
        }
        if (rPrToApply.getI() != null) {
            return true;
        }
        if (rPrToApply.getCaps() != null) {
            return true;
        }
        if (rPrToApply.getSmallCaps() != null) {
            return true;
        }
        if (rPrToApply.getStrike() != null) {
            return true;
        }
        if (rPrToApply.getColor() != null) {
            return true;
        }
        if (rPrToApply.getSz() != null) {
            return true;
        }
        if (rPrToApply.getHighlight() != null) {
            return true;
        }
        if (rPrToApply.getU() != null) {
            return true;
        }
        if (rPrToApply.getBdr() != null) {
            return true;
        }
        return rPrToApply.getShd() != null;
    }

    private boolean hasDirectRPrFormatting(ParaRPr rPrToApply) {
        if (rPrToApply == null) {
            return false;
        }
        if (rPrToApply.getRFonts() != null) {
            return true;
        }
        if (rPrToApply.getB() != null) {
            return true;
        }
        if (rPrToApply.getI() != null) {
            return true;
        }
        if (rPrToApply.getCaps() != null) {
            return true;
        }
        if (rPrToApply.getSmallCaps() != null) {
            return true;
        }
        if (rPrToApply.getStrike() != null) {
            return true;
        }
        if (rPrToApply.getColor() != null) {
            return true;
        }
        if (rPrToApply.getSz() != null) {
            return true;
        }
        return rPrToApply.getU() != null;
    }

    protected void applyRPr(RPr rPrToApply, RPr effectiveRPr) {
        if (rPrToApply == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(null, rPrToApply);
        for (Property p : properties) {
            if (p == null) continue;
            ((AbstractRunProperty)p).set(effectiveRPr);
        }
    }

    protected void applyRPr(ParaRPr rPrToApply, RPr effectiveRPr) {
        if (rPrToApply == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(null, rPrToApply);
        for (Property p : properties) {
            if (p == null) continue;
            ((AbstractRunProperty)p).set(effectiveRPr);
        }
    }

    private void fillPPrStack(String styleId, Stack<PPr> pPrStack) {
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            log.error((Object)("Style definition not found: " + styleId));
            return;
        }
        pPrStack.push(style.getPPr());
        log.debug((Object)("Added " + styleId + " to pPr stack"));
        boolean ascertainNumId = false;
        if (style.getPPr() != null && style.getPPr().getNumPr() != null && style.getPPr().getNumPr().getNumId() == null) {
            ascertainNumId = true;
            log.debug((Object)(styleId + " ascertainNumId: " + ascertainNumId));
        } else {
            log.debug((Object)(styleId + " ascertainNumId: " + ascertainNumId));
        }
        if (style.getBasedOn() == null) {
            log.debug((Object)("Style " + styleId + " is a root style."));
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            log.debug((Object)("Style " + styleId + " is based on " + basedOnStyleName));
            this.fillPPrStack(basedOnStyleName, pPrStack);
            Style basedOnStyle = this.liveStyles.get(basedOnStyleName);
            if (ascertainNumId && basedOnStyle != null && basedOnStyle.getPPr() != null && basedOnStyle.getPPr().getNumPr() != null && basedOnStyle.getPPr().getNumPr().getNumId() != null) {
                PPrBase.NumPr.NumId numId = basedOnStyle.getPPr().getNumPr().getNumId();
                style.getPPr().getNumPr().setNumId(numId);
                log.info((Object)("Injected numId " + numId));
            }
        } else {
            log.debug((Object)("No basedOn set for: " + style.getStyleId()));
        }
    }

    private void fillRPrStack(String styleId, Stack<RPr> rPrStack) {
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            log.error((Object)("Style definition not found: " + styleId));
            return;
        }
        rPrStack.push(style.getRPr());
        log.debug((Object)("Added " + styleId + " to pPr stack"));
        if (style.getBasedOn() == null) {
            log.debug((Object)("Style " + styleId + " is a root style."));
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            this.fillRPrStack(basedOnStyleName, rPrStack);
        } else {
            log.debug((Object)("No basedOn set for: " + style.getStyleId()));
        }
    }

    private void initialiseLiveStyles() {
        log.debug((Object)"initialiseLiveStyles()");
        this.liveStyles = new HashMap<String, Style>();
        for (Style s : this.styles.getStyle()) {
            this.liveStyles.put(s.getStyleId(), s);
        }
    }

    public String getDefaultFont() {
        RFonts rFonts = this.documentDefaultRPr.getRFonts();
        if (rFonts == null) {
            log.info((Object)"No styles/docDefaults/rPrDefault/rPr/rFonts - default to Times New Roman");
            return "Times New Roman";
        }
        if (rFonts.getAsciiTheme() != null) {
            if (rFonts.getAsciiTheme().equals((Object)STTheme.MINOR_H_ANSI)) {
                if (this.themePart != null) {
                    BaseStyles.FontScheme fontScheme = this.themePart.getFontScheme();
                    if (fontScheme.getMinorFont() != null && fontScheme.getMinorFont().getLatin() != null) {
                        TextFont textFont = fontScheme.getMinorFont().getLatin();
                        log.debug((Object)("minorFont/latin font is " + textFont.getTypeface()));
                        return textFont.getTypeface();
                    }
                    log.info((Object)"No minorFont/latin in theme part - default to Calibri");
                    return "Calibri";
                }
                log.info((Object)"No theme part - default to Calibri");
                return "Calibri";
            }
            log.error((Object)("Don't know how to handle: " + (Object)((Object)rFonts.getAsciiTheme())));
            return null;
        }
        if (rFonts.getAscii() != null) {
            log.info((Object)("rPrDefault/rFonts referenced " + rFonts.getAscii()));
            return rFonts.getAscii();
        }
        log.error((Object)"Neither ascii or asciTheme.  What to do? ");
        return null;
    }

    public boolean activateStyle(String styleId) {
        if (this.liveStyles.get(styleId) != null) {
            return true;
        }
        PropertyResolver propertyResolver = this;
        Map<String, Style> knownStyles = propertyResolver.styleDefinitionsPart.getKnownStyles();
        Style s = knownStyles.get(styleId);
        if (s == null) {
            log.error((Object)("Unknown style: " + styleId));
            return false;
        }
        return this.activateStyle(s, false);
    }

    public boolean activateStyle(Style s) {
        return this.activateStyle(s, true);
    }

    private boolean activateStyle(Style s, boolean replace) {
        boolean result1;
        if (this.liveStyles.get(s.getStyleId()) != null) {
            if (!replace) {
                return false;
            }
            this.styles.getStyle().remove(this.liveStyles.get(s.getStyleId()));
        }
        this.styles.getStyle().add(s);
        this.liveStyles.put(s.getStyleId(), s);
        if (s.getBasedOn() != null) {
            String basedOn = s.getBasedOn().getVal();
            result1 = this.activateStyle(basedOn);
        } else if (s.getStyleId().equals(this.defaultParagraphStyleId) || s.getStyleId().equals(this.defaultCharacterStyleId)) {
            result1 = true;
        } else {
            log.error((Object)("Expected " + s.getStyleId() + " to have <w:basedOn ??"));
            result1 = false;
        }
        boolean result2 = true;
        if (s.getLink() != null) {
            Style.Link link = s.getLink();
            result2 = this.activateStyle(link.getVal());
        }
        return result1 & result2;
    }

    public Style getStyle(String styleId) {
        return this.liveStyles.get(styleId);
    }

    public String getFontnameFromStyle(Style style) {
        return PropertyResolver.getFontnameFromStyle(this.styleDefinitionsPart, this.themePart, style);
    }

    public static String getFontnameFromStyle(StyleDefinitionsPart styleDefinitionsPart, ThemePart themePart, Style style) {
        Styles styles = (Styles)styleDefinitionsPart.getJaxbElement();
        HashMap<String, Style> stylesDefined = new HashMap<String, Style>();
        for (Style s : styles.getStyle()) {
            stylesDefined.put(s.getStyleId(), s);
        }
        return PropertyResolver.getFontnameFromStyle(stylesDefined, themePart, style);
    }

    public static String getFontnameFromStyle(Map stylesDefined, ThemePart themePart, Style style) {
        RPr rPr = style.getRPr();
        if (rPr != null && rPr.getRFonts() != null) {
            if (rPr.getRFonts().getAscii() != null) {
                return rPr.getRFonts().getAscii();
            }
            if (rPr.getRFonts().getAsciiTheme() != null && themePart != null) {
                log.debug((Object)("Encountered rFonts/AsciiTheme: " + (Object)((Object)rPr.getRFonts().getAsciiTheme())));
                Theme theme = (Theme)themePart.getJaxbElement();
                BaseStyles.FontScheme fontScheme = themePart.getFontScheme();
                if (rPr.getRFonts().getAsciiTheme().equals((Object)STTheme.MINOR_H_ANSI)) {
                    if (fontScheme != null && fontScheme.getMinorFont().getLatin() != null) {
                        fontScheme = theme.getThemeElements().getFontScheme();
                        TextFont textFont = fontScheme.getMinorFont().getLatin();
                        log.info((Object)("minorFont/latin font is " + textFont.getTypeface()));
                        return textFont.getTypeface();
                    }
                    log.info((Object)"No minorFont/latin in theme part - default to Calibri");
                    return "Calibri";
                }
                if (rPr.getRFonts().getAsciiTheme().equals((Object)STTheme.MAJOR_H_ANSI)) {
                    if (fontScheme != null && fontScheme.getMajorFont().getLatin() != null) {
                        fontScheme = theme.getThemeElements().getFontScheme();
                        TextFont textFont = fontScheme.getMajorFont().getLatin();
                        log.debug((Object)("majorFont/latin font is " + textFont.getTypeface()));
                        return textFont.getTypeface();
                    }
                    log.info((Object)"No majorFont/latin in theme part - default to Cambria");
                    return "Cambria";
                }
                log.error((Object)("Don't know how to handle: " + (Object)((Object)rPr.getRFonts().getAsciiTheme())));
            }
        }
        if (style.getBasedOn() != null && style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            Style candidateStyle = (Style)stylesDefined.get(basedOnStyleName);
            if (candidateStyle != null && candidateStyle.getStyleId().equals(basedOnStyleName)) {
                return PropertyResolver.getFontnameFromStyle(stylesDefined, themePart, candidateStyle);
            }
            log.error((Object)("couldn't find basedOn:" + basedOnStyleName));
            return null;
        }
        return null;
    }
}

