/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.opendope.xpaths.Xpaths;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingHandler {
    private static Logger log = Logger.getLogger(BindingHandler.class);
    static Templates xslt;
    private static XPathFactory xPathFactory;
    private static XPath xPath;
    private static String hyperlinkStyleId;
    public static final String CORE_PROPERTIES_STOREITEMID = "{6C3C8BC8-F283-45AE-878A-BAB7291924A1}";
    public static final String EXTENDED_PROPERTIES_STOREITEMID = "{6668398D-A668-4E3E-A5EB-62B293D839F1}";
    public static final String COVERPAGE_PROPERTIES_STOREITEMID = "{55AF091B-3C7A-41E3-B477-F2FDAA23CFDA}";

    public static void setHyperlinkStyle(String hyperlinkStyleID) {
        hyperlinkStyleId = hyperlinkStyleID;
    }

    public static void log(String message) {
        log.info((Object)message);
    }

    public static void applyBindings(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        if (hyperlinkStyleId != null) {
            wordMLPackage.getMainDocumentPart().getPropertyResolver().activateStyle(hyperlinkStyleId);
        }
        BindingHandler.applyBindings(wordMLPackage.getMainDocumentPart());
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                BindingHandler.applyBindings((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            BindingHandler.applyBindings((FooterPart)rp.getPart(r));
        }
    }

    public static void applyBindings(JaxbXmlPart part) throws Docx4JException {
        OpcPackage pkg = part.getPackage();
        if (hyperlinkStyleId != null && pkg instanceof WordprocessingMLPackage) {
            ((WordprocessingMLPackage)pkg).getMainDocumentPart().getPropertyResolver().activateStyle(hyperlinkStyleId);
        }
        Document doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
        XPathsPart xPathsPart = null;
        if (((WordprocessingMLPackage)pkg).getMainDocumentPart().getXPathsPart() == null) {
            log.error((Object)"OpenDoPE XPaths part missing");
        } else {
            xPathsPart = ((WordprocessingMLPackage)pkg).getMainDocumentPart().getXPathsPart();
        }
        JAXBContext jc = Context.jc;
        try {
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            JAXBResult result = new JAXBResult(u);
            HashMap<String, Object> transformParameters = new HashMap<String, Object>();
            transformParameters.put("customXmlDataStorageParts", part.getPackage().getCustomXmlDataStorageParts());
            transformParameters.put("wmlPackage", (WordprocessingMLPackage)pkg);
            transformParameters.put("sourcePart", part);
            transformParameters.put("xPathsPart", xPathsPart);
            XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
            part.setJaxbElement(result);
        }
        catch (Exception e) {
            throw new Docx4JException("Problems applying bindings", e);
        }
    }

    public static String xpathGetString(WordprocessingMLPackage pkg, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        try {
            if (storeItemId.toUpperCase().equals(CORE_PROPERTIES_STOREITEMID)) {
                return pkg.getDocPropsCorePart().xpathGetString(xpath, prefixMappings);
            }
            if (storeItemId.toUpperCase().equals(EXTENDED_PROPERTIES_STOREITEMID)) {
                return pkg.getDocPropsExtendedPart().xpathGetString(xpath, prefixMappings);
            }
            CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
            if (part == null) {
                log.error((Object)("Couldn't locate part by storeItemId " + storeItemId));
                return null;
            }
            if (log.isDebugEnabled()) {
                String r = part.getData().xpathGetString(xpath, prefixMappings);
                log.debug((Object)(xpath + " yielded result " + r));
                return r;
            }
            return part.getData().xpathGetString(xpath, prefixMappings);
        }
        catch (Docx4JException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DocumentFragment convertXHTML(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, XPathsPart xPathsPart, String sdtParent, String contentChild, NodeIterator rPrNodeIt, String tag) {
        String prefixMappings;
        String xpathExp;
        log.info((Object)"convertXHTML extension function");
        log.info((Object)("contentChild: " + contentChild));
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(tag, true);
        String xpathId = map.get("od:xpath");
        log.info((Object)("Looking for xpath by id: " + xpathId));
        Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPathsPart.getJaxbElement(), xpathId);
        if (xpath == null) {
            log.warn((Object)("Couldn't find xpath with id: " + xpathId));
            return null;
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpathExp = xpath.getDataBinding().getXpath(), prefixMappings = xpath.getDataBinding().getPrefixMappings());
        if (r == null) {
            return null;
        }
        try {
            String unescaped = StringEscapeUtils.unescapeHtml((String)r);
            log.info((Object)("Unescaped: " + unescaped));
            NumberingDefinitionsPart ndp = null;
            if (sourcePart instanceof MainDocumentPart) {
                ndp = ((MainDocumentPart)sourcePart).getNumberingDefinitionsPart();
            }
            XHTMLImporter.setHyperlinkStyle(hyperlinkStyleId);
            String baseUrl = null;
            List<Object> results = XHTMLImporter.convert(unescaped, baseUrl, pkg);
            Document docContainer = XmlUtils.neww3cDomDocument();
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            if (results == null) {
                log.error((Object)("Couldn't convert " + unescaped));
                return docfrag;
            }
            log.info((Object)("Got results: " + results.size()));
            if (results.size() > 0 && results.get(0) instanceof P && sdtParent.equals("p")) {
                for (Object o : ((P)results.get(0)).getContent()) {
                    Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(o);
                    XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
                }
            } else {
                for (Object o : results) {
                    String debug = XmlUtils.marshaltoString(o, true);
                    log.info((Object)("Conversion result: " + debug));
                    Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(o);
                    XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
                }
            }
            System.out.println("returning...");
            return docfrag;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static DocumentFragment xpathGenerateRuns(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, String sdtParent, String contentChild, NodeIterator rPrNodeIt, boolean multiLine, String tag) {
        String r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpath, prefixMappings);
        if (r == null) {
            return null;
        }
        Document docContainer = XmlUtils.neww3cDomDocument();
        DocumentFragment docfrag = docContainer.createDocumentFragment();
        try {
            log.info((Object)(xpath + " yielded result " + r));
            RPr rPr = null;
            Node rPrNode = rPrNodeIt.nextNode();
            if (rPrNode != null) {
                rPr = (RPr)XmlUtils.unmarshal(rPrNode);
            }
            ObjectFactory factory = new ObjectFactory();
            StringTokenizer st = new StringTokenizer(r, "\n\r\f");
            if (multiLine) {
                boolean firsttoken = true;
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    if (firsttoken) {
                        firsttoken = false;
                    } else {
                        BindingHandler.addBrRunToDocFrag(docfrag, rPr);
                    }
                    BindingHandler.processString(sourcePart, docfrag, line, rPr);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                while (st.hasMoreTokens()) {
                    sb.append(st.nextToken());
                }
                BindingHandler.processString(sourcePart, docfrag, sb.toString(), rPr);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
        return docfrag;
    }

    private static void addBrRunToDocFrag(DocumentFragment docfrag, RPr rPr) throws JAXBException {
        R run = Context.getWmlObjectFactory().createR();
        if (rPr != null) {
            run.setRPr(rPr);
        }
        run.getRunContent().add(Context.getWmlObjectFactory().createBr());
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    private static void processString(JaxbXmlPart sourcePart, DocumentFragment docfrag, String text, RPr rPr) throws JAXBException {
        int pos3;
        int pos2;
        int NOT_FOUND = 99999;
        int pos1 = text.indexOf("http://") == -1 ? NOT_FOUND : text.indexOf("http://");
        int pos = Math.min(pos1, Math.min(pos2 = text.indexOf("https://") == -1 ? NOT_FOUND : text.indexOf("https://"), pos3 = text.indexOf("mailto:") == -1 ? NOT_FOUND : text.indexOf("mailto:")));
        if (pos == NOT_FOUND || hyperlinkStyleId == null) {
            BindingHandler.addRunToDocFrag(sourcePart, docfrag, text, rPr);
            return;
        }
        if (pos == 0) {
            int spacePos = text.indexOf(" ");
            if (spacePos == -1) {
                BindingHandler.addHyperlinkToDocFrag(sourcePart, docfrag, text);
                return;
            }
            String first = text.substring(0, spacePos);
            String rest = text.substring(spacePos);
            BindingHandler.addHyperlinkToDocFrag(sourcePart, docfrag, first);
            BindingHandler.processString(sourcePart, docfrag, rest, rPr);
            return;
        }
        String first = text.substring(0, pos);
        String rest = text.substring(pos);
        BindingHandler.addRunToDocFrag(sourcePart, docfrag, first, rPr);
        BindingHandler.processString(sourcePart, docfrag, rest, rPr);
    }

    private static void addRunToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String string, RPr rPr) {
        R run = Context.getWmlObjectFactory().createR();
        if (rPr != null) {
            run.setRPr(rPr);
        }
        Text text = Context.getWmlObjectFactory().createText();
        run.getRunContent().add(text);
        if (string.startsWith(" ") || string.endsWith(" ")) {
            text.setSpace("preserve");
        }
        text.setValue(string);
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    private static void addHyperlinkToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String url) throws JAXBException {
        org.docx4j.relationships.ObjectFactory factory = new org.docx4j.relationships.ObjectFactory();
        Relationship rel = factory.createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        rel.setTarget(url);
        rel.setTargetMode("External");
        sourcePart.getRelationshipsPart().addRelationship(rel);
        String hpl = "<w:hyperlink r:id=\"" + rel.getId() + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" " + "xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" >" + "<w:r>" + "<w:rPr>" + "<w:rStyle w:val=\"" + hyperlinkStyleId + "\" />" + "</w:rPr>" + "<w:t>" + url + "</w:t>" + "</w:r>" + "</w:hyperlink>";
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument((P.Hyperlink)XmlUtils.unmarshalString(hpl));
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    public static DocumentFragment xpathInjectImage(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, String sdtParent, String contentChild, String cx, String cy) {
        log.debug((Object)("sdt's parent: " + sdtParent));
        CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error((Object)("Couldn't locate part by storeItemId " + storeItemId));
            return null;
        }
        try {
            String r = part.getData().xpathGetString(xpath, prefixMappings);
            log.debug((Object)(xpath + " yielded result " + r));
            byte[] bytes = Base64.decodeBase64((byte[])r.getBytes("UTF8"));
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wmlPackage, (Part)sourcePart, bytes);
            String filenameHint = null;
            String altText = null;
            int id1 = 0;
            int id2 = 1;
            Inline inline = null;
            long cxl = 0L;
            long cyl = 0L;
            try {
                cxl = Long.parseLong(cx);
                cyl = Long.parseLong(cy);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cxl == 0L || cyl == 0L) {
                log.debug((Object)"image size - from image");
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false);
            } else {
                log.debug((Object)"image size - from content control size");
                ImageSize size = imagePart.getImageInfo().getSize();
                double ratio = (double)size.getHeightPx() / (double)size.getWidthPx();
                log.debug((Object)("fit ratio: " + ratio));
                if (ratio > 1.0) {
                    cxl = (long)((double)cyl / ratio);
                } else {
                    cyl = (long)((double)cxl * ratio);
                }
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cxl, cyl, false);
            }
            ObjectFactory factory = new ObjectFactory();
            Tc tc = factory.createTc();
            P p = factory.createP();
            if (sdtParent.equals("tr")) {
                tc.getContent().add(p);
            }
            R run = factory.createR();
            if (sdtParent.equals("body") || sdtParent.equals("tr") || sdtParent.equals("tc")) {
                p.getContent().add(run);
            }
            Drawing drawing = factory.createDrawing();
            run.getContent().add(drawing);
            drawing.getAnchorOrInline().add(inline);
            Document document = null;
            if (sdtParent.equals("body") || sdtParent.equals("tc")) {
                document = XmlUtils.marshaltoW3CDomDocument(p);
            } else if (sdtParent.equals("tr")) {
                document = XmlUtils.marshaltoW3CDomDocument(tc);
            } else if (sdtParent.equals("p")) {
                document = XmlUtils.marshaltoW3CDomDocument(run);
            } else if (sdtParent.equals("sdtContent")) {
                log.info((Object)("contentChild: " + contentChild));
                if (contentChild.equals("p")) {
                    p.getContent().add(run);
                    document = XmlUtils.marshaltoW3CDomDocument(p);
                } else if (contentChild.equals("r")) {
                    document = XmlUtils.marshaltoW3CDomDocument(r);
                } else {
                    log.error((Object)("how to inject image for unexpected sdt's content: " + contentChild));
                }
            } else {
                log.error((Object)("how to inject image for unexpected sdt's parent: " + sdtParent));
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DocumentFragment xpathGenerateRuns(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, XPathsPart xPathsPart, String odTag, String sdtParent, String contentChild, NodeIterator rPrNodeIt, boolean multiLine) {
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(odTag, true);
        String xpathId = map.get("od:xpath");
        log.info((Object)("Looking for xpath by id: " + xpathId));
        Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPathsPart.getJaxbElement(), xpathId);
        if (xpath == null) {
            log.warn((Object)("Couldn't find xpath with id: " + xpathId));
            return null;
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        return BindingHandler.xpathGenerateRuns(pkg, sourcePart, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings, sdtParent, contentChild, rPrNodeIt, multiLine, odTag);
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/model/datastorage/bind.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        xPathFactory = XPathFactory.newInstance();
        xPath = xPathFactory.newXPath();
        hyperlinkStyleId = null;
    }
}

