/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.DocxFetcher;
import org.docx4j.model.datastorage.InputIntegrityException;
import org.docx4j.model.datastorage.XPathEnhancerParser;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTAltChunk;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTSdtContentCell;
import org.docx4j.wml.CTSdtRow;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.SdtRun;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.opendope.components.Components;
import org.opendope.conditions.Condition;
import org.opendope.conditions.Conditions;
import org.opendope.conditions.Xpathref;
import org.opendope.xpaths.Xpaths;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDoPEHandler {
    private static Logger log = Logger.getLogger(OpenDoPEHandler.class);
    private WordprocessingMLPackage wordMLPackage;
    private ShallowTraversor shallowTraversor;
    public static final String BINDING_ROLE_REPEAT = "od:repeat";
    public static final String BINDING_ROLE_CONDITIONAL = "od:condition";
    public static final String BINDING_ROLE_XPATH = "od:xpath";
    public static final String BINDING_ROLE_COMPONENT = "od:component";
    public static final String BINDING_ROLE_COMPONENT_BEFORE = "od:continuousBefore";
    public static final String BINDING_ROLE_COMPONENT_AFTER = "od:continuousAfter";
    public static final String BINDING_CONTENTTYPE = "od:ContentType";
    private Conditions conditions;
    private Xpaths xPaths;
    private Components components;
    private boolean removeSdtCellsOnFailedCondition;
    private boolean justGotAComponent = false;
    private static DocxFetcher docxFetcher;

    public OpenDoPEHandler(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.wordMLPackage = wordMLPackage;
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        if (wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            throw new Docx4JException("OpenDoPE XPaths part missing");
        }
        this.xPaths = (Xpaths)wordMLPackage.getMainDocumentPart().getXPathsPart().getJaxbElement();
        log.debug((Object)XmlUtils.marshaltoString((Object)this.xPaths, true, true));
        if (wordMLPackage.getMainDocumentPart().getConditionsPart() != null) {
            this.conditions = (Conditions)wordMLPackage.getMainDocumentPart().getConditionsPart().getJaxbElement();
            log.debug((Object)XmlUtils.marshaltoString((Object)this.conditions, true, true));
        }
        if (wordMLPackage.getMainDocumentPart().getComponentsPart() != null) {
            this.components = (Components)wordMLPackage.getMainDocumentPart().getComponentsPart().getJaxbElement();
            log.debug((Object)XmlUtils.marshaltoString((Object)this.components, true, true));
        }
        this.shallowTraversor = new ShallowTraversor();
        this.shallowTraversor.wordMLPackage = wordMLPackage;
    }

    public void setRemoveSdtCellsOnFailedCondition(boolean removeSdtCellsOnFailedCondition) {
        this.removeSdtCellsOnFailedCondition = removeSdtCellsOnFailedCondition;
    }

    public WordprocessingMLPackage preprocess() throws Docx4JException {
        do {
            Set<ContentAccessor> partList = OpenDoPEHandler.getParts(this.wordMLPackage);
            try {
                for (ContentAccessor part : partList) {
                    new TraversalUtil(part, this.shallowTraversor);
                }
            }
            catch (InputIntegrityException iie) {
                throw new Docx4JException(iie.getMessage(), iie);
            }
            for (ContentAccessor part : partList) {
                this.wordMLPackage = this.fetchComponents(this.wordMLPackage, part);
            }
        } while (this.justGotAComponent);
        return this.wordMLPackage;
    }

    public static DocxFetcher getDocxFetcher() {
        return docxFetcher;
    }

    public static void setDocxFetcher(DocxFetcher docxFetcher) {
        OpenDoPEHandler.docxFetcher = docxFetcher;
    }

    protected static Set<ContentAccessor> getParts(WordprocessingMLPackage srcPackage) {
        HashSet<ContentAccessor> partList = new HashSet<ContentAccessor>();
        partList.add(srcPackage.getMainDocumentPart());
        RelationshipsPart rp = srcPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                partList.add((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            partList.add((FooterPart)rp.getPart(r));
        }
        return partList;
    }

    private WordprocessingMLPackage fetchComponents(WordprocessingMLPackage srcPackage, ContentAccessor contentAccessor) throws Docx4JException {
        HashMap<Integer, CTAltChunk> replacements = new HashMap<Integer, CTAltChunk>();
        Integer index = 0;
        this.justGotAComponent = false;
        LinkedList<Integer> continuousBeforeIndex = new LinkedList<Integer>();
        ArrayList<Boolean> continuousBefore = new ArrayList<Boolean>();
        ArrayList<Boolean> continuousAfter = new ArrayList<Boolean>();
        for (Object block : contentAccessor.getContent()) {
            Object tag;
            Object sdt;
            if (block instanceof SdtBlock) {
                sdt = (SdtBlock)block;
                tag = OpenDoPEHandler.getSdtPr(sdt).getTag();
                if (tag == null) {
                    ArrayList<Object> newContent = new ArrayList<Object>();
                    newContent.add(sdt);
                    continue;
                }
                log.info((Object)((Tag)tag).getVal());
                QueryString qs = new QueryString();
                HashMap<String, String> map = QueryString.parseQueryString(((Tag)tag).getVal(), true);
                String componentId = map.get(BINDING_ROLE_COMPONENT);
                if (componentId == null) continue;
                String iri = ComponentsPart.getComponentById(this.components, componentId).getIri();
                log.debug((Object)("Fetching " + iri));
                if (docxFetcher == null) {
                    log.error((Object)"You need a docxFetcher (and the MergeDocx extension) to fetch components");
                    return srcPackage;
                }
                AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(this.getNewPartName("/chunk", ".docx", srcPackage.getMainDocumentPart().getRelationshipsPart()));
                afiPart.setBinaryData(docxFetcher.getDocxFromIRI(iri));
                afiPart.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"));
                Relationship altChunkRel = srcPackage.getMainDocumentPart().addTargetPart(afiPart);
                CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
                ac.setId(altChunkRel.getId());
                replacements.put(index, ac);
                if (map.get(BINDING_ROLE_COMPONENT_BEFORE) != null && map.get(BINDING_ROLE_COMPONENT_BEFORE).equals("true")) {
                    continuousBefore.add(Boolean.TRUE);
                    continuousBeforeIndex.addFirst(index);
                    log.info((Object)("ctsBefore index: " + index));
                } else {
                    continuousBefore.add(Boolean.FALSE);
                    continuousBeforeIndex.addFirst(index);
                }
                if (map.get(BINDING_ROLE_COMPONENT_AFTER) != null && map.get(BINDING_ROLE_COMPONENT_AFTER).equals("true")) {
                    continuousAfter.add(Boolean.TRUE);
                } else {
                    continuousAfter.add(Boolean.TRUE);
                }
                this.justGotAComponent = true;
            }
            sdt = index;
            index = index + 1;
            tag = index;
        }
        if (!this.justGotAComponent) {
            return srcPackage;
        }
        for (Integer key : replacements.keySet()) {
            contentAccessor.getContent().set(key, replacements.get(key));
        }
        List<Object> bodyChildren = contentAccessor.getContent();
        int i = 0;
        for (Integer indexIntoBody : continuousBeforeIndex) {
            if (((Boolean)continuousBefore.get(i)).booleanValue() && indexIntoBody != 0) {
                Object block = bodyChildren.get(indexIntoBody - 1);
                if (block instanceof P && ((P)block).getPPr() != null && ((P)block).getPPr().getSectPr() != null) {
                    this.makeContinuous(((P)block).getPPr().getSectPr());
                } else if (block instanceof P) {
                    PPr ppr = ((P)block).getPPr();
                    if (ppr == null) {
                        ppr = Context.getWmlObjectFactory().createPPr();
                        ((P)block).setPPr(ppr);
                    }
                    SectPr newSectPr = Context.getWmlObjectFactory().createSectPr();
                    SectPr.Type type = Context.getWmlObjectFactory().createSectPrType();
                    type.setVal("continuous");
                    newSectPr.setType(type);
                    ppr.setSectPr(newSectPr);
                } else {
                    P newP = Context.getWmlObjectFactory().createP();
                    PPr ppr = Context.getWmlObjectFactory().createPPr();
                    newP.setPPr(ppr);
                    SectPr newSectPr = Context.getWmlObjectFactory().createSectPr();
                    SectPr.Type type = Context.getWmlObjectFactory().createSectPrType();
                    type.setVal("continuous");
                    newSectPr.setType(type);
                    ppr.setSectPr(newSectPr);
                    bodyChildren.add(indexIntoBody, newP);
                }
            }
            ++i;
        }
        try {
            Class<?> documentBuilder = Class.forName("com.plutext.merge.ProcessAltChunk");
            Method[] methods = documentBuilder.getMethods();
            Method processMethod = null;
            for (int j = 0; j < methods.length; ++j) {
                log.debug((Object)methods[j].getName());
                if (!methods[j].getName().equals("process")) continue;
                processMethod = methods[j];
            }
            if (processMethod == null) {
                throw new NoSuchMethodException();
            }
            return (WordprocessingMLPackage)processMethod.invoke(null, srcPackage);
        }
        catch (ClassNotFoundException e) {
            this.extensionMissing(e);
            this.justGotAComponent = false;
            return srcPackage;
        }
        catch (NoSuchMethodException e) {
            this.extensionMissing(e);
            this.justGotAComponent = false;
            return srcPackage;
        }
        catch (Exception e) {
            throw new Docx4JException("Problem processing w:altChunk", e);
        }
    }

    public void makeContinuous(SectPr sectPr) {
        if (sectPr == null) {
            log.warn((Object)"sectPr was null");
            return;
        }
        SectPr.Type type = Context.getWmlObjectFactory().createSectPrType();
        type.setVal("continuous");
        sectPr.setType(type);
        sectPr.setBidi(null);
        sectPr.setDocGrid(null);
        sectPr.setPaperSrc(null);
        sectPr.setPgBorders(null);
        sectPr.setPgMar(null);
        sectPr.setPgNumType(null);
        sectPr.setPgSz(null);
        sectPr.setPrinterSettings(null);
        sectPr.setSectPrChange(null);
        sectPr.setTitlePg(null);
        sectPr.setVAlign(null);
    }

    private PartName getNewPartName(String prefix, String suffix, RelationshipsPart rp) throws InvalidFormatException {
        PartName proposed = null;
        int i = 1;
        do {
            proposed = i > 1 ? new PartName(prefix + i + suffix) : new PartName(prefix + suffix);
            ++i;
        } while (rp.getRel(proposed) != null);
        return proposed;
    }

    public void extensionMissing(Exception e) {
        log.error((Object)("\n" + e.getClass().getName() + ": " + e.getMessage() + "\n"));
        log.error((Object)"* You don't appear to have the MergeDocx paid extension,");
        log.error((Object)"* which is necessary to merge docx, or process altChunk.");
        log.error((Object)"* Purchases of this extension support the docx4j project.");
        log.error((Object)"* Please visit www.plutext.com if you want to buy it.");
    }

    private List<Object> processBindingRoleIfAny(WordprocessingMLPackage wordMLPackage, Object sdt) {
        log.debug((Object)("Processing " + OpenDoPEHandler.getSdtPr(sdt).getId().getVal()));
        Tag tag = OpenDoPEHandler.getSdtPr(sdt).getTag();
        if (tag == null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        log.info((Object)tag.getVal());
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String conditionId = map.get(BINDING_ROLE_CONDITIONAL);
        String repeatId = map.get(BINDING_ROLE_REPEAT);
        String xp = map.get(BINDING_ROLE_XPATH);
        if (conditionId == null && repeatId == null && xp == null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        HashMap<String, CustomXmlDataStoragePart> customXmlDataStorageParts = wordMLPackage.getCustomXmlDataStorageParts();
        if (conditionId != null) {
            Xpaths.Xpath xpath;
            log.info((Object)("Processing Conditional: " + tag.getVal()));
            Condition c = ConditionsPart.getConditionById(this.conditions, conditionId);
            if (c == null) {
                log.error((Object)("Missing condition " + conditionId));
            }
            if ((xpath = this.getXPathFromCondition(c)) == null) {
                throw new InputIntegrityException("XPath specified in condition '" + c.getId() + "' is missing!");
            }
            String val = BindingHandler.xpathGetString(wordMLPackage, customXmlDataStorageParts, xpath.getDataBinding().getStoreItemID(), xpath.getDataBinding().getXpath(), xpath.getDataBinding().getPrefixMappings());
            log.info((Object)("Got value: " + val));
            if (new Boolean(val).booleanValue()) {
                log.debug((Object)"so keeping");
                ArrayList<Object> newContent = new ArrayList<Object>();
                newContent.add(sdt);
                return newContent;
            }
            return this.eventuallyEmptyList(sdt);
        }
        if (repeatId != null) {
            log.info((Object)("Processing Repeat: " + tag.getVal()));
            List<Object> repeatResult = this.processRepeat(sdt, customXmlDataStorageParts, wordMLPackage.getMainDocumentPart().getXPathsPart());
            if (repeatResult.isEmpty()) {
                return this.eventuallyEmptyList(sdt);
            }
            return repeatResult;
        }
        if (xp != null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        return null;
    }

    private List<Object> eventuallyEmptyList(Object sdt) {
        List<Object> newContent;
        boolean sdtIsSingleCellChild;
        boolean sdtIsCell = sdt instanceof CTSdtCell;
        Object parent = this.obtainParent(sdt);
        int contentChildCount = this.countContentChildren(parent);
        boolean bl = sdtIsSingleCellChild = parent instanceof Tc && contentChildCount == 1;
        if (sdtIsCell && !this.removeSdtCellsOnFailedCondition) {
            CTSdtContentCell sdtCellContent = (CTSdtContentCell)((CTSdtCell)sdt).getSdtContent();
            Tc tc = (Tc)XmlUtils.unwrap(sdtCellContent.getContent().get(0));
            tc.getContent().clear();
            P p = Context.getWmlObjectFactory().createP();
            tc.getContent().add(p);
            newContent = Arrays.asList(tc);
        } else if (sdtIsSingleCellChild) {
            P p = Context.getWmlObjectFactory().createP();
            newContent = Arrays.asList(p);
        } else {
            newContent = Arrays.asList(new Object[0]);
        }
        return newContent;
    }

    private Object obtainParent(Object sdt) {
        if (!(sdt instanceof Child)) {
            throw new IllegalArgumentException("Object of class " + sdt.getClass().getName() + " is not a Child");
        }
        return ((Child)sdt).getParent();
    }

    private int countContentChildren(Object tc) {
        List<Object> selfAndSiblings = this.obtainChildren(tc);
        int contentChildCount = 0;
        for (Object child : selfAndSiblings) {
            if (child instanceof TcPr) continue;
            ++contentChildCount;
        }
        return contentChildCount;
    }

    private List<Object> obtainChildren(Object element) {
        if (element instanceof ContentAccessor) {
            return ((ContentAccessor)element).getContent();
        }
        log.warn((Object)("Don't know how to access the children of " + element.getClass().getName()));
        return Collections.emptyList();
    }

    public Xpaths.Xpath getXPathFromCondition(Condition c) {
        Xpathref xpathRef = c.getXpathref();
        if (xpathRef == null) {
            log.error((Object)("Condition " + c.getId() + " references a missing xpath!"));
        }
        log.info((Object)("Condition references xpath with id " + xpathRef.getId()));
        return XPathsPart.getXPathById(this.xPaths, xpathRef.getId());
    }

    private List<Object> processRepeat(Object sdt, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, XPathsPart xPathsPart) {
        Tag tag = OpenDoPEHandler.getSdtPr(sdt).getTag();
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String repeatId = map.get(BINDING_ROLE_REPEAT);
        if (StringUtils.isEmpty((String)repeatId)) {
            return new ArrayList<Object>();
        }
        Xpaths.Xpath xpathObj = XPathsPart.getXPathById(this.xPaths, repeatId);
        String storeItemId = xpathObj.getDataBinding().getStoreItemID();
        String xpath = xpathObj.getDataBinding().getXpath();
        String prefixMappings = xpathObj.getDataBinding().getPrefixMappings();
        String xpathBase = xpath.endsWith("/") ? xpath.substring(0, xpath.length() - 1) : (xpath.endsWith("[1]") ? xpath.substring(0, xpath.length() - 3) : xpath);
        log.info((Object)("/n/n Repeat: using xpath: " + xpathBase));
        NamespacePrefixMappings nsContext = new NamespacePrefixMappings();
        List<Node> repeatedSiblings = this.xpathGetNodes(customXmlDataStorageParts, storeItemId, xpathBase, prefixMappings);
        int numRepeats = repeatedSiblings.size();
        log.debug((Object)("yields REPEATS: " + numRepeats));
        if (numRepeats == 0) {
            return new ArrayList<Object>();
        }
        List<Object> repeated = this.cloneRepeatSdt(sdt, xpathBase, numRepeats);
        DeepTraversor dt = new DeepTraversor();
        dt.xpathBase = xpathBase;
        for (int i = 0; i < repeated.size(); ++i) {
            log.info((Object)("\n Traversing clone " + i));
            dt.index = i;
            new TraversalUtil(repeated.get(i), dt);
        }
        log.info((Object)".. deep traversals done ");
        return repeated;
    }

    private List<Object> cloneRepeatSdt(Object sdt, String xpathBase, int numRepeats) {
        ArrayList<Object> newContent = new ArrayList<Object>();
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        log.debug((Object)XmlUtils.marshaltoString((Object)sdtPr, true, true));
        CTDataBinding binding = sdtPr.getDataBinding();
        for (int i = 0; i < numRepeats; ++i) {
            if (i > 0 && i == 1) {
                this.emptyRepeatTagValue(sdtPr.getTag());
                if (binding != null) {
                    sdtPr.getRPrOrAliasOrLock().remove(binding);
                }
                sdtPr.setId();
            }
            newContent.add(XmlUtils.deepCopy(sdt));
        }
        return newContent;
    }

    private void emptyRepeatTagValue(Tag tag) {
        String tagVal = tag.getVal();
        Pattern stripRepeatArgPattern = Pattern.compile("(.*od:repeat=)([^&]*)(.*)");
        Matcher stripPatternMatcher = stripRepeatArgPattern.matcher(tagVal);
        if (!stripPatternMatcher.matches()) {
            log.fatal((Object)("Cannot find repeat tag in sdtPr/tag while processing repeat, sth's very wrong with " + tagVal));
            return;
        }
        String emptyRepeatValue = stripPatternMatcher.group(1) + stripPatternMatcher.group(3);
        tag.setVal(emptyRepeatValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processDescendantBindings(Object sdt, String xpathBase, int index) {
        HashMap<String, String> map;
        Tag tag;
        Xpaths.Xpath xpathObj;
        Condition c;
        String repeatId;
        String conditionId;
        String thisXPath;
        CTDataBinding binding;
        block12: {
            String bindingId;
            block13: {
                SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
                sdtPr.setId();
                binding = (CTDataBinding)XmlUtils.unwrap(sdtPr.getDataBinding());
                thisXPath = null;
                conditionId = null;
                repeatId = null;
                bindingId = null;
                c = null;
                xpathObj = null;
                tag = sdtPr.getTag();
                if (tag == null) {
                    return;
                }
                map = QueryString.parseQueryString(tag.getVal(), true);
                if (binding != null) break block13;
                conditionId = map.get(BINDING_ROLE_CONDITIONAL);
                repeatId = map.get(BINDING_ROLE_REPEAT);
                if (conditionId != null) {
                    c = ConditionsPart.getConditionById(this.conditions, conditionId);
                    if (c == null) {
                        log.error((Object)("Missing condition " + conditionId));
                    }
                    log.debug((Object)("Using condition" + XmlUtils.marshaltoString((Object)c, true, true)));
                    xpathObj = this.getXPathFromCondition(c);
                    thisXPath = xpathObj.getDataBinding().getXpath();
                    break block12;
                } else if (repeatId != null) {
                    xpathObj = XPathsPart.getXPathById(this.xPaths, repeatId);
                    thisXPath = xpathObj.getDataBinding().getXpath();
                    break block12;
                } else {
                    if (!map.containsKey(BINDING_CONTENTTYPE)) {
                        log.warn((Object)"couldn't find binding or bindingrole!");
                        return;
                    }
                    xpathObj = XPathsPart.getXPathById(this.xPaths, map.get(BINDING_ROLE_XPATH));
                    thisXPath = xpathObj.getDataBinding().getXpath();
                }
                break block12;
            }
            thisXPath = binding.getXpath();
            if (!thisXPath.equals((xpathObj = XPathsPart.getXPathById(this.xPaths, bindingId = map.get(BINDING_ROLE_XPATH))).getDataBinding().getXpath())) {
                log.error((Object)("XPaths didn't match for id " + bindingId + ": \n\r    " + thisXPath + "\n\rcf. " + xpathObj.getDataBinding().getXpath()));
            }
        }
        String newPath = XPathEnhancerParser.enhanceXPath(xpathBase, index + 1, thisXPath);
        if (log.isDebugEnabled() && !thisXPath.equals(newPath)) {
            log.debug((Object)("xpath prefix enhanced " + thisXPath + " to " + newPath));
        }
        if (binding != null) {
            binding.setXpath(newPath);
            Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
            map.put(BINDING_ROLE_XPATH, newXPathObj.getId());
            tag.setVal(QueryString.create(map));
            return;
        }
        if (conditionId != null) {
            Condition newCondition = XmlUtils.deepCopy(c);
            String newConditionId = conditionId + "_" + index;
            newCondition.setId(newConditionId);
            this.conditions.getCondition().add(newCondition);
            map.put(BINDING_ROLE_CONDITIONAL, newConditionId);
            tag.setVal(QueryString.create(map));
            Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
            newCondition.getXpathref().setId(newXPathObj.getId());
            return;
        }
        if (repeatId != null) {
            Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
            map.put(BINDING_ROLE_REPEAT, newXPathObj.getId());
            tag.setVal(QueryString.create(map));
            return;
        }
        if (!map.containsKey(BINDING_CONTENTTYPE)) return;
        Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
        map.put(BINDING_ROLE_XPATH, newXPathObj.getId());
        tag.setVal(QueryString.create(map));
    }

    private Xpaths.Xpath createNewXPathObject(String newPath, Xpaths.Xpath xpathObj, int index) {
        Xpaths.Xpath newXPathObj = XmlUtils.deepCopy(xpathObj);
        String newXPathId = newXPathObj.getId() + "_" + index;
        newXPathObj.setId(newXPathId);
        newXPathObj.getDataBinding().setXpath(newPath);
        this.xPaths.getXpath().add(newXPathObj);
        return newXPathObj;
    }

    public static SdtPr getSdtPr(Object o) {
        if (o instanceof SdtBlock) {
            return ((SdtBlock)o).getSdtPr();
        }
        if (o instanceof SdtRun) {
            return ((SdtRun)o).getSdtPr();
        }
        if (o instanceof CTSdtRow) {
            return ((CTSdtRow)o).getSdtPr();
        }
        if (o instanceof CTSdtCell) {
            return ((CTSdtCell)o).getSdtPr();
        }
        log.warn((Object)("TODO: Handle " + o.getClass().getName()));
        return null;
    }

    private List<Node> xpathGetNodes(Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error((Object)("Couldn't locate part by storeItemId " + storeItemId));
            return null;
        }
        return part.getData().xpathGetNodes(xpath, prefixMappings);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DeepTraversor
    implements TraversalUtil.Callback {
        int index = 0;
        String xpathBase = null;

        DeepTraversor() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof SdtBlock || o instanceof SdtRun || o instanceof CTSdtRow || o instanceof CTSdtCell) {
                OpenDoPEHandler.this.processDescendantBindings(o, this.xpathBase, this.index);
            }
            return null;
        }

        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    o = XmlUtils.unwrap(o);
                    this.apply(o);
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
            }
        }

        @Override
        public List<Object> getChildren(Object o) {
            return TraversalUtil.getChildrenImpl(o);
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShallowTraversor
    implements TraversalUtil.Callback {
        WordprocessingMLPackage wordMLPackage;

        private ShallowTraversor() {
        }

        @Override
        public List<Object> apply(Object wrapped) throws RuntimeException {
            Object o = XmlUtils.unwrap(wrapped);
            if ((o instanceof SdtBlock || o instanceof SdtRun || o instanceof CTSdtRow || o instanceof CTSdtCell) && OpenDoPEHandler.getSdtPr(o).getDataBinding() == null) {
                return OpenDoPEHandler.this.processBindingRoleIfAny(this.wordMLPackage, o);
            }
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(wrapped);
            return newContent;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return true;
        }

        @Override
        public List<Object> getChildren(Object o) {
            return TraversalUtil.getChildrenImpl(o);
        }

        @Override
        public void walkJAXBElements(Object parent) {
            ArrayList<Object> newChildren = new ArrayList<Object>();
            Object parentUnwrapped = XmlUtils.unwrap(parent);
            List<Object> children = this.getChildren(parentUnwrapped);
            if (children == null) {
                log.warn((Object)("no children: " + parentUnwrapped.getClass().getName()));
                return;
            }
            for (Object o : children) {
                newChildren.addAll(this.apply(o));
            }
            TraversalUtil.replaceChildren(parentUnwrapped, newChildren);
            children = this.getChildren(parentUnwrapped);
            if (children == null) {
                log.warn((Object)("no children: " + parentUnwrapped.getClass().getName()));
            } else {
                for (Object o : children) {
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
            }
        }
    }
}

