/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields.merge;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.docx4j.Docx4jProperties;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.fields.FieldLocator;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.model.fields.FieldsPreprocessor;
import org.docx4j.model.fields.merge.DataFieldName;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTPageNumber;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.SectPr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMerger {
    private static Logger log = Logger.getLogger(MailMerger.class);

    public static WordprocessingMLPackage getConsolidatedResultCrude(WordprocessingMLPackage input, List<Map<DataFieldName, String>> data) throws Docx4JException {
        FieldsPreprocessor.complexifyFields(input.getMainDocumentPart());
        List<List<Object>> results = MailMerger.perform(input.getMainDocumentPart(), data);
        Object result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SaveToZipFile saver = new SaveToZipFile(input);
        saver.save(baos);
        byte[] template = baos.toByteArray();
        WordprocessingMLPackage target = WordprocessingMLPackage.load(new ByteArrayInputStream(template));
        SectPr documentSeparator = MailMerger.getDocumentSeparator(target);
        target.getMainDocumentPart().getContent().clear();
        for (List<Object> content : results) {
            target.getMainDocumentPart().getContent().addAll(content);
            if (((Object)content).equals(results.get(results.size() - 1))) continue;
            Object last = content.get(content.size() - 1);
            P lastP = null;
            if (last instanceof P) {
                lastP = (P)last;
            } else {
                lastP = Context.getWmlObjectFactory().createP();
                target.getMainDocumentPart().getContent().add(lastP);
            }
            if (lastP.getPPr() == null) {
                lastP.setPPr(Context.getWmlObjectFactory().createPPr());
            }
            lastP.getPPr().setSectPr(documentSeparator);
        }
        return target;
    }

    private static SectPr getDocumentSeparator(WordprocessingMLPackage template) {
        CTPageNumber pageNumber;
        List<Object> all;
        Object last;
        SectPr sectPr = ((Document)template.getMainDocumentPart().getJaxbElement()).getBody().getSectPr();
        if (sectPr == null && (last = (all = template.getMainDocumentPart().getContent()).get(all.size() - 1)) instanceof P && ((P)last).getPPr() != null && ((P)last).getPPr().getSectPr() != null) {
            sectPr = ((P)last).getPPr().getSectPr();
        }
        if (sectPr == null) {
            String papersize = Docx4jProperties.getProperties().getProperty("docx4j.PageSize", "A4");
            log.info((Object)("Using paper size: " + papersize));
            String landscapeString = Docx4jProperties.getProperties().getProperty("docx4j.PageOrientationLandscape", "false");
            boolean landscape = Boolean.parseBoolean(landscapeString);
            log.info((Object)("Landscape orientation: " + landscape));
            PageDimensions page = new PageDimensions();
            page.setPgSize(PageSizePaper.valueOf(papersize), landscape);
            sectPr = Context.getWmlObjectFactory().createSectPr();
            sectPr.setPgSz(page.getPgSz());
            sectPr.setPgMar(page.getPgMar());
        }
        if ((pageNumber = sectPr.getPgNumType()) == null) {
            pageNumber = Context.getWmlObjectFactory().createCTPageNumber();
            sectPr.setPgNumType(pageNumber);
        }
        pageNumber.setStart(BigInteger.ONE);
        return sectPr;
    }

    public static List<WordprocessingMLPackage> getResults(WordprocessingMLPackage input, List<Map<DataFieldName, String>> data) throws Docx4JException {
        ArrayList<WordprocessingMLPackage> pkgs = new ArrayList<WordprocessingMLPackage>();
        FieldsPreprocessor.complexifyFields(input.getMainDocumentPart());
        List<List<Object>> results = MailMerger.perform(input.getMainDocumentPart(), data);
        Object result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SaveToZipFile saver = new SaveToZipFile(input);
        saver.save(baos);
        byte[] template = baos.toByteArray();
        for (List<Object> content : results) {
            WordprocessingMLPackage target = WordprocessingMLPackage.load(new ByteArrayInputStream(template));
            pkgs.add(target);
            target.getMainDocumentPart().getContent().clear();
            target.getMainDocumentPart().getContent().addAll(content);
        }
        return pkgs;
    }

    private static List<List<Object>> perform(ContentAccessor contentList, List<Map<DataFieldName, String>> data) throws Docx4JException {
        ArrayList<List<Object>> results = new ArrayList<List<Object>>();
        for (Map<DataFieldName, String> datamap : data) {
            Body shell = Context.getWmlObjectFactory().createBody();
            shell.getContent().addAll(contentList.getContent());
            Body shellClone = XmlUtils.deepCopy(shell);
            FieldLocator fl = new FieldLocator();
            new TraversalUtil(shellClone, fl);
            log.info((Object)("Found " + fl.getStarts().size() + " fields "));
            ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
            for (P p : fl.getStarts()) {
                int index = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
                P newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                System.out.println("NewP length: " + newP.getContent().size());
                ((ContentAccessor)p.getParent()).getContent().set(index, newP);
            }
            for (FieldRef fr : fieldRefs) {
                String instr = fr.getInstr();
                if (!MailMerger.isMergeField(instr)) continue;
                String tmp = instr.substring(instr.indexOf("MERGEFIELD") + 10);
                String key = (tmp = tmp.trim()).indexOf(" ") > -1 ? tmp.substring(0, tmp.indexOf(" ")) : tmp;
                log.info((Object)("Key: '" + key + "'"));
                String val = datamap.get(new DataFieldName(key));
                if (val == null) {
                    log.warn((Object)("Couldn't find value for key: '" + key + "'"));
                } else {
                    fr.setResult(val);
                }
                fr.getParent().getContent().remove(fr.getBeginRun());
                fr.getParent().getContent().remove(fr.getEndRun());
            }
            results.add(shellClone.getContent());
        }
        return results;
    }

    public static boolean isMergeField(String type) {
        return type.contains("MERGEFIELD");
    }

    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(System.getProperty("user.dir") + "/src/test/resources/MERGEFIELD.docx"));
        ArrayList<Map<DataFieldName, String>> data = new ArrayList<Map<DataFieldName, String>>();
        HashMap<DataFieldName, String> map = new HashMap<DataFieldName, String>();
        map.put(new DataFieldName("KundenNAme"), "Daffy duck");
        map.put(new DataFieldName("Kundenname"), "Plutext");
        map.put(new DataFieldName("Kundenstrasse"), "Bourke Street");
        data.add(map);
        map = new HashMap();
        map.put(new DataFieldName("Kundenname"), "Jason");
        map.put(new DataFieldName("Kundenstrasse"), "Collins Street");
        data.add(map);
        System.out.println(XmlUtils.marshaltoString(wordMLPackage.getMainDocumentPart().getJaxbElement(), true, true));
        WordprocessingMLPackage output = MailMerger.getConsolidatedResultCrude(wordMLPackage, data);
        System.out.println(XmlUtils.marshaltoString(output.getMainDocumentPart().getJaxbElement(), true, true));
        output.save(new File(System.getProperty("user.dir") + "/mergefield1-OUT.docx"));
    }
}

