/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.images;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafileEmfPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafileWmfPart;
import org.docx4j.relationships.Relationship;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractWordXmlPicture {
    protected static Logger log = Logger.getLogger(AbstractWordXmlPicture.class);
    WordprocessingMLPackage wmlPackage;
    protected Dimensions dimensions;
    private BinaryPart metaFile;
    protected static final String IMAGE_URL = "http://docxwave.appspot.com/image?";
    protected String hlinkRef;
    protected String targetFrame;
    protected String tooltip;
    protected String alt;
    protected String id;
    private String src;
    protected String style;
    protected String pType;

    public static DocumentFragment getHtmlDocumentFragment(AbstractWordXmlPicture picture) {
        Document d;
        DocumentFragment docfrag;
        block12: {
            docfrag = null;
            d = null;
            try {
                if (picture == null) {
                    log.warn((Object)"picture was null!");
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    try {
                        d = factory.newDocumentBuilder().newDocument();
                    }
                    catch (ParserConfigurationException e1) {
                        e1.printStackTrace();
                    }
                    Element span = d.createElement("span");
                    span.setAttribute("style", "color:red;");
                    d.appendChild(span);
                    Text err = d.createTextNode("[null img]");
                    span.appendChild(err);
                    break block12;
                }
                if (picture.metaFile == null) {
                    d = picture.createHtmlImageElement();
                } else if (picture.metaFile instanceof MetafileWmfPart) {
                    MetafileWmfPart.SvgDocument svgdoc = ((MetafileWmfPart)picture.metaFile).toSVG();
                    d = svgdoc.getDomDocument();
                } else if (picture.metaFile instanceof MetafileEmfPart) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    d = factory.newDocumentBuilder().newDocument();
                    Element span = d.createElement("span");
                    d.appendChild(span);
                    Text err = d.createTextNode("[TODO emf image]");
                    span.appendChild(err);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    d = factory.newDocumentBuilder().newDocument();
                }
                catch (ParserConfigurationException e1) {
                    e1.printStackTrace();
                }
                Element span = d.createElement("span");
                span.setAttribute("style", "color:red;");
                d.appendChild(span);
                Text err = d.createTextNode(e.getMessage());
                span.appendChild(err);
            }
        }
        docfrag = d.createDocumentFragment();
        docfrag.appendChild(d.getDocumentElement());
        return docfrag;
    }

    public Document createHtmlImageElement() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document document = factory.newDocumentBuilder().newDocument();
            Element imageElement = document.createElement("img");
            if (this.src != null && !this.src.equals("")) {
                imageElement.setAttribute("src", this.src);
            }
            if (this.id != null && !this.id.equals("")) {
                imageElement.setAttribute("id", this.id);
            }
            if (this.alt != null && !this.alt.equals("")) {
                imageElement.setAttribute("alt", this.alt);
            }
            if (this.style != null && !this.style.equals("")) {
                imageElement.setAttribute("style", this.style);
            }
            if (this.dimensions.width > 0) {
                imageElement.setAttribute("width", Integer.toString(this.dimensions.width));
            }
            if (this.dimensions.height > 0) {
                imageElement.setAttribute("height", Integer.toString(this.dimensions.height));
            }
            if (this.hlinkRef != null && !this.hlinkRef.equals("")) {
                Element linkElement = document.createElement("a");
                linkElement.setAttribute("href", this.hlinkRef);
                if (this.targetFrame != null && !this.targetFrame.equals("")) {
                    linkElement.setAttribute("target", this.targetFrame);
                }
                if (this.tooltip != null && !this.tooltip.equals("")) {
                    linkElement.setAttribute("title", this.tooltip);
                }
                linkElement.appendChild(imageElement);
                imageElement = linkElement;
            }
            document.appendChild(imageElement);
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return null;
        }
    }

    protected Document createXslFoImageElement() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document document = factory.newDocumentBuilder().newDocument();
            Element imageElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:external-graphic");
            if (this.src != null && !this.src.equals("")) {
                imageElement.setAttribute("src", this.src);
            } else {
                log.error((Object)"@src missing!");
            }
            if (this.dimensions.width > 0) {
                imageElement.setAttribute("content-width", Integer.toString(this.dimensions.width) + this.dimensions.widthUnit);
            }
            if (this.dimensions.height > 0) {
                imageElement.setAttribute("content-height", Integer.toString(this.dimensions.height) + this.dimensions.heightUnit);
            }
            document.appendChild(imageElement);
            return document;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    protected void handleImageRel(ConversionImageHandler imageHandler, String imgRelId, Part sourcePart) {
        Relationship rel = sourcePart.getRelationshipsPart().getRelationshipByID(imgRelId);
        Part part = null;
        String uri = null;
        boolean ignoreImage = false;
        this.setID(imgRelId);
        part = sourcePart.getRelationshipsPart().getPart(rel);
        if (part != null && !(part instanceof BinaryPart)) {
            log.error((Object)("Invalid part type id: " + imgRelId + ", class = " + part.getClass().getName()));
            ignoreImage = true;
        }
        if (!ignoreImage && (uri = this.handlePart(imageHandler, this, rel, (BinaryPart)part)) != null) {
            this.setSrc(uri);
        }
    }

    protected String handlePart(ConversionImageHandler imageHandler, AbstractWordXmlPicture picture, Relationship relationship, BinaryPart binaryPart) {
        String uri = null;
        try {
            uri = imageHandler.handleImage(picture, relationship, binaryPart);
        }
        catch (Docx4JException de) {
            if (relationship != null) {
                log.error((Object)("Exception handling image id: " + relationship.getId() + ", target '" + relationship.getTarget() + "': " + de.toString()), (Throwable)de);
            }
            log.error((Object)("Exception handling image: " + de.toString()), (Throwable)de);
        }
        return uri;
    }

    public String getHlinkReference() {
        return this.hlinkRef;
    }

    public void setHlinkReference(String value) {
        this.hlinkRef = value;
    }

    public String getTargetFrame() {
        return this.targetFrame;
    }

    public void setTargetFrame(String value) {
        this.targetFrame = value;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String value) {
        this.tooltip = value;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String value) {
        this.alt = value;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String value) {
        this.id = value;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String value) {
        this.src = value;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String value) {
        this.style = value;
    }

    public String getPType() {
        return this.pType;
    }

    public void setPType(String value) {
        this.pType = value;
    }

    public class Dimensions {
        public int height;
        public String heightUnit;
        public int width;
        public String widthUnit;
    }
}

